/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import java.io.InputStream;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.tools.FitZoom;
import org.achartengine.tools.Pan;
import org.achartengine.tools.Zoom;

public class GraphicalView
extends View {
    private AbstractChart mChart;
    private XYMultipleSeriesRenderer mRenderer;
    private Rect mRect = new Rect();
    private Handler mHandler;
    private float oldX;
    private float oldY;
    private float oldX2;
    private float oldY2;
    private RectF zoomR = new RectF();
    private Bitmap zoomInImage;
    private Bitmap zoomOutImage;
    private Bitmap fitZoomImage;
    private static final int ZOOM_SIZE = 45;
    private static final int ZOOM_BUTTONS_COLOR = Color.argb((int)175, (int)150, (int)150, (int)150);
    private Pan pan;
    private Zoom zoomIn;
    private Zoom zoomOut;
    private Zoom pinchZoom;
    private FitZoom fitZoom;
    private Paint mPaint = new Paint();

    public GraphicalView(Context context, AbstractChart abstractChart) {
        super(context);
        this.mChart = abstractChart;
        this.mHandler = new Handler();
        if (this.mChart instanceof XYChart) {
            this.zoomInImage = BitmapFactory.decodeStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("image/zoom_in.png"));
            this.zoomOutImage = BitmapFactory.decodeStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("image/zoom_out.png"));
            this.fitZoomImage = BitmapFactory.decodeStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("image/zoom-1.png"));
            this.mRenderer = ((XYChart)this.mChart).getRenderer();
            if (this.mRenderer.getMarginsColor() == 0) {
                this.mRenderer.setMarginsColor(this.mPaint.getColor());
            }
            if (this.mRenderer.isPanXEnabled() || this.mRenderer.isPanYEnabled()) {
                this.pan = new Pan((XYChart)this.mChart);
            }
            if (this.mRenderer.isZoomXEnabled() || this.mRenderer.isZoomYEnabled()) {
                this.zoomIn = new Zoom((XYChart)this.mChart, true, this.mRenderer.getZoomRate());
                this.zoomOut = new Zoom((XYChart)this.mChart, false, this.mRenderer.getZoomRate());
                this.fitZoom = new FitZoom((XYChart)this.mChart);
                this.pinchZoom = new Zoom((XYChart)this.mChart, true, 1.0f);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.getClipBounds(this.mRect);
        int n = this.mRect.top;
        int n2 = this.mRect.left;
        int n3 = this.mRect.width();
        int n4 = this.mRect.height();
        this.mChart.draw(canvas, n2, n, n3, n4, this.mPaint);
        if (this.mRenderer != null && (this.mRenderer.isZoomXEnabled() || this.mRenderer.isZoomYEnabled())) {
            this.mPaint.setColor(ZOOM_BUTTONS_COLOR);
            this.zoomR.set((float)(n2 + n3 - 135), (float)(n + n4) - 34.875f, (float)(n2 + n3), (float)(n + n4));
            canvas.drawRoundRect(this.zoomR, 15.0f, 15.0f, this.mPaint);
            float f = (float)(n + n4) - 28.125f;
            canvas.drawBitmap(this.zoomInImage, (float)(n2 + n3) - 123.75f, f, null);
            canvas.drawBitmap(this.zoomOutImage, (float)(n2 + n3) - 78.75f, f, null);
            canvas.drawBitmap(this.fitZoomImage, (float)(n2 + n3) - 33.75f, f, null);
        }
    }

    public void handleTouch(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (this.mRenderer != null && n == 2) {
            if (this.oldX >= 0.0f || this.oldY >= 0.0f) {
                float f = motionEvent.getX(0);
                float f2 = motionEvent.getY(0);
                if (motionEvent.getPointerCount() > 1 && (this.oldX2 >= 0.0f || this.oldY2 >= 0.0f) && (this.mRenderer.isZoomXEnabled() || this.mRenderer.isZoomYEnabled())) {
                    float f3 = motionEvent.getX(1);
                    float f4 = motionEvent.getY(1);
                    float f5 = Math.abs(f - f3);
                    float f6 = Math.abs(f2 - f4);
                    float f7 = Math.abs(this.oldX - this.oldX2);
                    float f8 = Math.abs(this.oldY - this.oldY2);
                    float f9 = 1.0f;
                    f9 = Math.abs(f - this.oldX) >= Math.abs(f2 - this.oldY) ? f5 / f7 : f6 / f8;
                    if ((double)f9 > 0.909 && (double)f9 < 1.1) {
                        this.pinchZoom.setZoomRate(f9);
                        this.pinchZoom.apply();
                    }
                    this.oldX2 = f3;
                    this.oldY2 = f4;
                } else if (this.mRenderer.isPanXEnabled() || this.mRenderer.isPanYEnabled()) {
                    this.pan.apply(this.oldX, this.oldY, f, f2);
                    this.oldX2 = 0.0f;
                    this.oldY2 = 0.0f;
                }
                this.oldX = f;
                this.oldY = f2;
                this.repaint();
            }
        } else if (n == 0) {
            this.oldX = motionEvent.getX(0);
            this.oldY = motionEvent.getY(0);
            if (this.mRenderer != null && (this.mRenderer.isZoomXEnabled() || this.mRenderer.isZoomYEnabled()) && this.zoomR.contains(this.oldX, this.oldY)) {
                if (this.oldX < this.zoomR.left + this.zoomR.width() / 3.0f) {
                    this.zoomIn.apply();
                } else if (this.oldX < this.zoomR.left + this.zoomR.width() * 2.0f / 3.0f) {
                    this.zoomOut.apply();
                } else {
                    this.fitZoom.apply();
                }
            }
        } else if (n == 1 || n == 6) {
            this.oldX = 0.0f;
            this.oldY = 0.0f;
            this.oldX2 = 0.0f;
            this.oldY2 = 0.0f;
            if (n == 6) {
                this.oldX = -1.0f;
                this.oldY = -1.0f;
            }
        }
    }

    public void setZoomRate(float f) {
        if (this.zoomIn != null && this.zoomOut != null) {
            this.zoomIn.setZoomRate(f);
            this.zoomOut.setZoomRate(f);
        }
    }

    public void zoomIn() {
        if (this.zoomIn != null) {
            this.zoomIn.apply();
            this.repaint();
        }
    }

    public void zoomOut() {
        if (this.zoomOut != null) {
            this.zoomOut.apply();
            this.repaint();
        }
    }

    public void zoomReset() {
        if (this.fitZoom != null) {
            this.fitZoom.apply();
            this.repaint();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mRenderer != null && (this.mRenderer.isPanXEnabled() || this.mRenderer.isPanYEnabled() || this.mRenderer.isZoomXEnabled() || this.mRenderer.isZoomYEnabled())) {
            this.handleTouch(motionEvent);
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void repaint() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.invalidate();
            }
        });
    }

    public void repaint(final int n, final int n2, final int n3, final int n4) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.invalidate(n, n2, n3, n4);
            }
        });
    }
}

