/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class BarChart
extends XYChart {
    private static final int SHAPE_WIDTH = 12;
    protected Type mType = Type.DEFAULT;

    public BarChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, Type type) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.mType = type;
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n) {
        int n2 = this.mDataset.getSeriesCount();
        int n3 = fArray.length;
        paint.setColor(simpleSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float f2 = this.getHalfDiffX(fArray, n3, n2);
        for (int i = 0; i < n3; i += 2) {
            float f3 = fArray[i];
            float f4 = fArray[i + 1];
            if (this.mType == Type.STACKED) {
                canvas.drawRect(f3 - f2, f4, f3 + f2, f, paint);
                continue;
            }
            float f5 = f3 - (float)n2 * f2 + (float)(n * 2) * f2;
            canvas.drawRect(f5, f4, f5 + 2.0f * f2, f, paint);
        }
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, Paint paint, float[] fArray, int n) {
        int n2 = this.mDataset.getSeriesCount();
        float f = this.getHalfDiffX(fArray, fArray.length, n2);
        for (int i = 0; i < fArray.length; i += 2) {
            float f2 = fArray[i];
            if (this.mType == Type.DEFAULT) {
                f2 += (float)(n * 2) * f - ((float)n2 - 1.5f) * f;
            }
            this.drawText(canvas, this.getLabel(xYSeries.getY(i / 2)), f2, fArray[i + 1] - 3.5f, paint, 0.0f);
        }
    }

    @Override
    public int getLegendShapeWidth() {
        return 12;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, Paint paint) {
        float f3 = 6.0f;
        canvas.drawRect(f, f2 - f3, f + 12.0f, f2 + f3, paint);
    }

    protected float getHalfDiffX(float[] fArray, int n, int n2) {
        float f = (fArray[n - 2] - fArray[0]) / (float)n;
        if (f == 0.0f) {
            f = 10.0f;
        }
        if (this.mType != Type.STACKED) {
            f /= (float)n2;
        }
        return (float)((double)f / ((double)this.getCoeficient() * (1.0 + this.mRenderer.getBarsSpacing())));
    }

    protected float getCoeficient() {
        return 1.0f;
    }

    @Override
    public double getDefaultMinimum() {
        return 0.0;
    }

    public static enum Type {
        DEFAULT,
        STACKED;

    }
}

