/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.AbstractChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.renderer.DialRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;

public class DialChart
extends AbstractChart {
    private static final int SHAPE_WIDTH = 10;
    private static final int NEEDLE_RADIUS = 10;
    private CategorySeries mDataset;
    private DialRenderer mRenderer;

    public DialChart(CategorySeries categorySeries, DialRenderer dialRenderer) {
        this.mDataset = categorySeries;
        this.mRenderer = dialRenderer;
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        double d;
        int n5;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int n6 = this.mRenderer.getLegendHeight();
        if (this.mRenderer.isShowLegend() && n6 == 0) {
            n6 = n4 / 5;
        }
        int n7 = n + 15;
        int n8 = n2 + 5;
        int n9 = n + n3 - 5;
        int n10 = n2 + n4 - n6;
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint, false, 0);
        int n11 = this.mDataset.getItemCount();
        double d2 = 0.0;
        String[] stringArray = new String[n11];
        for (n5 = 0; n5 < n11; ++n5) {
            d2 += this.mDataset.getValue(n5);
            stringArray[n5] = this.mDataset.getCategory(n5);
        }
        n5 = Math.min(Math.abs(n9 - n7), Math.abs(n10 - n8));
        int n12 = (int)((double)n5 * 0.35);
        int n13 = (n7 + n9) / 2;
        int n14 = (n10 + n8) / 2;
        float f = (float)n12 * 0.9f;
        float f2 = (float)n12 * 1.1f;
        double d3 = this.mRenderer.getMinValue();
        double d4 = this.mRenderer.getMaxValue();
        double d5 = this.mRenderer.getAngleMin();
        double d6 = this.mRenderer.getAngleMax();
        if (!this.mRenderer.isMinValueSet() || !this.mRenderer.isMaxValueSet()) {
            int n15 = this.mRenderer.getSeriesRendererCount();
            for (int i = 0; i < n15; ++i) {
                d = this.mDataset.getValue(i);
                if (!this.mRenderer.isMinValueSet()) {
                    d3 = Math.min(d3, d);
                }
                if (this.mRenderer.isMaxValueSet()) continue;
                d4 = Math.max(d4, d);
            }
        }
        if (d3 == d4) {
            d3 *= 0.5;
            d4 *= 1.5;
        }
        paint.setColor(this.mRenderer.getLabelsColor());
        double d7 = this.mRenderer.getMinorTicksSpacing();
        d = this.mRenderer.getMajorTicksSpacing();
        if (d7 == Double.MAX_VALUE) {
            d7 = (d4 - d3) / 30.0;
        }
        if (d == Double.MAX_VALUE) {
            d = (d4 - d3) / 10.0;
        }
        this.drawTicks(canvas, d3, d4, d5, d6, n13, n14, f2, n12, d7, paint, false);
        this.drawTicks(canvas, d3, d4, d5, d6, n13, n14, f2, f, d, paint, true);
        int n16 = this.mRenderer.getSeriesRendererCount();
        for (int i = 0; i < n16; ++i) {
            double d8 = this.getAngleForValue(this.mDataset.getValue(i), d5, d6, d3, d4);
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            boolean bl = this.mRenderer.getVisualTypeForIndex(i) == DialRenderer.Type.ARROW;
            this.drawNeedle(canvas, d8, n13, n14, f, bl, paint);
        }
        this.drawLegend(canvas, this.mRenderer, stringArray, n7, n9, n2, n3, n4, n6, paint);
    }

    private double getAngleForValue(double d, double d2, double d3, double d4, double d5) {
        double d6 = d3 - d2;
        double d7 = d5 - d4;
        return Math.toRadians(d2 + (d - d4) * d6 / d7);
    }

    private void drawTicks(Canvas canvas, double d, double d2, double d3, double d4, int n, int n2, double d5, double d6, double d7, Paint paint, boolean bl) {
        for (double d8 = d; d8 <= d2; d8 += d7) {
            double d9 = this.getAngleForValue(d8, d3, d4, d, d2);
            double d10 = Math.sin(d9);
            double d11 = Math.cos(d9);
            int n3 = Math.round((float)n + (float)(d6 * d10));
            int n4 = Math.round((float)n2 + (float)(d6 * d11));
            int n5 = Math.round((float)n + (float)(d5 * d10));
            int n6 = Math.round((float)n2 + (float)(d5 * d11));
            canvas.drawLine((float)n3, (float)n4, (float)n5, (float)n6, paint);
            if (!bl) continue;
            paint.setTextAlign(Paint.Align.LEFT);
            if (n3 <= n5) {
                paint.setTextAlign(Paint.Align.RIGHT);
            }
            String string = d8 + "";
            if (Math.round(d8) == (long)d8) {
                string = (long)d8 + "";
            }
            canvas.drawText(string, (float)n3, (float)n4, paint);
        }
    }

    private void drawNeedle(Canvas canvas, double d, int n, int n2, double d2, boolean bl, Paint paint) {
        float[] fArray;
        double d3 = Math.toRadians(90.0);
        int n3 = (int)(10.0 * Math.sin(d - d3));
        int n4 = (int)(10.0 * Math.cos(d - d3));
        int n5 = (int)(d2 * Math.sin(d));
        int n6 = (int)(d2 * Math.cos(d));
        int n7 = n + n5;
        int n8 = n2 + n6;
        if (bl) {
            int n9 = n + (int)(d2 * 0.85 * Math.sin(d));
            int n10 = n2 + (int)(d2 * 0.85 * Math.cos(d));
            fArray = new float[]{n9 - n3, n10 - n4, n7, n8, n9 + n3, n10 + n4};
            float f = paint.getStrokeWidth();
            paint.setStrokeWidth(5.0f);
            canvas.drawLine((float)n, (float)n2, (float)n7, (float)n8, paint);
            paint.setStrokeWidth(f);
        } else {
            fArray = new float[]{n - n3, n2 - n4, n7, n8, n + n3, n2 + n4};
        }
        this.drawPath(canvas, fArray, paint, true);
    }

    @Override
    public int getLegendShapeWidth() {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, Paint paint) {
        canvas.drawRect(f, f2 - 5.0f, f + 10.0f, f2 + 5.0f, paint);
    }
}

