/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import org.achartengine.chart.XYChart;
import org.achartengine.model.XYSeries;
import org.achartengine.tools.AbstractTool;

public class FitZoom
extends AbstractTool {
    public FitZoom(XYChart xYChart) {
        super(xYChart);
    }

    public void apply() {
        if (this.mChart.getDataset() == null) {
            return;
        }
        if (this.mRenderer.isInitialRangeSet()) {
            this.mRenderer.setRange(this.mRenderer.getInitialRange());
        } else {
            XYSeries[] xYSeriesArray = this.mChart.getDataset().getSeries();
            double[] dArray = null;
            int n = xYSeriesArray.length;
            if (n > 0) {
                dArray = new double[]{xYSeriesArray[0].getMinX(), xYSeriesArray[0].getMaxX(), Math.min(this.mChart.getDefaultMinimum(), xYSeriesArray[0].getMinY()), xYSeriesArray[0].getMaxY()};
                for (int i = 1; i < n; ++i) {
                    dArray[0] = Math.min(dArray[0], xYSeriesArray[i].getMinX());
                    dArray[1] = Math.max(dArray[1], xYSeriesArray[i].getMaxX());
                    dArray[2] = Math.min(dArray[2], xYSeriesArray[i].getMinY());
                    dArray[3] = Math.max(dArray[3], xYSeriesArray[i].getMaxY());
                }
                double d = Math.abs(dArray[1] - dArray[0]) / 40.0;
                double d2 = Math.abs(dArray[3] - dArray[2]) / 40.0;
                this.mRenderer.setRange(new double[]{dArray[0] - d, dArray[1] + d, dArray[2] - d2, dArray[3] + d2});
            }
        }
    }
}

