/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;

public class DataPacketExtension
implements PacketExtension {
    public static final String ELEMENT_NAME = "data";
    private final String sessionID;
    private final long seq;
    private final String data;
    private byte[] decodedData;

    public DataPacketExtension(String string, long l, String string2) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("Session ID must not be null or empty");
        }
        if (l < 0L || l > 65535L) {
            throw new IllegalArgumentException("Sequence must not be between 0 and 65535");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        this.sessionID = string;
        this.seq = l;
        this.data = string2;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public long getSeq() {
        return this.seq;
    }

    public String getData() {
        return this.data;
    }

    public byte[] getDecodedData() {
        if (this.decodedData != null) {
            return this.decodedData;
        }
        if (this.data.matches(".*={1,2}+.+")) {
            return null;
        }
        this.decodedData = StringUtils.decodeBase64(this.data);
        return this.decodedData;
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return "http://jabber.org/protocol/ibb";
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(this.getElementName());
        stringBuilder.append(" ");
        stringBuilder.append("xmlns=\"");
        stringBuilder.append("http://jabber.org/protocol/ibb");
        stringBuilder.append("\" ");
        stringBuilder.append("seq=\"");
        stringBuilder.append(this.seq);
        stringBuilder.append("\" ");
        stringBuilder.append("sid=\"");
        stringBuilder.append(this.sessionID);
        stringBuilder.append("\">");
        stringBuilder.append(this.data);
        stringBuilder.append("</");
        stringBuilder.append(this.getElementName());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

