/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverInfo
extends IQ {
    private final List<Feature> features = new CopyOnWriteArrayList<Feature>();
    private final List<Identity> identities = new CopyOnWriteArrayList<Identity>();
    private String node;

    public void addFeature(String string) {
        this.addFeature(new Feature(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFeature(Feature feature) {
        List<Feature> list = this.features;
        synchronized (list) {
            this.features.add(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Feature> getFeatures() {
        List<Feature> list = this.features;
        synchronized (list) {
            return Collections.unmodifiableList(this.features).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(Identity identity) {
        List<Identity> list = this.identities;
        synchronized (list) {
            this.identities.add(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Identity> getIdentities() {
        List<Identity> list = this.identities;
        synchronized (list) {
            return Collections.unmodifiableList(this.identities).iterator();
        }
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String string) {
        this.node = string;
    }

    public boolean containsFeature(String string) {
        Iterator<Feature> iterator = this.getFeatures();
        while (iterator.hasNext()) {
            if (!string.equals(iterator.next().getVar())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"http://jabber.org/protocol/disco#info\"");
        if (this.getNode() != null) {
            stringBuilder.append(" node=\"");
            stringBuilder.append(this.getNode());
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        List<Object> list = this.identities;
        synchronized (list) {
            for (Identity object : this.identities) {
                stringBuilder.append(object.toXML());
            }
        }
        list = this.features;
        synchronized (list) {
            for (Feature feature : this.features) {
                stringBuilder.append(feature.toXML());
            }
        }
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoverInfo clone() {
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setNode(this.getNode());
        Object object = this.features;
        synchronized (object) {
            for (Feature feature : this.features) {
                discoverInfo.addFeature(feature);
            }
        }
        object = this.identities;
        synchronized (object) {
            for (Identity identity : this.identities) {
                discoverInfo.addIdentity(identity);
            }
        }
        for (PacketExtension packetExtension : this.getExtensions()) {
            discoverInfo.addExtension(packetExtension);
        }
        return discoverInfo;
    }

    public static class Feature {
        private String variable;

        public Feature(String string) {
            this.variable = string;
        }

        public String getVar() {
            return this.variable;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<feature var=\"").append(this.variable).append("\"/>");
            return stringBuilder.toString();
        }
    }

    public static class Identity {
        private String category;
        private String name;
        private String type;

        public Identity(String string, String string2) {
            this.category = string;
            this.name = string2;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<identity category=\"").append(this.category).append("\"");
            stringBuilder.append(" name=\"").append(this.name).append("\"");
            if (this.type != null) {
                stringBuilder.append(" type=\"").append(this.type).append("\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }
}

