/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.HashtableBase;
import com.db4o.foundation.HashtableByteArrayEntry;
import com.db4o.foundation.HashtableIntEntry;
import com.db4o.foundation.HashtableLongEntry;
import com.db4o.foundation.HashtableObjectEntry;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Map4;
import com.db4o.foundation.Visitor4;

public class Hashtable4
extends HashtableBase
implements DeepClone,
Map4 {
    public Hashtable4(int size) {
        super(size);
    }

    public Hashtable4() {
        this(1);
    }

    protected Hashtable4(DeepClone cloneOnlyCtor) {
        super(cloneOnlyCtor);
    }

    public Object deepClone(Object obj) {
        return this.deepCloneInternal(new Hashtable4(null), obj);
    }

    public void forEachKeyForIdentity(Visitor4 visitor, Object obj) {
        for (int i = 0; i < this._table.length; ++i) {
            HashtableIntEntry entry = this._table[i];
            while (entry != null) {
                if (entry._object == obj) {
                    visitor.visit(entry.key());
                }
                entry = entry._next;
            }
        }
    }

    public Object get(byte[] key) {
        int intKey = HashtableByteArrayEntry.hash(key);
        return this.getFromObjectEntry(intKey, key);
    }

    public Object get(int key) {
        HashtableIntEntry entry = this._table[key & this._mask];
        while (entry != null) {
            if (entry._key == key) {
                return entry._object;
            }
            entry = entry._next;
        }
        return null;
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.getFromObjectEntry(key.hashCode(), key);
    }

    public Object get(long key) {
        return this.getFromLongEntry((int)key, key);
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            return false;
        }
        return null != this.getObjectEntry(key.hashCode(), key);
    }

    public boolean containsAllKeys(Iterable4 collection) {
        return this.containsAllKeys(collection.iterator());
    }

    public boolean containsAllKeys(Iterator4 iterator) {
        while (iterator.moveNext()) {
            if (this.containsKey(iterator.current())) continue;
            return false;
        }
        return true;
    }

    public void put(byte[] key, Object value) {
        this.putEntry(new HashtableByteArrayEntry(key, value));
    }

    public void put(int key, Object value) {
        this.putEntry(new HashtableIntEntry(key, value));
    }

    public void put(long key, Object value) {
        this.putEntry(new HashtableLongEntry(key, value));
    }

    public void put(Object key, Object value) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        this.putEntry(new HashtableObjectEntry(key, value));
    }

    public Object remove(Object objectKey) {
        int intKey = objectKey.hashCode();
        return this.removeObjectEntry(intKey, objectKey);
    }

    public Object remove(long longKey) {
        return this.removeLongEntry((int)longKey, longKey);
    }

    public Object remove(byte[] key) {
        int intKey = HashtableByteArrayEntry.hash(key);
        return this.removeObjectEntry(intKey, key);
    }

    public Object remove(int key) {
        return this.removeIntEntry(key);
    }

    public Iterator4 iterator() {
        return this.hashtableIterator();
    }

    protected Hashtable4 deepCloneInternal(Hashtable4 ret, Object obj) {
        ret._mask = this._mask;
        ret._maximumSize = this._maximumSize;
        ret._size = this._size;
        ret._tableSize = this._tableSize;
        ret._table = new HashtableIntEntry[this._tableSize];
        for (int i = 0; i < this._tableSize; ++i) {
            if (this._table[i] == null) continue;
            ret._table[i] = (HashtableIntEntry)this._table[i].deepClone(obj);
        }
        return ret;
    }

    private Object getFromObjectEntry(int intKey, Object objectKey) {
        HashtableObjectEntry entry = this.getObjectEntry(intKey, objectKey);
        return entry == null ? null : entry._object;
    }

    private HashtableObjectEntry getObjectEntry(int intKey, Object objectKey) {
        HashtableObjectEntry entry = (HashtableObjectEntry)this._table[intKey & this._mask];
        while (entry != null) {
            if (entry._key == intKey && entry.hasKey(objectKey)) {
                return entry;
            }
            entry = (HashtableObjectEntry)entry._next;
        }
        return null;
    }

    private Object getFromLongEntry(int intKey, long longKey) {
        HashtableLongEntry entry = this.getLongEntry(intKey, longKey);
        return entry == null ? null : entry._object;
    }

    private HashtableLongEntry getLongEntry(int intKey, long longKey) {
        HashtableLongEntry entry = (HashtableLongEntry)this._table[intKey & this._mask];
        while (entry != null) {
            if (entry._key == intKey && entry._longKey == longKey) {
                return entry;
            }
            entry = (HashtableLongEntry)entry._next;
        }
        return null;
    }
}

