/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.KeySpec;
import com.db4o.foundation.KeySpecHashtable4;
import com.db4o.foundation.TernaryBool;
import com.db4o.internal.Exceptions4;

public abstract class Config4Abstract {
    protected KeySpecHashtable4 _config;
    private static final KeySpec CASCADE_ON_ACTIVATE_KEY = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec CASCADE_ON_DELETE_KEY = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec CASCADE_ON_UPDATE_KEY = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec NAME_KEY = new KeySpec(null);

    public Config4Abstract() {
        this(new KeySpecHashtable4(10));
    }

    protected Config4Abstract(KeySpecHashtable4 config) {
        this._config = (KeySpecHashtable4)config.deepClone(this);
    }

    public void cascadeOnActivate(boolean flag) {
        this.putThreeValued(CASCADE_ON_ACTIVATE_KEY, flag);
    }

    public void cascadeOnDelete(boolean flag) {
        this.putThreeValued(CASCADE_ON_DELETE_KEY, flag);
    }

    public void cascadeOnUpdate(boolean flag) {
        this.putThreeValued(CASCADE_ON_UPDATE_KEY, flag);
    }

    protected void putThreeValued(KeySpec spec, boolean flag) {
        this._config.put(spec, TernaryBool.forBoolean(flag));
    }

    protected void putThreeValuedInt(KeySpec spec, boolean flag) {
        this._config.put(spec, flag ? 1 : -1);
    }

    public TernaryBool cascadeOnActivate() {
        return this.cascade(CASCADE_ON_ACTIVATE_KEY);
    }

    public TernaryBool cascadeOnDelete() {
        return this.cascade(CASCADE_ON_DELETE_KEY);
    }

    public TernaryBool cascadeOnUpdate() {
        return this.cascade(CASCADE_ON_UPDATE_KEY);
    }

    private TernaryBool cascade(KeySpec spec) {
        return this._config.getAsTernaryBool(spec);
    }

    abstract String className();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            Exceptions4.shouldNeverHappen();
        }
        return this.getName().equals(((Config4Abstract)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getName() {
        return this._config.getAsString(NAME_KEY);
    }

    protected void setName(String name) {
        this._config.put(NAME_KEY, name);
    }
}

