/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Predicate4;
import com.db4o.internal.CallBackMode;
import com.db4o.internal.EventDispatcher;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectMethod;

public final class EventDispatchers {
    public static final EventDispatcher NULL_DISPATCHER = new EventDispatcher(){

        public boolean dispatch(Transaction trans, Object obj, int eventID) {
            return true;
        }

        public boolean hasEventRegistered(int eventID) {
            return false;
        }
    };
    private static final String[] events = new String[]{"objectCanDelete", "objectOnDelete", "objectOnActivate", "objectOnDeactivate", "objectOnNew", "objectOnUpdate", "objectCanActivate", "objectCanDeactivate", "objectCanNew", "objectCanUpdate"};
    static final int CAN_DELETE = 0;
    static final int DELETE = 1;
    static final int ACTIVATE = 2;
    static final int DEACTIVATE = 3;
    static final int NEW = 4;
    public static final int UPDATE = 5;
    static final int CAN_ACTIVATE = 6;
    static final int CAN_DEACTIVATE = 7;
    static final int CAN_NEW = 8;
    static final int CAN_UPDATE = 9;
    static final int DELETE_COUNT = 2;
    static final int COUNT = 10;

    public static EventDispatcher forClass(ObjectContainerBase container, ReflectClass classReflector) {
        if (container == null || classReflector == null) {
            throw new ArgumentNullException();
        }
        if (!container.dispatchsEvents()) {
            return NULL_DISPATCHER;
        }
        int count = EventDispatchers.eventCountFor(container);
        if (count == 0) {
            return NULL_DISPATCHER;
        }
        ReflectMethod[] handlers = EventDispatchers.eventHandlerTableFor(container, classReflector);
        return EventDispatchers.hasEventHandler(handlers) ? new EventDispatcherImpl(handlers) : NULL_DISPATCHER;
    }

    private static ReflectMethod[] eventHandlerTableFor(ObjectContainerBase container, ReflectClass classReflector) {
        ReflectClass[] parameterClasses = new ReflectClass[]{container._handlers.ICLASS_OBJECTCONTAINER};
        ReflectMethod[] methods = new ReflectMethod[10];
        for (int i = 9; i >= 0; --i) {
            ReflectMethod method = classReflector.getMethod(events[i], parameterClasses);
            if (null == method) {
                method = classReflector.getMethod(EventDispatchers.toPascalCase(events[i]), parameterClasses);
            }
            if (method == null) continue;
            methods[i] = method;
        }
        return methods;
    }

    private static boolean hasEventHandler(ReflectMethod[] methods) {
        return Iterators.any(Iterators.iterate(methods), new Predicate4(){

            public boolean match(Object candidate) {
                return candidate != null;
            }
        });
    }

    private static int eventCountFor(ObjectContainerBase container) {
        CallBackMode callbackMode = container.configImpl().callbackMode();
        if (callbackMode == CallBackMode.ALL) {
            return 10;
        }
        if (callbackMode == CallBackMode.DELETE_ONLY) {
            return 2;
        }
        return 0;
    }

    private static String toPascalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static class EventDispatcherImpl
    implements EventDispatcher {
        private final ReflectMethod[] methods;

        public EventDispatcherImpl(ReflectMethod[] methods_) {
            this.methods = methods_;
        }

        public boolean hasEventRegistered(int eventID) {
            return this.methods[eventID] != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dispatch(Transaction trans, Object obj, int eventID) {
            if (this.methods[eventID] == null) {
                return true;
            }
            Object[] parameters = new Object[]{trans.objectContainer()};
            ObjectContainerBase container = trans.container();
            int stackDepth = container.stackDepth();
            int topLevelCallId = container.topLevelCallId();
            container.stackDepth(0);
            try {
                Object res = this.methods[eventID].invoke(obj, parameters);
                if (res instanceof Boolean) {
                    boolean bl = (Boolean)res;
                    return bl;
                }
            }
            finally {
                container.stackDepth(stackDepth);
                container.topLevelCallId(topLevelCallId);
            }
            return true;
        }
    }
}

