/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.activation;

import com.db4o.ObjectContainer;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.typehandlers.ActivationContext;

public class ActivationContext4
implements ActivationContext {
    private final Transaction _transaction;
    private final Object _targetObject;
    private final ActivationDepth _depth;

    public ActivationContext4(Transaction transaction, Object obj, ActivationDepth depth) {
        if (null == obj) {
            throw new ArgumentNullException();
        }
        this._transaction = transaction;
        this._targetObject = obj;
        this._depth = depth;
    }

    public void cascadeActivationToTarget() {
        ActivationContext context = this.classMetadata().descendOnCascadingActivation() ? this.descend() : this;
        this.cascadeActivation(context);
    }

    public void cascadeActivationToChild(Object obj) {
        if (obj == null) {
            return;
        }
        ActivationContext cascadingContext = this.forObject(obj);
        ClassMetadata classMetadata = cascadingContext.classMetadata();
        if (classMetadata == null || !classMetadata.hasIdentity()) {
            return;
        }
        this.cascadeActivation(cascadingContext.descend());
    }

    private void cascadeActivation(ActivationContext context) {
        ActivationDepth depth = context.depth();
        if (!depth.requiresActivation()) {
            return;
        }
        if (depth.mode().isDeactivate()) {
            this.container().stillToDeactivate(this._transaction, context.targetObject(), depth, false);
        } else {
            ClassMetadata classMetadata = context.classMetadata();
            if (classMetadata.isStruct()) {
                classMetadata.cascadeActivation(context);
            } else {
                this.container().stillToActivate(context);
            }
        }
    }

    public ObjectContainerBase container() {
        return this._transaction.container();
    }

    public Object targetObject() {
        return this._targetObject;
    }

    public ClassMetadata classMetadata() {
        return this.container().classMetadataForObject(this._targetObject);
    }

    public ActivationDepth depth() {
        return this._depth;
    }

    public ObjectContainer objectContainer() {
        return this.container();
    }

    public Transaction transaction() {
        return this._transaction;
    }

    public ActivationContext forObject(Object newTargetObject) {
        return new ActivationContext4(this.transaction(), newTargetObject, this.depth());
    }

    public ActivationContext descend() {
        return new ActivationContext4(this.transaction(), this.targetObject(), this.depth().descend(this.classMetadata()));
    }
}

