/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.ext.Db4oIOException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.SystemData;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.FileHeaderVariablePart;
import com.db4o.internal.fileheader.TimerFileLock;

public abstract class NewFileHeaderBase
extends FileHeader {
    protected static final byte[] SIGNATURE = new byte[]{100, 98, 52, 111};
    protected static final int HEADER_LOCK_OFFSET = SIGNATURE.length + 1;
    protected static final int OPEN_TIME_OFFSET = HEADER_LOCK_OFFSET + 4;
    protected static final int ACCESS_TIME_OFFSET = OPEN_TIME_OFFSET + 8;
    protected TimerFileLock _timerFileLock;
    protected FileHeaderVariablePart _variablePart;

    public void close() throws Db4oIOException {
        if (this._timerFileLock == null) {
            return;
        }
        this._timerFileLock.close();
    }

    protected void newTimerFileLock(LocalObjectContainer file) {
        this._timerFileLock = TimerFileLock.forFile(file);
        this._timerFileLock.setAddresses(0, OPEN_TIME_OFFSET, ACCESS_TIME_OFFSET);
    }

    protected abstract NewFileHeaderBase createNew();

    protected abstract byte version();

    public final void initNew(LocalObjectContainer file) throws Db4oIOException {
        this.newTimerFileLock(file);
        this.oldEncryptionOff(file);
        this._variablePart = this.createVariablePart(file);
        this.writeVariablePart(file);
    }

    public abstract FileHeaderVariablePart createVariablePart(LocalObjectContainer var1);

    protected void oldEncryptionOff(LocalObjectContainer file) {
        file._handlers.oldEncryptionOff();
    }

    public final void writeVariablePart(LocalObjectContainer file, boolean shuttingDown) {
        if (!this.isInitalized()) {
            return;
        }
        Runnable commitHook = this.commit(shuttingDown);
        file.syncFiles();
        commitHook.run();
        file.syncFiles();
    }

    private boolean isInitalized() {
        return this._variablePart != null;
    }

    protected FileHeader newOnSignatureMatch(LocalObjectContainer file, ByteArrayBuffer reader) {
        if (this.signatureMatches(reader, SIGNATURE, this.version())) {
            return this.createNew();
        }
        return null;
    }

    public void completeInterruptedTransaction(LocalObjectContainer container) {
        SystemData systemData = container.systemData();
        container.idSystem().completeInterruptedTransaction(systemData.transactionPointer1(), systemData.transactionPointer2());
    }

    protected void checkThreadFileLock(LocalObjectContainer container, ByteArrayBuffer reader) {
        reader.seek(ACCESS_TIME_OFFSET);
        long lastAccessTime = reader.readLong();
        if (FileHeader.lockedByOtherSession(container, lastAccessTime)) {
            this._timerFileLock.checkIfOtherSessionAlive(container, 0, ACCESS_TIME_OFFSET, lastAccessTime);
        }
    }

    public void readIdentity(LocalObjectContainer container) {
        this._variablePart.readIdentity((LocalTransaction)container.systemTransaction());
    }

    public Runnable commit(boolean shuttingDown) {
        return this._variablePart.commit(shuttingDown);
    }
}

