/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.DTrace;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.IDGenerator;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.query.processor.QConClass;
import com.db4o.internal.query.processor.QConJoin;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.query.processor.QConPath;
import com.db4o.internal.query.processor.QConstraints;
import com.db4o.internal.query.processor.QE;
import com.db4o.internal.query.processor.QENot;
import com.db4o.internal.query.processor.QField;
import com.db4o.internal.query.processor.QPending;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.query.Constraint;
import com.db4o.reflect.ReflectClass;
import com.db4o.types.Unversioned;

public abstract class QCon
implements Constraint,
Visitor4,
Unversioned {
    static final IDGenerator idGenerator = new IDGenerator();
    transient QCandidates i_candidates;
    private Collection4 i_childrenCandidates;
    protected List4 _children;
    protected QE i_evaluator = QE.DEFAULT;
    private int i_id;
    Collection4 i_joins;
    protected QCon i_parent;
    private boolean i_removed = false;
    transient Transaction i_trans;
    private transient boolean _processedByIndex;

    public QCon() {
    }

    QCon(Transaction a_trans) {
        this.i_id = idGenerator.next();
        this.i_trans = a_trans;
    }

    QCon addConstraint(QCon a_child) {
        this._children = new List4<QCon>(this._children, a_child);
        return a_child;
    }

    public ObjectContainerBase container() {
        return this.transaction().container();
    }

    public Transaction transaction() {
        return this.i_trans;
    }

    void addJoin(QConJoin a_join) {
        if (this.i_joins == null) {
            this.i_joins = new Collection4();
        }
        this.i_joins.add(a_join);
    }

    QCon addSharedConstraint(QField a_field, Object a_object) {
        QConObject newConstraint = new QConObject(this.i_trans, this, a_field, a_object);
        this.addConstraint(newConstraint);
        return newConstraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint and(Constraint andWith) {
        Object object = this.streamLock();
        synchronized (object) {
            return this.join(andWith, true);
        }
    }

    boolean attach(final QQuery query, String a_field) {
        QCon qcon = this;
        ClassMetadata yc = this.getYapClass();
        final boolean[] foundField = new boolean[]{false};
        this.forEachChildField(a_field, new Visitor4(){

            public void visit(Object obj) {
                foundField[0] = true;
                query.addConstraint((QCon)obj);
            }
        });
        if (foundField[0]) {
            return true;
        }
        QField qf = null;
        if (yc == null || yc.holdsAnyClass()) {
            final int[] count = new int[]{0};
            final FieldMetadata[] yfs = new FieldMetadata[]{null};
            this.i_trans.container().classCollection().attachQueryNode(a_field, new Visitor4(){

                public void visit(Object obj) {
                    yfs[0] = (FieldMetadata)((Object[])obj)[1];
                    count[0] = count[0] + 1;
                }
            });
            if (count[0] == 0) {
                return false;
            }
            qf = count[0] == 1 ? yfs[0].qField(this.i_trans) : new QField(this.i_trans, a_field, null, 0, 0);
        } else {
            FieldMetadata yf;
            if (yc.isTranslated()) {
                this.i_trans.container()._handlers.diagnosticProcessor().descendIntoTranslator(yc, a_field);
            }
            if ((yf = yc.fieldMetadataForName(a_field)) != null) {
                qf = yf.qField(this.i_trans);
            }
            if (qf == null) {
                qf = new QField(this.i_trans, a_field, null, 0, 0);
            }
        }
        QConPath qcp = new QConPath(this.i_trans, qcon, qf);
        query.addConstraint(qcp);
        qcon.addConstraint(qcp);
        return true;
    }

    public boolean canBeIndexLeaf() {
        return false;
    }

    public boolean canLoadByIndex() {
        return false;
    }

    void checkLastJoinRemoved() {
        if (this.i_joins.size() == 0) {
            this.i_joins = null;
        }
    }

    void collect(QCandidates candidates) {
    }

    public Constraint contains() {
        throw this.notSupported();
    }

    void createCandidates(Collection4 a_candidateCollection) {
        Iterator4 j = a_candidateCollection.iterator();
        while (j.moveNext()) {
            QCandidates candidates = (QCandidates)j.current();
            if (!candidates.tryAddConstraint(this)) continue;
            this.i_candidates = candidates;
            return;
        }
        this.i_candidates = new QCandidates((LocalTransaction)this.i_trans, this.getYapClass(), this.getField());
        this.i_candidates.addConstraint(this);
        a_candidateCollection.add(this.i_candidates);
    }

    void doNotInclude(QCandidate a_root) {
        if (DTrace.enabled) {
            DTrace.DONOTINCLUDE.log(this.id());
        }
        if (this.i_parent != null) {
            this.i_parent.visit1(a_root, this, false);
        } else {
            a_root.doNotInclude();
        }
    }

    public Constraint equal() {
        throw this.notSupported();
    }

    boolean evaluate(QCandidate candidate) {
        throw Exceptions4.virtualException();
    }

    void evaluateChildren() {
        Iterator4 i = this.i_childrenCandidates.iterator();
        while (i.moveNext()) {
            ((QCandidates)i.current()).evaluate();
        }
    }

    void evaluateCollectChildren() {
        if (DTrace.enabled) {
            DTrace.COLLECT_CHILDREN.log(this.id());
        }
        Iterator4 i = this.i_childrenCandidates.iterator();
        while (i.moveNext()) {
            ((QCandidates)i.current()).collect(this.i_candidates);
        }
    }

    void evaluateCreateChildrenCandidates() {
        this.i_childrenCandidates = new Collection4();
        Iterator4 i = this.iterateChildren();
        while (i.moveNext()) {
            ((QCon)i.current()).createCandidates(this.i_childrenCandidates);
        }
    }

    void evaluateEvaluations() {
        Iterator4 i = this.iterateChildren();
        while (i.moveNext()) {
            ((QCon)i.current()).evaluateEvaluationsExec(this.i_candidates, true);
        }
    }

    void evaluateEvaluationsExec(QCandidates candidates, boolean rereadObject) {
    }

    void evaluateSelf() {
        this.i_candidates.filter(this);
    }

    void evaluateSimpleChildren() {
        if (this._children == null) {
            return;
        }
        Iterator4 i = this.iterateChildren();
        while (i.moveNext()) {
            QCon qcon = (QCon)i.current();
            this.i_candidates.setCurrentConstraint(qcon);
            qcon.setCandidates(this.i_candidates);
            qcon.evaluateSimpleExec(this.i_candidates);
        }
        this.i_candidates.setCurrentConstraint(null);
    }

    void evaluateSimpleExec(QCandidates candidates) {
    }

    void exchangeConstraint(QCon a_exchange, QCon a_with) {
        List4 previous = null;
        List4 current = this._children;
        while (current != null) {
            if (current._element == a_exchange) {
                if (previous == null) {
                    this._children = current._next;
                } else {
                    previous._next = current._next;
                }
            }
            previous = current;
            current = current._next;
        }
        this._children = new List4<QCon>(this._children, a_with);
    }

    void forEachChildField(String name, Visitor4 visitor) {
        Iterator4 i = this.iterateChildren();
        while (i.moveNext()) {
            Object obj = i.current();
            if (!(obj instanceof QConObject) || !((QConObject)obj).getField().name().equals(name)) continue;
            visitor.visit(obj);
        }
    }

    public QField getField() {
        return null;
    }

    public Object getObject() {
        throw this.notSupported();
    }

    QCon getRoot() {
        if (this.i_parent != null) {
            return this.i_parent.getRoot();
        }
        return this;
    }

    QCon produceTopLevelJoin() {
        if (!this.hasJoins()) {
            return this;
        }
        Iterator4 i = this.iterateJoins();
        if (this.i_joins.size() == 1) {
            i.moveNext();
            return ((QCon)i.current()).produceTopLevelJoin();
        }
        Collection4<QCon> col = new Collection4<QCon>();
        while (i.moveNext()) {
            col.ensure(((QCon)i.current()).produceTopLevelJoin());
        }
        i = col.iterator();
        i.moveNext();
        QCon qcon = (QCon)i.current();
        if (col.size() == 1) {
            return qcon;
        }
        while (i.moveNext()) {
            qcon = (QCon)qcon.and((Constraint)i.current());
        }
        return qcon;
    }

    ClassMetadata getYapClass() {
        return null;
    }

    public Constraint greater() {
        throw this.notSupported();
    }

    public boolean hasChildren() {
        return this._children != null;
    }

    public boolean hasParent() {
        return this.i_parent != null;
    }

    public QCon parent() {
        return this.i_parent;
    }

    public boolean hasJoins() {
        if (this.i_joins == null) {
            return false;
        }
        return this.i_joins.size() > 0;
    }

    public boolean hasObjectInParentPath(Object obj) {
        if (this.i_parent != null) {
            return this.i_parent.hasObjectInParentPath(obj);
        }
        return false;
    }

    public Constraint identity() {
        throw this.notSupported();
    }

    public Constraint byExample() {
        throw this.notSupported();
    }

    public int identityID() {
        return 0;
    }

    boolean isNot() {
        return this.i_evaluator instanceof QENot;
    }

    boolean isNullConstraint() {
        return false;
    }

    public Iterator4 iterateJoins() {
        if (this.i_joins == null) {
            return Iterators.EMPTY_ITERATOR;
        }
        return this.i_joins.iterator();
    }

    public Iterator4 iterateChildren() {
        if (this._children == null) {
            return Iterators.EMPTY_ITERATOR;
        }
        return new Iterator4Impl(this._children);
    }

    Constraint join(Constraint a_with, boolean a_and) {
        if (!(a_with instanceof QCon)) {
            return null;
        }
        if (a_with == this) {
            return this;
        }
        return this.join1((QCon)a_with, a_and);
    }

    Constraint join1(QCon a_with, boolean a_and) {
        QCon otherHook;
        if (a_with instanceof QConstraints) {
            int j = 0;
            Collection4<QCon> joinHooks = new Collection4<QCon>();
            Constraint[] constraints = ((QConstraints)a_with).toArray();
            for (j = 0; j < constraints.length; ++j) {
                joinHooks.ensure(((QCon)constraints[j]).joinHook());
            }
            Constraint[] joins = new Constraint[joinHooks.size()];
            j = 0;
            Iterator4 i = joinHooks.iterator();
            while (i.moveNext()) {
                joins[j++] = this.join((Constraint)i.current(), a_and);
            }
            return new QConstraints(this.i_trans, joins);
        }
        QCon myHook = this.joinHook();
        if (myHook == (otherHook = a_with.joinHook())) {
            return myHook;
        }
        QConJoin cj = new QConJoin(this.i_trans, myHook, otherHook, a_and);
        myHook.addJoin(cj);
        otherHook.addJoin(cj);
        return cj;
    }

    QCon joinHook() {
        return this.produceTopLevelJoin();
    }

    public Constraint like() {
        throw this.notSupported();
    }

    public Constraint startsWith(boolean caseSensitive) {
        throw this.notSupported();
    }

    public Constraint endsWith(boolean caseSensitive) {
        throw this.notSupported();
    }

    void log(String indent) {
    }

    String logObject() {
        return "";
    }

    void marshall() {
        Iterator4 i = this.iterateChildren();
        while (i.moveNext()) {
            ((QCon)i.current()).marshall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint not() {
        Object object = this.streamLock();
        synchronized (object) {
            if (!(this.i_evaluator instanceof QENot)) {
                this.i_evaluator = new QENot(this.i_evaluator);
            }
            return this;
        }
    }

    private RuntimeException notSupported() {
        return new RuntimeException("Not supported.");
    }

    public boolean onSameFieldAs(QCon other) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint or(Constraint orWith) {
        Object object = this.streamLock();
        synchronized (object) {
            return this.join(orWith, false);
        }
    }

    boolean remove() {
        if (!this.i_removed) {
            this.i_removed = true;
            this.removeChildrenJoins();
            return true;
        }
        return false;
    }

    void removeChildrenJoins() {
        if (!this.hasJoins()) {
            return;
        }
        Collection4 toBeRemoved = this.collectJoinsToBeRemoved();
        this.i_joins.removeAll(toBeRemoved);
        this.checkLastJoinRemoved();
    }

    private Collection4 collectJoinsToBeRemoved() {
        Collection4<QConJoin> toBeRemoved = new Collection4<QConJoin>();
        Iterator4 joinIter = this.iterateJoins();
        while (joinIter.moveNext()) {
            QConJoin join = (QConJoin)joinIter.current();
            if (!join.removeForParent(this)) continue;
            toBeRemoved.add(join);
        }
        return toBeRemoved;
    }

    void removeJoin(QConJoin a_join) {
        this.i_joins.remove(a_join);
        this.checkLastJoinRemoved();
    }

    void removeNot() {
        if (this.isNot()) {
            this.i_evaluator = ((QENot)this.i_evaluator).evaluator();
        }
    }

    public void setCandidates(QCandidates a_candidates) {
        this.i_candidates = a_candidates;
    }

    void setParent(QCon a_newParent) {
        this.i_parent = a_newParent;
    }

    QCon shareParent(Object obj, BooleanByRef removeExisting) {
        return null;
    }

    QConClass shareParentForClass(ReflectClass claxx, BooleanByRef removeExisting) {
        return null;
    }

    public Constraint smaller() {
        throw this.notSupported();
    }

    protected Object streamLock() {
        return this.i_trans.container().lock();
    }

    void unmarshall(Transaction a_trans) {
        if (this.i_trans != null) {
            return;
        }
        this.i_trans = a_trans;
        this.unmarshallParent(a_trans);
        this.unmarshallJoins(a_trans);
        this.unmarshallChildren(a_trans);
    }

    private void unmarshallParent(Transaction a_trans) {
        if (this.i_parent != null) {
            this.i_parent.unmarshall(a_trans);
        }
    }

    private void unmarshallChildren(Transaction a_trans) {
        Iterator4 i = this.iterateChildren();
        while (i.moveNext()) {
            ((QCon)i.current()).unmarshall(a_trans);
        }
    }

    private void unmarshallJoins(Transaction a_trans) {
        if (this.hasJoins()) {
            Iterator4 i = this.iterateJoins();
            while (i.moveNext()) {
                ((QCon)i.current()).unmarshall(a_trans);
            }
        }
    }

    public void visit(Object obj) {
        QCandidate qc = (QCandidate)obj;
        this.visit1(qc.getRoot(), this, this.evaluate(qc));
    }

    void visit(QCandidate a_root, boolean res) {
        this.visit1(a_root, this, this.i_evaluator.not(res));
    }

    void visit1(QCandidate root, QCon reason, boolean res) {
        if (this.hasJoins()) {
            Iterator4 i = this.iterateJoins();
            while (i.moveNext()) {
                root.evaluate(new QPending((QConJoin)i.current(), this, res));
            }
        } else if (!res) {
            this.doNotInclude(root);
        }
    }

    final void visitOnNull(QCandidate a_root) {
        Iterator4 i = this.iterateChildren();
        while (i.moveNext()) {
            ((QCon)i.current()).visitOnNull(a_root);
        }
        if (this.visitSelfOnNull()) {
            this.visit(a_root, this.isNullConstraint());
        }
    }

    boolean visitSelfOnNull() {
        return true;
    }

    public QE evaluator() {
        return this.i_evaluator;
    }

    public void setProcessedByIndex() {
        this.internalSetProcessedByIndex();
    }

    protected void internalSetProcessedByIndex() {
        this._processedByIndex = true;
        if (this.i_joins != null) {
            Iterator4 i = this.i_joins.iterator();
            while (i.moveNext()) {
                ((QConJoin)i.current()).setProcessedByIndex();
            }
        }
    }

    public boolean processedByIndex() {
        return this._processedByIndex;
    }

    public int childrenCount() {
        return List4.size(this._children);
    }

    public int id() {
        return this.i_id;
    }
}

