package test.weibo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;
import weibo4j.http.RequestToken;

public class VerifyOAuthAccount
{


	public static void main(String[] args) throws Exception
	{
		
		System.setProperty("weibo4j.oauth.consumerKey", Weibo.CONSUMER_KEY);
		System.setProperty("weibo4j.oauth.consumerSecret", Weibo.CONSUMER_SECRET);

		
		Weibo weibo = new Weibo();
		RequestToken requestToken = weibo.getOAuthRequestToken("http://www.csdn.net");

		System.out.println("Request token: " + requestToken.getToken());
		System.out.println("Request token secret: "
				+ requestToken.getTokenSecret());
		

		System.out.println(requestToken.getAuthorizationURL());

		String verifier = readLine();

		AccessToken accessToken = weibo.getOAuthAccessToken(
				requestToken.getToken(), requestToken.getTokenSecret(),
				verifier);

		System.out.println("access token: " + accessToken.getToken());
		System.out.println("access token secret: "
				+ accessToken.getTokenSecret());
		
		
		weibo.setToken(accessToken.getToken(), accessToken.getTokenSecret());
		User user = weibo.verifyCredentials();
		System.out.println("User ID" + user.getId());

	}

	private static String readLine() throws IOException
	{
		BufferedReader reader = new BufferedReader(new InputStreamReader(
				System.in));
		byte[] bs = reader.readLine().getBytes("gbk");
		String getStr = new String(bs);
		System.out.println(getStr);
		return getStr;
	}
}
