package microblog.thread;

import java.util.Map;

import microblog.MyMicroBlog;
import microblog.MyMicroBlogAsync;
import microblog.StaticResources;
import microblog.commons.Const;
import microblog.net.interfaces.MyLog;
import weibo4j.Comment;
import weibo4j.DirectMessage;
import weibo4j.Result;
import weibo4j.Status;

public class ProcessTasks implements Runnable
{
	public static Map<String, MyMicroBlogAsync> myMicroBlogs;
	public MyLog myLog;
	public int mDataType;

	public ProcessTasks(Map<String, MyMicroBlogAsync> myMicroBlogs)
	{
		this.myMicroBlogs = myMicroBlogs;
	}

	static class TaskResult
	{
		public Status status;
		public Comment comment;
		public DirectMessage directMessage;
	};

	private ProcessTasks.TaskResult processTask(Task task,
			MyMicroBlog myMicroBlog) throws Exception
	{
		ProcessTasks.TaskResult taskResult = new ProcessTasks.TaskResult();

		if (Const.TASK_TYPE_STATUS.equals(task.taskType))
		{
	

			if (task.image == null)
				taskResult.status = myMicroBlog.updateStatus(task.msg);
			else
				taskResult.status = myMicroBlog.updateStatus(task.msg,
						task.image);

		}
		else if (Const.TASK_TYPE_COMMENT.equals(task.taskType))
		{
			if (mDataType == Const.DATA_TYPE_SINA_COMMENT)
			{
				mDataType = 0; // ָʼֵ

				Result result = myMicroBlog.updateSinaComment(task.msg,
						task.srcid, task.srcuid);
				if (task.postStatus)
				{
					taskResult.status = myMicroBlog.updateStatus(task.msg);
				}
				if (!result.isSuccess || taskResult.status == null)
					throw new Exception("");

			}
			else
			{
				if (task.postStatus)
				{
					taskResult.comment = myMicroBlog.updateComment(task.msg,
							task.statusId, true, task.msg);
				}
				else
				{
					taskResult.comment = myMicroBlog.updateComment(task.msg,
							task.statusId);
				}
			}
		}
		else if (Const.TASK_TYPE_REPOST.equals(task.taskType))
		{
			if (mDataType == Const.DATA_TYPE_SINA_REPOST)
			{
				mDataType = 0; // ָʼֵ
				if ("".equals(task.msg))
					task.msg = "ת΢.";
				Result result = myMicroBlog.sinaRepost(task.srcid, task.srcuid,
						task.msg);
				if (!result.isSuccess)
					throw new Exception("");
				if (task.comment1)
					myMicroBlog.updateSinaComment(task.msg + " ", task.srcid,
							task.srcuid);
			}
			else
			{
				taskResult.status = myMicroBlog.repost(task.statusId, task.msg);
				if (task.comment1)
					myMicroBlog.updateComment(task.msg, task.statusId);
				if (task.comment2)
				{
					myMicroBlog.updateComment(task.msg + " ", task.retweetId);
				}
			}
		}
		else if (Const.TASK_TYPE_FAVORITE.equals(task.taskType))
		{
			if (mDataType == Const.DATA_TYPE_SINA_REPOST)
			{
				mDataType = 0;
				Result result = myMicroBlog.createSinaFavorite(task.srcid);
				if (!result.isSuccess)
					throw new Exception("");
			}
			else
			{
				taskResult.status = myMicroBlog.createFavorite(task.statusId);
			}
		}
		else if (Const.TASK_TYPE_DESTROY_FAVORITE.equals(task.taskType))
		{
			taskResult.status = myMicroBlog.destroyFavorite(task.statusId);
		}
		else if (Const.TASK_TYPE_DELETE_STATUS.equals(task.taskType))
		{
			taskResult.status = myMicroBlog.destroyStatus(task.statusId);

		}
		else if (Const.TASK_TYPE_REPLY_COMMENT.equals(task.taskType))
		{
			taskResult.comment = myMicroBlog.reply(task.msg, task.replyStatus,
					task.statusId, task.commentId, task.postStatus);
		}
		else if (Const.TASK_TYPE_SEND_DIRECT_MESSAGE.equals(task.taskType))
		{
			taskResult.directMessage = myMicroBlog.sendDirectMessage(task.nick,
					task.msg);
		}

		return taskResult;
	}

	private void writeLog(String key, String msg)
	{
		if (myLog != null)
			myLog.write(key, msg);
	}

	@Override
	public void run()
	{
		while (true)
		{

			try
			{
				Task task = StaticResources.getTask();

				if (task != null)
				{
					MyMicroBlog myMicroBlog = myMicroBlogs.get(task.alias);
				
					try
					{

						if (task.taskListener != null)
						{

							task.taskListener.onStartTask(task);
						}
						if (myMicroBlogs != null)
						{

							ProcessTasks.TaskResult taskResult = null;
							int count = 0;
							while (count < 3)
							{
								try
								{
									taskResult = processTask(task, myMicroBlog);
									break;
								}
								catch (Exception e)
								{
									
								}
								count++;

							}
							if (task.taskListener != null)
								task.taskListener.onTaskSuccess(task,
										taskResult.status, taskResult.comment);

						}
						else
						{
							throw new Exception("");
						}

					}
					catch (Exception e)
					{
						if (task.taskListener != null)
							task.taskListener.onTaskFailed(task);
					}
				}
				try
				{
					Thread.sleep(500);
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
		}

		// mThreadPool.addTask(mTask.nextTask);
	}
}
