package microblog.storage;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;

import microblog.MyMicroBlog;
import microblog.commons.ConstExt;
import microblog.commons.EncryptDecrypt;

public class SystemDBService
{
	private DatabaseOperator mDatabaseOperator;

	public SystemDBService(DatabaseOperator operator)
	{
		mDatabaseOperator = operator;
		operator.createDatabase();
		createTables();

	}
	private void execSQLList(List<String> sqls)
	{
		for (String sql : sqls)
			mDatabaseOperator.execSQL(sql);
	}

	public void createTables()
	{

		if (!tableExists("t_accounts"))
		{
			execSQLList(ConstExt.SQL_CREATE_TABLE_ACCOUNTS_LIST);
		}
		if (!tableExists("t_task_queue"))
		{
			mDatabaseOperator.execSQL(ConstExt.SQL_CREATE_TABLE_TASK_QUEUE);
		}
		if (!tableExists("t_notification_list"))
		{
			mDatabaseOperator
					.execSQL(ConstExt.SQL_CREATE_TABLE_NOTIFICATION_LIST);
		}
		if (!tableExists("t_notification_task_list"))
		{
			mDatabaseOperator
					.execSQL(ConstExt.SQL_CREATE_TABLE_NOTIFICATION_TASK_LIST);
		}
	}

	public boolean tableExists(String table)
	{
		SqliteCursor cursor = mDatabaseOperator.query(

		"select type from sqlite_master where type='table' and name=?",
				new String[]
				{ table });
		if (cursor.moveToNext())
			return true;
		cursor.close();

		return false;
	}

	// ////////////////ҵصĲ//////////////////////////
	public void saveMicroBlogAccount(String happyblogAccount, String microblog,
			String microblogAccount, String password, String alias)
			throws Exception
	{
		// if ("twitter_china".equals(microblog))
		// microblog = "twitter";
		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		mDatabaseOperator.execSQL(ConstExt.SQL_INSERT_ACCOUNT, new Object[]
		{ happyblogAccount, microblog, microblogAccount, password, alias,
				sdf.format(calendar.getTime()) });

	}

	public SqliteCursor getMicroBlogAccounts(String happyblogAccount)
			throws Exception
	{

		String sql = "select * from t_accounts where happyblog_account=?";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql, new String[]
		{ happyblogAccount });
		return sqliteCursor;

	}

	// Ѿܵ
	public String getPassword(String account)
	{
		String sql = "select password from t_accounts where microblog_account=?";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql, new String[]
		{ account });
		if (sqliteCursor.moveToFirst())
			return EncryptDecrypt.decrypt(sqliteCursor.getString("password"));
		else
			return "";

	}

	public boolean notificationTaskExists(int id)
	{
		String sql = "select id from t_notification_task_list where id = ?;";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql, new String[]
		{ String.valueOf(id) });
		if (sqliteCursor.moveToNext())
		{
			return true;
		}
		else
		{
			return false;
		}

	}

	public int insertNotificationTask(String taskContent, String taskType)
	{
		String sql = "insert into t_notification_task_list(id, task_content, task_type) values(?,?,?);";
		int randomId = new Random().nextInt();
		while (notificationTaskExists(randomId))
		{
			randomId = new Random().nextInt();
		}
		mDatabaseOperator.execSQL(sql, new Object[]
		{ randomId, taskContent, taskType });

		return randomId;
	}

	public void insertNotification(int id, String title, String state,
			String microblog, String alias)
	{
		String sql = "insert into t_notification_list(id, title, notification_time, state, microblog, alias) values(?,?,?,?,?,?);";

		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		mDatabaseOperator.execSQL(sql, new Object[]
		{ id, title, sdf.format(new Date()), state, microblog, alias });
	}

	public void deleteAllNotification(String taskType)
	{
		String id = "";
		String sql = "select id from t_notification_task_list where task_type=?;";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql, new String[]
		{ taskType });
		sql = "delete from t_notification_list where id = ?;";
		while (sqliteCursor.moveToNext())
		{
			id = sqliteCursor.getString("id");
			mDatabaseOperator.execSQL(sql, new Object[]
			{ id });
		}
		sql = "delete from t_notification_task_list where task_type=?";
		mDatabaseOperator.execSQL(sql, new Object[]
		{ taskType });

	}

	public void deleteAllNotification()
	{
		String id = "";
		String sql = "select id from t_notification_task_list";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql);
		sql = "delete from t_notification_list where id = ?;";
		while (sqliteCursor.moveToNext())
		{
			id = sqliteCursor.getString("id");
			mDatabaseOperator.execSQL(sql, new Object[]
			{ id });
		}
		sql = "delete from t_notification_task_list";
		
		mDatabaseOperator.execSQL(sql);
		
		MyMicroBlog.myLog.write("deletedelete", "delete");

	}

	public int getNotificationCount(String taskType)
	{
		String sql = "select count(*) as c from t_notification_list a, t_notification_task_list b where a.id=b.id and b.task_type=?";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql, new String[]
		{ taskType });
		if (sqliteCursor.moveToNext())
		{
			return sqliteCursor.getInt("c");
		}
		else
		{
			return 0;
		}
	}

	public int getNotificationCount()
	{
		String sql = "select count(*) as c from t_notification_list a, t_notification_task_list b where a.id=b.id";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql);
		if (sqliteCursor.moveToNext())
		{
			return sqliteCursor.getInt("c");
		}
		else
		{
			return 0;
		}
	}

	public SqliteCursor getAllNotification(String taskType)
	{
		String sql = "select * from t_notification_list a, t_notification_task_list b where a.id = b.id and b.task_type=? order by a.notification_time desc;";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql, new String[]
		{ taskType });
		return sqliteCursor;
	}

	public SqliteCursor getAllNotification()
	{
		String sql = "select * from t_notification_list a, t_notification_task_list b where a.id = b.id order by a.notification_time desc;";
		SqliteCursor sqliteCursor = mDatabaseOperator.query(sql);
		return sqliteCursor;
	}

	public void updateAccountSync(String alias, boolean sync)
	{
		String sql = "update t_accounts set sync=? where alias=?";
		mDatabaseOperator.execSQL(sql, new Object[]
		{ sync, alias });
	}
	public void deleteAccountSync(String alias)
	{
		String sql = "delete from t_accounts where alias=?";
		mDatabaseOperator.execSQL(sql, new Object[]
		{ alias });
	}

}
