package sina.weibo;

import sina.weibo.commons.AndroidUtil;
import sina.weibo.process.CommentViewerButtonProcess;
import sina.weibo.process.TimelineOperationProcess;
import microblog.MyMicroBlogAsync;
import microblog.commons.Const;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem.OnMenuItemClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemLongClickListener;

public class CommentViewer extends Activity implements OnMenuItemClickListener,
		OnItemLongClickListener
{
	public TimelineOperationProcess mCommentOperationProcess;
	private TimelineOperationProcess mOldTimelineOperationProcess;
	private String mCurrentCommentId;
	private String mCurrentUserName;
	private String mCurrentCommentText;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
		//AndroidUtil.setContentView(this, R.layout.comment_viewer);
		View view = getLayoutInflater().inflate(R.layout.comment_viewer, null);
		setContentView(view);
		mCommentOperationProcess = new TimelineOperationProcess(this,
				Const.TIMELINE_TYPE_COMMENT, Const.DATA_TYPE_COMMENTS_TIMELINE);
		MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(this)
				.get(WeiboMain.mainAlias);
		mOldTimelineOperationProcess = AndroidUtil
				.getMainTimelineOperationProcess(this);
		AndroidUtil.setMainTimelineOperationProcess(this,
				mCommentOperationProcess);
		myMicroBlogAsync.getCommentAsync(mCommentOperationProcess,
				WeiboMain.mCurrentStatusId);
		mCommentOperationProcess.getListView().setOnItemLongClickListener(this);
		mCommentOperationProcess.getListView().setOnItemClickListener(
				mCommentOperationProcess);
		mCommentOperationProcess.getListView().setOnScrollListener(mCommentOperationProcess);
		new CommentViewerButtonProcess(this);
		registerForContextMenu(mCommentOperationProcess.getListView());
		AndroidUtil.changeBackground(getWindow());
		AndroidUtil.changeColorTransparency(view);
	}

	@Override
	public boolean onItemLongClick(AdapterView<?> parent, View view,
			int position, long id)
	{
		if (position == mCommentOperationProcess.mWeiboResponses.size())
		{
			unregisterForContextMenu(mCommentOperationProcess.getListView());
		} 
		else
		{
			registerForContextMenu(mCommentOperationProcess.getListView());
			mCurrentCommentId = mCommentOperationProcess.getId(position);
			mCurrentUserName = mCommentOperationProcess.getUser(position)
					.getName();
			mCurrentCommentText = mCommentOperationProcess.getText(position);
		}
		return false;
	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{
		Intent intent = null;
		switch (item.getItemId())
		{
			case R.id.mnuReplyComment:
				intent = new Intent(this, Comment.class);
				intent.putExtra("commentId", mCurrentCommentId);
				intent.putExtra("statusId", WeiboMain.mCurrentStatusId);
				intent.putExtra("taskType", Const.TASK_TYPE_REPLY_COMMENT);
				intent.putExtra("username", mCurrentUserName);
				intent.putExtra("commentText", mCurrentCommentText);
				startActivity(intent);
				break;
			case R.id.mnuDeleteComment:
				break;

		}
		return false;
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v,
			ContextMenuInfo menuInfo)
	{
		getMenuInflater().inflate(R.menu.comment_viewer_context_menu, menu);

		MenuItem mnuReplyComment = menu.findItem(R.id.mnuReplyComment);
		MenuItem mnuDeleteComment = menu.findItem(R.id.mnuDeleteComment);
		mnuDeleteComment.setVisible(false);
		mnuReplyComment.setOnMenuItemClickListener(this);
		mnuDeleteComment.setOnMenuItemClickListener(this);

		super.onCreateContextMenu(menu, v, menuInfo);
	}

	@Override
	protected void onDestroy()
	{
		AndroidUtil.getMainTimelineOperationProcess(this).mLoading = false;
		AndroidUtil.getMainTimelineOperationProcess(this).mMoreStatus = false;
		AndroidUtil.setMainTimelineOperationProcess(this,
				mOldTimelineOperationProcess);
		super.onDestroy();
	}

}
