package sina.weibo;

import microblog.MyMicroBlogAsync;
import microblog.commons.Const;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.process.TimelineOperationProcess;
import weibo4j.Paging;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.LinearLayout;

public class DirectMessageSessionViewer extends Activity implements
		OnMenuItemClickListener, OnItemLongClickListener, OnClickListener
{
	private TimelineOperationProcess mDirectMessageProcess;
	private TimelineOperationProcess mOldTimelineOperationProcess;
	public static String mUserId;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
		super.onCreate(savedInstanceState);
		AndroidUtil.setContentView(this, R.layout.direct_message_session_viewer);

		mDirectMessageProcess = new TimelineOperationProcess(this,
				Const.TIMELINE_TYPE_DIRECT_MESSAGE_SESSION,
				Const.DATA_TYPE_DIRECT_MESSAGE_SESSION, R.id.lvDirectMessages);
		MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(this)
				.get(WeiboMain.mainAlias);
		mOldTimelineOperationProcess = AndroidUtil
				.getMainTimelineOperationProcess(this);
		AndroidUtil
				.setMainTimelineOperationProcess(this, mDirectMessageProcess);
		mUserId = getIntent().getStringExtra("userId");
		myMicroBlogAsync.getDirectMessagesExtAsync(mDirectMessageProcess,
				new Paging(), mUserId);
		mDirectMessageProcess.getListView().setOnItemLongClickListener(this);
		mDirectMessageProcess.getListView().setOnScrollListener(mDirectMessageProcess);

		LinearLayout llRefresh = (LinearLayout) findViewById(R.id.llRefresh);
		llRefresh.setOnClickListener(this);
		LinearLayout llSendDirectMessage = (LinearLayout) findViewById(R.id.llSendDirectMessage);
		llSendDirectMessage.setOnClickListener(this);
		registerForContextMenu(mDirectMessageProcess.getListView());
		AndroidUtil.changeBackground(getWindow());
	}

	@Override
	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.llRefresh:

				if (TimelineOperationProcess.mLoading)
					return;

				mDirectMessageProcess.mInitData = false;

				MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(this)
						.get(WeiboMain.mainAlias);
				myMicroBlogAsync.getDirectMessagesExtAsync(
						mDirectMessageProcess, new Paging(), mUserId);

				break;
			case R.id.llSendDirectMessage:
				Intent intent = new Intent(this, SendDirectMessage.class);
				startActivity(intent);
				break;
		}

	}

	@Override
	public boolean onItemLongClick(AdapterView<?> parent, View view,
			int position, long id)
	{
		return false;
	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{
		Intent intent = null;
		return false;
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v,
			ContextMenuInfo menuInfo)
	{
		super.onCreateContextMenu(menu, v, menuInfo);
	}

	@Override
	protected void onDestroy()
	{

		AndroidUtil.setMainTimelineOperationProcess(this,
				mOldTimelineOperationProcess);
		super.onDestroy();
	}

}
