package sina.weibo;


import java.text.DateFormat;
import java.util.Date;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Values;
import sina.weibo.process.ChangeDatabasePath;
import sina.weibo.storage.DatabaseOperatorImpl;
import sina.weibo.storage.MySQLiteOpenHelper;
import microblog.MyUtil;
import microblog.storage.SqliteCursor;
import microblog.storage.SystemDBService;
import android.app.Activity;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

public class NotificationView extends Activity
{
	private ListView lvNotificationList;
	private SystemDBService mSystemDBService;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		AndroidUtil.setContentView(this, R.layout.notification_list);

		mSystemDBService = new SystemDBService(new DatabaseOperatorImpl(
				new MySQLiteOpenHelper(new ChangeDatabasePath())));

		lvNotificationList = (ListView) findViewById(R.id.lvNotificationList);
		lvNotificationList.setAdapter(new NotificationAdapter(this));
	}
	@Override
	public SQLiteDatabase openOrCreateDatabase(String name, int mode,
			CursorFactory factory)
	{
		String fn = Values.getSystemDBFileName();
		if (fn == null)
			return super.openOrCreateDatabase(name, mode, factory);
		else
			return SQLiteDatabase.openOrCreateDatabase(Values
					.getSystemDBFileName(), factory);

	}
	class NotificationAdapter extends BaseAdapter
	{

		private LayoutInflater layoutInflater;
		private SqliteCursor mSqliteCursor;

		public NotificationAdapter(Context context)
		{
			layoutInflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			mSqliteCursor = mSystemDBService
					.getAllNotification();
		}

		@Override
		public int getCount()
		{

			return mSqliteCursor.getCount();
		}

		@Override
		public Object getItem(int position)
		{
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public long getItemId(int position)
		{
			// TODO Auto-generated method stub
			return 0;
		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent)
		{
			View view = layoutInflater
					.inflate(R.layout.notification_item, null);
			try
			{
				mSqliteCursor.moveToPosition(position);
				ImageView ivLogo = (ImageView) view.findViewById(R.id.ivLogo);
				ImageView ivState = (ImageView) view.findViewById(R.id.ivState);
				TextView tvAlias = (TextView) view.findViewById(R.id.tvAlias);
				TextView tvNotificationTime = (TextView) view
						.findViewById(R.id.tvNotificationTime);
				TextView tvText = (TextView) view.findViewById(R.id.tvText);

				ivLogo.setImageResource(Values.getLogoIcon(mSqliteCursor
						.getString("microblog")));

				ivState.setImageResource(Values
						.getDrawableResource(mSqliteCursor.getString("state")));
				tvAlias.setText(mSqliteCursor.getString("alias"));

				tvNotificationTime.setText(MyUtil.getTimeStr(MyUtil
						.stringToDate(mSqliteCursor
								.getString("notification_time")), new Date()));

				tvText.setText(mSqliteCursor.getString("task_content"));
			}

			catch (Exception e)
			{
				Log.e("exception_noticiationview_getview", String.valueOf(e));
			}
			return view;
		}
	}

}
