package sina.weibo;

import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.interfaces.HandlerRun;
import sina.weibo.process.MyHandler;
import microblog.commons.Const;
import microblog.commons.EncryptDecrypt;
import microblog.net.DataTransfer;
import microblog.net.interfaces.DataTransferListener;
import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;

public class Register extends Activity implements OnClickListener,
		DataTransferListener
{
	private EditText metAccount;
	private EditText metPassword;
	private EditText metRepassword;
	private MyHandler mMyHandler;
	
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		AndroidUtil.setContentView(this, R.layout.register);

		metAccount = (EditText) findViewById(R.id.etAccount);
		metPassword = (EditText) findViewById(R.id.etPassword);
		metRepassword = (EditText) findViewById(R.id.etRePassword);
		mMyHandler = new MyHandler();

	}

	@Override
	public void onResult(final String result)
	{

		mMyHandler.run(new HandlerRun()
		{

			@Override
			public void invoke()
			{

				if (Const.SUCCESS_RETURN.equals(result))
				{
					Message.showMsg(Register.this, "ûעɹ.");
					finish();
				}
				else
				{
					Message.showMsg(Register.this, result);
				}

			}
		});

	}

	@Override
	public void onClick(View view)
	{
		String account = metAccount.getText().toString();
		String password = metPassword.getText().toString();
		String repassword = metRepassword.getText().toString();

		if (account.length() < Const.HAPPYBLOG_ACCOUNT_MIN_LENGTH)
		{
			Message.showMsg(this, "ʺųȲС"
					+ Const.HAPPYBLOG_ACCOUNT_MIN_LENGTH + ".");
			return;
		}
		if (password.length() < Const.HAPPYBLOG_ACCOUNT_PASSWORD_MIN_LENGTH)
		{
			Message.showMsg(this, "볤ȲС"
					+ Const.HAPPYBLOG_ACCOUNT_PASSWORD_MIN_LENGTH + ".");
			return;
		}

		if (!password.equals(repassword))
		{
			Message.showMsg(this, "벻һ.");
			return;
		}
		password = EncryptDecrypt.encrypt(password);
		String jsonStr = "{\"username\":\"" + account + "\",\"password\":\""
				+ password + "\"}";

		//DataTransfer.sendDataAsync(jsonStr, Const.URL_HAPPYBLOG_USER_REGISTER,
		//		this);
	}
}
