package sina.weibo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;

import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.TaskListenerImpl;
import microblog.StaticResources;
import microblog.commons.Const;
import microblog.thread.Task;
import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Bitmap.CompressFormat;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

public class SendDirectMessage extends Activity implements TextWatcher,
		OnClickListener
{
	private EditText etNick;
	private EditText etDirectMessage;

	private TextView tvRemainWordCount;
	private Message message;

	private String mTaskType = Const.TASK_TYPE_SEND_DIRECT_MESSAGE;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		View view = getLayoutInflater().inflate(R.layout.send_direct_message, null);
		setContentView(view);
		AndroidUtil.changeBackground(getWindow());
		AndroidUtil.changeColorTransparency(view);
		
		message = new Message(this);
		etNick = (EditText) findViewById(R.id.etNick);
		etDirectMessage = (EditText) findViewById(R.id.etDirectMessage);

		tvRemainWordCount = (TextView) findViewById(R.id.tvRemainWordCount);

		etDirectMessage.addTextChangedListener(this);
		String nick = getIntent().getExtras().getString("nick");
		if (nick != null)
			etNick.setText(nick);
		else
			etNick.setText(AndroidUtil.getMainTimelineOperationProcess(this)
					.getNick());
		LinearLayout llFace = (LinearLayout) findViewById(R.id.llFace);
		LinearLayout llSendDirectMessage = (LinearLayout) findViewById(R.id.llSendDirectMessage);

		llFace.setOnClickListener(this);
		llSendDirectMessage.setOnClickListener(this);

		updateMessage();
	
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (resultCode == Activity.RESULT_OK)
		{
			switch (requestCode)
			{
				case Values.REQUEST_CODE_FACE:
					// ѡ
					String face = data.getStringExtra("face");
					StringBuilder sb = new StringBuilder(etDirectMessage
							.getText().toString());
					int start = etDirectMessage.getSelectionStart();
					sb.insert(start, face);

					etDirectMessage.setText(sb.toString());
					etDirectMessage.setSelection(start + face.length());
					break;
			}
		}

	}

	public void onClick_Post(View view)
	{

	}

	@Override
	public void afterTextChanged(Editable s)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void beforeTextChanged(CharSequence s, int start, int count,
			int after)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count)
	{
		updateMessage();

	}

	private void updateMessage()
	{

		int remainWordCount = Values.getRemainWordCount(etDirectMessage
				.getText().toString(), 300);
		if (remainWordCount >= 0)
		{
			tvRemainWordCount.setText("㻹" + remainWordCount + "");
			tvRemainWordCount.setTextColor(Color.BLACK);
		}

		else
		{
			remainWordCount = -remainWordCount;
			tvRemainWordCount.setText("ѳ" + remainWordCount + "");
			tvRemainWordCount.setTextColor(Color.RED);
		}

	}

	@Override
	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.llFace:
				Intent intent = new Intent(this, FaceList.class);
				startActivityForResult(intent, 3);
				break;
			case R.id.llSendDirectMessage:
				String directMessage = etDirectMessage.getText().toString()
						.trim();
				if ("".equals(etNick.getText().toString()))
				{
					message.showMsg("Ҫ˽ŷ˭أ");
					return;
				}
				if ("".equals(etDirectMessage.getText().toString()))
				{
					message.showMsg("˽.");
					return;
				}
				if (!"".equals(directMessage))
				{
					Task task = new Task();
					task.taskType = mTaskType;
					TaskListenerImpl taskListenerImpl = new TaskListenerImpl(
							this);
					task.taskListener = taskListenerImpl;
					task.msg = directMessage;
					task.alias = WeiboMain.mainAlias;
					task.nick = etNick.getText().toString();
					StaticResources.AddTask(task);
					finish();

				}

				break;
		}

	}

}
