package sina.weibo;

import java.util.ArrayList;
import java.util.List;

import microblog.commons.Const;
import microblog.net.DataTransfer;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONObject;
import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class ThemeCatalogs extends ListActivity implements Runnable
{

	private List<String> mThemeCatalogs = new ArrayList<String>();
	private List<Integer> mThemeCatalogIDs = new ArrayList<Integer>();
	private Handler mHandler = new Handler()
	{

		@Override
		public void handleMessage(android.os.Message msg)
		{
			super.handleMessage(msg);
			String[] themeCatalogs = new String[mThemeCatalogs.size()];
			ArrayAdapter<String> aaAdapter = new ArrayAdapter<String>(
					ThemeCatalogs.this, android.R.layout.simple_list_item_1,
					android.R.id.text1, mThemeCatalogs.<String>toArray(themeCatalogs));
			ThemeCatalogs.this.setListAdapter(aaAdapter);
		}
	};

	@Override
	protected void onListItemClick(ListView l, View v, int position, long id)
	{
		super.onListItemClick(l, v, position, id);
		
		Intent intent = new Intent(this, Themes.class);
		intent.putExtra("theme_catalog_id", mThemeCatalogIDs.get(position));
		startActivity(intent);
		
		
	}

	@Override
	public void run()
	{
		try
		{
			
			String result = DataTransfer.sendData("",
					Const.URL_HAPPYBLOG_THEME_CATALOGS);
		
			JSONArray jsonArray = new JSONArray(result);
			for (int i = 0; i < jsonArray.length(); i++)
			{
				JSONObject jsonObject = new JSONObject(jsonArray.get(i).toString());
				
				mThemeCatalogIDs.add(jsonObject.getInt("id"));
				mThemeCatalogs.add(jsonObject.getString("theme_catalog_name"));
			}
			mHandler.sendEmptyMessage(0);
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		Thread thread = new Thread(this);
		thread.start();

	}

}
