package sina.weibo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import microblog.commons.Const;
import microblog.net.DataTransfer;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Values;
import sina.weibo.storage.HappyBlogConfig;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONObject;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageView;

public class Themes extends Activity implements Runnable, OnItemClickListener,
		android.view.View.OnClickListener
{
	private final int COUNT = 20;
	private int mThemeCatalogId;
	private int mPage = 1;
	private GridView mGridView;
	private ThemeAdapter mThemeAdapter;
	private HappyBlogConfig mHappyBlogConfig;
	private Button mbtnPrev;
	private Button mbtnNext;

	private List<ResultTheme> mResultThemes = new ArrayList<Themes.ResultTheme>();

	class ResultTheme
	{
		private int id;
		private String filenamePrefix;
		private String themeName;

		public int getId()
		{
			return id;
		}

		public void setId(int id)
		{
			this.id = id;
		}

		public String getFilenamePrefix()
		{
			return filenamePrefix;
		}

		public void setFilenamePrefix(String filenamePrefix)
		{
			this.filenamePrefix = filenamePrefix;
		}

		public String getThemeName()
		{

			return themeName;
		}

		public void setThemeName(String themeName)
		{
			this.themeName = themeName;
		}

	}

	class RequestTheme
	{
		private int theme_catalog_id;
		private int page;
		private int count;

		public int getTheme_catalog_id()
		{
			return theme_catalog_id;
		}

		public void setTheme_catalog_id(int theme_catalog_id)
		{
			this.theme_catalog_id = theme_catalog_id;
		}

		public int getPage()
		{
			return page;
		}

		public void setPage(int page)
		{
			this.page = page;
		}

		public int getCount()
		{
			return count;
		}

		public void setCount(int count)
		{
			this.count = count;
		}

	}

	private Handler mHandler = new Handler()
	{

		@Override
		public void handleMessage(Message msg)
		{
			super.handleMessage(msg);
			switch (msg.what)
			{
				case 0:
					mThemeAdapter = new ThemeAdapter(Themes.this);
					mGridView.setAdapter(mThemeAdapter);
					break;
				case 1: // ͼرս

					WeiboMain happyBlogAndroid = (WeiboMain) AndroidUtil
							.getMainTimelineOperationProcess(Themes.this).mActivity;
					AndroidUtil.changeBackground(happyBlogAndroid.getWindow());

					finish();

					break;
				case 2: // ֻһҳ
					mbtnPrev.setEnabled(false);
					mbtnNext.setEnabled(false);
					mPage = 1;
					break;
				case 3: // һҳ
					mbtnNext.setEnabled(false);
					mbtnPrev.setEnabled(true);
					break;
				case 4: // һҳ
					mbtnPrev.setEnabled(false);
					mbtnNext.setEnabled(true);
					mPage = 1;
					break;
				case 5: // мĳҳ
					mbtnPrev.setEnabled(true);
					mbtnNext.setEnabled(true);
					break;
				default:
					break;
			}
		}

	};

	@Override
	public void run()
	{
		try
		{

			RequestTheme requestTheme = new RequestTheme();
			requestTheme.setTheme_catalog_id(mThemeCatalogId);
			requestTheme.setPage(mPage);
			requestTheme.setCount(COUNT);
			JSONObject jsonObject = new JSONObject(requestTheme);

			String result = DataTransfer.sendData(jsonObject.toString(),
					Const.URL_HAPPYBLOG_THEMES);

			JSONArray jsonArray = new JSONArray(result);
			// ֻһҳ
			if (mPage == 1 && jsonArray.length() < 20)
			{
				mHandler.sendEmptyMessage(2);
			}
			// мĳҳ
			else if (mPage > 1 && jsonArray.length() == 20)
			{
				mHandler.sendEmptyMessage(5);
			}
			// һҳ
			else if (mPage > 1 && jsonArray.length() < 20)
			{
				mHandler.sendEmptyMessage(3);
			}
			// һҳ
			else if (mPage == 1)
			{
				mHandler.sendEmptyMessage(4);
			}
			mResultThemes.clear();
			for (int i = 0; i < jsonArray.length(); i++)
			{
				jsonObject = new JSONObject(jsonArray.get(i).toString());
				ResultTheme resultTheme = new ResultTheme();
				resultTheme.setId(jsonObject.getInt("id"));
				resultTheme.setFilenamePrefix(jsonObject
						.getString("filename_prefix"));
				resultTheme.setThemeName(jsonObject.getString("theme_name"));
				mResultThemes.add(resultTheme);

			}

			mHandler.sendEmptyMessage(0);

		}
		catch (Exception e)
		{
			// TODO: handle exception
		}

	}

	class ThemeAdapter extends BaseAdapter implements Runnable
	{
		private LayoutInflater mLayoutInflater;

		public ThemeAdapter(Context context)
		{
			mLayoutInflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			Thread thread = new Thread(this);
			thread.start();
		}

		@Override
		public int getCount()
		{
			return mResultThemes.size();
		}

		@Override
		public Object getItem(int position)
		{
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public long getItemId(int position)
		{
			// TODO Auto-generated method stub
			return 0;
		}

		private Bitmap getThemeBitmap(int position)
		{
			String filename = Const.URL_HAPPYBLOG_THEMES_ROOT + mThemeCatalogId
					+ "/" + mResultThemes.get(position).getFilenamePrefix()
					+ "_small.jpg";
			int filenameHashCode = filename.hashCode();
			filename = Values.getThemeImagePath() + filenameHashCode;
			if (new File(filename).exists())
			{
				return BitmapFactory.decodeFile(filename);
			}
			return null;
		}

		public void download(String filename)
		{
			try
			{
				String localFilename = Values.getThemeImagePath()
						+ filename.hashCode();

				if (new File(localFilename).exists())
					return;

				URL url = new URL(filename);
				HttpURLConnection httpURLConnection = (HttpURLConnection) url
						.openConnection();
				httpURLConnection.setRequestMethod("GET");
				httpURLConnection.setDoInput(true);
				InputStream is = httpURLConnection.getInputStream();
				FileOutputStream fis = new FileOutputStream(localFilename);
				byte[] buffer = new byte[8192];
				int count = 0;
				while ((count = is.read(buffer)) >= 0)
				{
					fis.write(buffer, 0, count);
				}

				fis.close();
				is.close();

			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
		}

		private Handler mHandler = new Handler()
		{

			@Override
			public void handleMessage(Message msg)
			{

				super.handleMessage(msg);
				ThemeAdapter.this.notifyDataSetChanged();
			}

		};

		@Override
		public void run()
		{
			try
			{
				for (int i = 0; i < mResultThemes.size(); i++)
				{
					String filename = Const.URL_HAPPYBLOG_THEMES_ROOT
							+ mThemeCatalogId + "/"
							+ mResultThemes.get(i).getFilenamePrefix()
							+ "_small.jpg";

					download(filename);
					mHandler.sendEmptyMessage(0);

				}
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}

		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent)
		{
			if (convertView == null)
				convertView = mLayoutInflater
						.inflate(R.layout.theme_item, null);

			ImageView ivThemeImage = (ImageView) convertView
					.findViewById(R.id.ivThemeImage);
			Bitmap bitmap = getThemeBitmap(position);

			ivThemeImage.setImageBitmap(bitmap);

			return convertView;
		}
	}

	@Override
	public void onClick(View view)
	{
		Thread thread = null;
		switch (view.getId())
		{
			case R.id.btnPrev:
				mPage--;
				setTitle("--" + mPage + "ҳ");
				thread = new Thread(this);
				thread.start();
				if (mPage == 1)
					mbtnPrev.setEnabled(false);
				break;

			case R.id.btnNext:
				mPage++;
				setTitle("--" + mPage + "ҳ");
				thread = new Thread(this);
				thread.start();

				break;
		}
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.themes);

		mThemeCatalogId = getIntent().getIntExtra("theme_catalog_id", 1);
		mGridView = (GridView) findViewById(R.id.gvThemes);

		mbtnPrev = (Button) findViewById(R.id.btnPrev);
		mbtnNext = (Button) findViewById(R.id.btnNext);

		mGridView.setOnItemClickListener(this);
		mbtnPrev.setOnClickListener(this);
		mbtnNext.setOnClickListener(this);
		mHappyBlogConfig = new HappyBlogConfig(this);
		setTitle("--" + mPage + "ҳ");

		mbtnPrev.setEnabled(false);
		mbtnNext.setEnabled(false);
		Thread thread = new Thread(this);
		thread.start();
	}

	class Download implements Runnable
	{
		private String mFilename;

		public Download(String filename)
		{
			mFilename = filename;
		}

		@Override
		public void run()
		{

			mThemeAdapter.download(mFilename);
			mHappyBlogConfig.setValue("theme_filename", mFilename.hashCode());
			mHandler.sendEmptyMessage(1);
		}

	}

	@Override
	public void onItemClick(AdapterView<?> arg0, View view, final int position,
			long id)
	{
		new AlertDialog.Builder(this).setMessage("Ƿѡ˸⣿").setTitle("ȷ")
				.setIcon(R.drawable.question)
				.setPositiveButton("ȷ", new OnClickListener()
				{

					@Override
					public void onClick(DialogInterface dialog, int which)
					{
						String filename = Const.URL_HAPPYBLOG_THEMES_ROOT
								+ mThemeCatalogId
								+ "/"
								+ mResultThemes.get(position)
										.getFilenamePrefix() + ".jpg";

						Thread thread = new Thread(new Download(filename));
						thread.start();
					}
				}).setNegativeButton("ȡ", null).show();

	}

}
