package sina.weibo;

import sina.weibo.commons.AndroidUtil;
import weibo4j.User;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

public class UserViewer extends Activity implements Runnable
{
	private String mUserId;
	private TextView mtvFriendship;
	private Button mbtnFriendship;
	private int mThreadType; // 1: showFriendship 2:createFriendship
	private int mFriendship;
	private String mName;
	private Handler mHandler = new Handler()
	{

		@Override
		public void handleMessage(Message msg)
		{
			switch (mThreadType)
			{
				case 1:
					int friendship = msg.what;
					switch (friendship)
					{
						case 0:
							mtvFriendship.setText("δע");
							mbtnFriendship.setText("ӹע");
							break;
						case 1:
							mtvFriendship.setText("ѹע");
							mbtnFriendship.setText("ȡע");
							break;
						/*case 2:
							mtvFriendship.setText("ҵķ˿");
							mbtnFriendship.setText("ӹע");
							break;
						case 3:
							mtvFriendship.setText("ע");
							mbtnFriendship.setText("ȡע");
							break;*/							
					}
					break;

				case 2:

					mbtnFriendship.setText("ȡע");
					mtvFriendship.setText("ѹע");
					break;
				case 3:

					mbtnFriendship.setText("ӹע");
					mtvFriendship.setText("δע");
					break;					
			}
			super.handleMessage(msg);
		}

	};

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		View view = getLayoutInflater().inflate(R.layout.user_viewer, null);
		setContentView(view);
		AndroidUtil.changeBackground(getWindow());
		AndroidUtil.changeColorTransparency(view);
		String profileImagePath = getIntent()
				.getStringExtra("profileimagepath");
		mName = getIntent().getStringExtra("name");

		String location = getIntent().getStringExtra("location");
		int friendCount = getIntent().getExtras().getInt("friendCount");
		int followerCount = getIntent().getExtras().getInt("followerCount");
		int statusCount = getIntent().getExtras().getInt("statusCount");
		mUserId = getIntent().getStringExtra("userId");
		String description = getIntent().getStringExtra("description");
		boolean verified = getIntent().getExtras().getBoolean("verified");

		String text = getIntent().getStringExtra("text");
		ImageView ivProfileImage = (ImageView) findViewById(R.id.ivProfileImage);
		TextView tvName = (TextView) findViewById(R.id.tvName);
		mtvFriendship = (TextView) findViewById(R.id.tvFriendship);
		mbtnFriendship = (Button) findViewById(R.id.btnFriendship);
		TextView tvLocation = (TextView) findViewById(R.id.tvLocation);
		TextView tvFriendCount = (TextView) findViewById(R.id.tvFriendCount);
		TextView tvFollowerCount = (TextView) findViewById(R.id.tvFollowerCount);
		TextView tvStatusCount = (TextView) findViewById(R.id.tvStatusCount);
		TextView tvDescription = (TextView) findViewById(R.id.tvDescription);
		TextView tvText = (TextView) findViewById(R.id.tvText);

		AndroidUtil.getMainTimelineOperationProcess(this).loadBitmap(
				profileImagePath, ivProfileImage);
		tvName.setText(mName);
		if (verified)
		{
			ImageView ivVerified = (ImageView) findViewById(R.id.ivVerified);
			ivVerified.setVisibility(View.VISIBLE);
		}
		tvLocation.setText("ڵأ" + location);
		tvFriendCount.setText("ע\n" + friendCount);
		tvFollowerCount.setText("˿\n" + followerCount);
		tvStatusCount.setText("΢\n" + statusCount);

		tvDescription.setText(description);
		tvText.setText(text);
		mThreadType = 1;
		Thread thread = new Thread(this);
		thread.start();
		AndroidUtil.changeBackground(getWindow());
	}

	public void onClick_CreateFriendship(View view)
	{
		if (mThreadType == 2)
			mThreadType = 3;
		else
			mThreadType = 2;
		mbtnFriendship.setText("ڴ...");
		Thread thread = new Thread(this);
		thread.start();

	}

	public void onClick_SendDirectMessage(View view)
	{
		Intent intent = new Intent(this,  SendDirectMessage.class);
		intent.putExtra("nick", mName );
		startActivity(intent);
	}

	@Override
	public void run()
	{
		switch (mThreadType)
		{
			case 1: // showFriendship
				String userID1 = String.valueOf(WeiboMain.mCurrentUser
						.getId());

				try
				{
					mFriendship = AndroidUtil.getCurrentMyMicroBlog(this)
							.showFriendship(userID1, mUserId);

					
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}
				mHandler.sendEmptyMessage(mFriendship);
				break;
			case 2: // createFriendship
				try
				{
					User user = AndroidUtil.getCurrentMyMicroBlog(this)
							.createFriendship(mUserId);
					
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}
				mHandler.sendEmptyMessage(0);
				break;
			case 3: // destroyFriendship
				try
				{

					User user = AndroidUtil.getCurrentMyMicroBlog(this)
							.destroyFriendship(mUserId);
					
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}
				mHandler.sendEmptyMessage(0);
				break;
		}

	}

}
