package sina.weibo;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

import microblog.StaticResources;
import microblog.thread.Task;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.TaskListenerImpl;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.graphics.Color;
import android.os.Bundle;
import android.provider.MediaStore;
import android.speech.RecognizerIntent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

public class WeiboCamera extends Activity implements TextWatcher
{
	private static boolean mCamera = false;
	private static Bitmap mBitmap;
	private ImageView mivPhoto;
	private EditText metMicroBlog;
	private TextView mtvRemainWordCount;
   
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		WeiboMain.init(this);
		String mainAlias = WeiboMain.happyBlogConfig.getString(
				Values.MAIN_ALIAS, "");
		if ("".equals(mainAlias))
		{
			Message.showMsg(this, "ûе¼޷б.");
			finish();
		}
		else
		{

		
			View view = getLayoutInflater().inflate(R.layout.happyblog_camera, null);
			setContentView(view);
			AndroidUtil.changeBackground(getWindow());
			AndroidUtil.changeColorTransparency(view);
			if (!mCamera)
			{
				mCamera = true;
				Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
				startActivityForResult(intent, Values.REQUEST_CODE_CAPTURE);

			}
			mivPhoto = (ImageView) findViewById(R.id.ivPhoto);

			metMicroBlog = (EditText) findViewById(R.id.etMicroBlog);
			mtvRemainWordCount = (TextView) findViewById(R.id.tvRemainWordCount);
			metMicroBlog.setText("ͼƬ.");

			if (mBitmap != null)
			{

				mivPhoto.setImageBitmap(mBitmap);
			}
			AndroidUtil.startService(this);
			metMicroBlog.addTextChangedListener(this);
			
			updateMessage();
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (resultCode == Activity.RESULT_OK)
		{
			switch (requestCode)
			{
				case Values.REQUEST_CODE_CAPTURE:

					mBitmap = (Bitmap) data.getExtras().get("data");

					if (mBitmap != null)
					{

						mivPhoto.setImageBitmap(mBitmap);
						metMicroBlog.setSelection(0, metMicroBlog.getText()
								.toString().length());
						

					}
					break;
				case Values.REQUEST_CODE_FACE:
					// ѡ
					String face = data.getStringExtra("face");
					StringBuilder sb = new StringBuilder(metMicroBlog.getText()
							.toString());
					int start = metMicroBlog.getSelectionStart();
					sb.insert(start, face);

					metMicroBlog.setText(sb.toString());
					metMicroBlog.setSelection(start + face.length());
					break;
				case Values.REQUEST_CODE_VOICE_RECOGNITION:

					ArrayList<String> matches = data
							.getStringArrayListExtra(RecognizerIntent.EXTRA_RESULTS);
					if (matches.size() > 0)
					{
						sb = new StringBuilder(metMicroBlog.getText()
								.toString());
						start = metMicroBlog.getSelectionStart();

						sb.insert(start, matches.get(0));
						metMicroBlog.setText(sb.toString());
						metMicroBlog.setSelection(start
								+ matches.get(0).length());
					}
					break;
			}
		}
		else
		{
			finish();
		}

	}

	public void onClick_Post(View view)
	{
		if (mBitmap != null)
		{
			if ("".equals(metMicroBlog.getText().toString()))
			{
				Message.showMsg(this, "û.");
				return;
			}

			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			mBitmap.compress(CompressFormat.PNG, 100, baos);
			byte[] bitmapBytes = baos.toByteArray();
			Task task = new Task();

			task.alias = WeiboMain.mainAlias;

			task.msg = metMicroBlog.getText().toString();
			task.taskListener = new TaskListenerImpl(this);
			task.image = bitmapBytes;
			StaticResources.AddTask(task);
			mCamera = false;
			finish();
		}

	}
	public void onClick_Voice(View view)
	{
		AndroidUtil.voiceRecognizer(this);
	}
	public void onClick_Face(View view)
	{
		Intent intent = new Intent(this, FaceList.class);
		startActivityForResult(intent, 3);
	}

	public void onClick_Topic(View view)
	{

		StringBuilder sb = new StringBuilder(metMicroBlog.getText().toString());
		int start = metMicroBlog.getSelectionStart();
		sb.insert(start, "##");

		metMicroBlog.setText(sb.toString());
		metMicroBlog.setSelection(start + 1);
	}

	public void onClick_Close(View view)
	{
		finish();
	}

	@Override
	protected void onDestroy()
	{
		mCamera = false;
		mBitmap = null;
		super.onDestroy();
	}

	@Override
	public void afterTextChanged(Editable s)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void beforeTextChanged(CharSequence s, int start, int count,
			int after)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count)
	{
		updateMessage();

	}

	private void updateMessage()
	{

		int remainWordCount = Values.getRemainWordCount(metMicroBlog.getText()
				.toString());
		if (remainWordCount >= 0)
		{
			mtvRemainWordCount.setText("㻹" + remainWordCount + "");
			mtvRemainWordCount.setTextColor(Color.BLACK);
		}

		else
		{
			remainWordCount = -remainWordCount;
			mtvRemainWordCount.setText("ѳ" + remainWordCount + "");
			mtvRemainWordCount.setTextColor(Color.RED);
		}

	}
}
