package sina.weibo;

import java.util.HashMap;

import microblog.MyMicroBlogAsync;
import microblog.commons.EncryptDecrypt;
import microblog.storage.SqliteCursor;
import microblog.storage.SystemDBService;
import microblog.thread.ProcessTasks;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Values;
import sina.weibo.process.AndroidLog;
import sina.weibo.process.ChangeDatabasePath;
import sina.weibo.process.LoginOptionsMenuProcess;
import sina.weibo.process.LoginProcess;
import sina.weibo.process.MainButtonProcess;
import sina.weibo.process.MainContextMenuProcess;
import sina.weibo.process.MainMoreMenuProcess;
import sina.weibo.process.MainOptionsMenuProcess;
import sina.weibo.process.NotificationProcess;
import sina.weibo.process.TimelineOperationProcess;
import sina.weibo.storage.DatabaseOperatorImpl;
import sina.weibo.storage.HappyBlogConfig;
import sina.weibo.storage.MySQLiteOpenHelper;
import sina.weibo.thread.CleanCache;
import weibo4j.MBlog;
import weibo4j.Status;
import weibo4j.User;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;

public class WeiboMain extends Activity
{

	// /////////static//////////////////
	public static boolean loadMainLayout = false;
	// keyʾ

	public static String happyBlogAccount = "androidguy";
	public static String mainAlias;

	public static HappyBlogConfig happyBlogConfig;

	// public static TimelineOperationProcess mMainTimelineOperationProcess;

	public static ProcessTasks mProcessTasks;

	public static NotificationProcess mNotificationProcess;

	// ////////////////////////////////

	// /////////////////////
	public static TextView mtvName;
	public static TextView mtvStatus;
	// ///////////////////////
	public MainOptionsMenuProcess mMainOptionsMenuProcess;
	public MainContextMenuProcess mMainContextMenuProcess;
	public MainMoreMenuProcess mMainMoreMenuProcess;
	public Menu mOptionsMenu;
	public MainButtonProcess mMainButtonProcess;
	public static LoginProcess loginProcess;
	public static int mCurrentPosition;
	public static String mCurrentStatusId;
	public static String mCurrentCommentId; 
	// ͨת۷StatusֵΪմ
	public static String mCurrentStatusText;
	public static String mCurrentCommentText;
	public static String mCurrentUserName;
	public static boolean mhasRetweeting;
	public static String mCurrentRetweetingUserName;
	public static String mCurrentRetweetingId;
	public static String mCurrentProfileImagePath;
	public static String mCurrentRetweetDetailProfileImagePath;

	public static Status mCurrentStatus;
	public static weibo4j.Comment mCurrentComment;
	public static User mCurrentUser;
	public static MBlog mCurrentMBlog;

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event)
	{

		return super.onKeyUp(keyCode, event);
	}

	public View loadLoginLayout()
	{

		View view = getLayoutInflater().inflate(R.layout.login, null);

		setContentView(view);
		setTitle(R.string.login_title);
		loadMainLayout = false;
		loginProcess = new LoginProcess(view, this);
		return view;

	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{

		switch (requestCode)
		{
			case Values.REQUEST_CODE_SELECT_ACCOUNT:
				if (resultCode == Values.RESULT_CODE_SELECT_ACCOUNT)
				{
					EditText etAccount = (EditText) findViewById(R.id.etAccount);
					String account = data.getStringExtra("account");
					etAccount.setText(account);
				}
				break;
			case Values.REQUEST_CODE_ACCOUNT_MANAGER:

				if (resultCode == Values.RESULT_CODE_ACCOUNT_MANAGER)
				{
					// accountͬ
					String currentAlias = data.getStringExtra("alias");
					String password = data.getStringExtra("password");

					if (!currentAlias.equals(mainAlias))
					{
						AndroidUtil.setHomeTimelineOperationProcess(this, null);

						AndroidUtil.setMainTimelineOperationProcess(this, null);

						WeiboMain.mainAlias = currentAlias;
						WeiboMain.happyBlogConfig.setValue(Values.MAIN_ALIAS,
								WeiboMain.mainAlias);
						if (loginProcess == null)
							loginProcess = new LoginProcess(this);

						loginProcess.login(mainAlias, password);

					}
				}
				break;
		}
		super.onActivityResult(requestCode, resultCode, data);
	}

	public static void init(Context context)
	{
		try
		{

			if (mNotificationProcess == null)
			{
				mNotificationProcess = new NotificationProcess(context);
				new Thread(mNotificationProcess).start();
			}
			if (AndroidUtil.getSystemDBService(context) == null)
				AndroidUtil.setSystemDBService(context, new SystemDBService(
						new DatabaseOperatorImpl(new MySQLiteOpenHelper(
								new ChangeDatabasePath()))));
			if (happyBlogConfig == null)
				happyBlogConfig = new HappyBlogConfig(context);

			if (AndroidUtil.getMyMicroBlogs(context) == null)
			{
				AndroidUtil.setMyMicroBlogs(context,
						new HashMap<String, MyMicroBlogAsync>());
				SqliteCursor sqliteCursor = AndroidUtil.getSystemDBService(
						context).getMicroBlogAccounts(happyBlogAccount);
				if (AndroidUtil.getMyMicroBlogs(context).size() == 0)
				{
					while (sqliteCursor.moveToNext())
					{
						MyMicroBlogAsync myMicroBlog = new MyMicroBlogAsync(

						sqliteCursor.getString("microblog_account"),
								EncryptDecrypt.decrypt(sqliteCursor
										.getString("password")),
								new MyKeySecret());

						AndroidUtil.getMyMicroBlogs(context).put(
								sqliteCursor.getString("alias"), myMicroBlog);
						myMicroBlog.myLog = new AndroidLog();
						myMicroBlog.setAlias(sqliteCursor.getString("alias"));

					}
				}

			}

			if (mainAlias == null)
				mainAlias = happyBlogConfig.getString(Values.MAIN_ALIAS, "");
			if (context instanceof WeiboMain)
			{
				WeiboMain weiboMain = (WeiboMain) context;
				TimelineOperationProcess mainTimelineOperationProcess = AndroidUtil
						.getMainTimelineOperationProcess(context);

				if (mainTimelineOperationProcess != null)
				{
					mainTimelineOperationProcess.mActivity = (Activity) context;
					weiboMain.mMainButtonProcess = new MainButtonProcess(
							weiboMain);
					mainTimelineOperationProcess.loadStatuses();

				}
				else
				{

					AndroidUtil.setHomeTimelineOperationProcess(context,
							new TimelineOperationProcess((WeiboMain) context));
					TimelineOperationProcess hometTimelineOperationProcess = AndroidUtil
							.getHomeTimelineOperationProcess(context);
					hometTimelineOperationProcess.mInitData = true;

					MyMicroBlogAsync myMicroBlogAsync = AndroidUtil
							.getMyMicroBlogs(context).get(mainAlias);

					myMicroBlogAsync
							.getHomeTimelineAsync(hometTimelineOperationProcess);

					AndroidUtil.setMainTimelineOperationProcess(context,
							hometTimelineOperationProcess);

					// þ̬
					weiboMain.mMainButtonProcess = new MainButtonProcess(
							(WeiboMain) context);
					weiboMain.setTitle(R.string.main_title);
				}
			}

			if (mProcessTasks == null)
			{
				mProcessTasks = new ProcessTasks(
						AndroidUtil.getMyMicroBlogs(context));
				mProcessTasks.myLog = new AndroidLog();
				Thread thread = new Thread(mProcessTasks);
				thread.start();

			}
			// װprofile

			AndroidUtil.loadProfileImage(context);

			AndroidUtil.startService(context);

		}
		catch (Exception e)
		{

			Log.e("exception_HappyBlogAndroid_init", String.valueOf(e));

		}
	}

	@Override
	protected void onDestroy()
	{
		// NotificationProcess.finishFlag = true;
		if (!loadMainLayout)
		{
			// loginProcess.stop();

		}
		try
		{
			setContentView(R.layout.about);
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}

		super.onDestroy();
	}

	public static View mView = null;

	public View loadMainLayout()
	{

		try
		{

			AndroidUtil.hideAllListView(this);
			Configuration config = getResources().getConfiguration();
			if (config.orientation == Configuration.ORIENTATION_LANDSCAPE)
				mView = AndroidUtil.getLandscapeView(this);
			else if (config.orientation == Configuration.ORIENTATION_PORTRAIT)
				mView = AndroidUtil.getPortraitView(this);
			if (mView == null)
				mView = getLayoutInflater().inflate(R.layout.weibo_main,
						null);
			if (config.orientation == Configuration.ORIENTATION_LANDSCAPE)
				AndroidUtil.setLandscapeView(this, mView);
			else if (config.orientation == Configuration.ORIENTATION_PORTRAIT)
				AndroidUtil.setPortraitView(this, mView);

			setContentView(mView);
			mtvName = (TextView) findViewById(R.id.tvName);
			mtvStatus = (TextView) findViewById(R.id.tvStatus);
			init(this);
			AndroidUtil.changeBackground(getWindow());
			AndroidUtil.changeColorTransparency(mView);
			AndroidUtil.showStartupMsg(this);

		}
		catch (Exception e)
		{
			AndroidUtil.hideAllListView(this);
		}
		return mView;
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v,
			ContextMenuInfo menuInfo)
	{

		if (AndroidUtil.getMainTimelineOperationProcess(this) != null
				&& AndroidUtil.getMainTimelineOperationProcess(this)
						.isDeleted())
			return;

		MenuInflater menuInflater = getMenuInflater();
		if (loadMainLayout)
		{
			if (v.getId() == R.id.llMore)
			{
				menuInflater.inflate(R.menu.main_more_menu, menu);
				mMainMoreMenuProcess = new MainMoreMenuProcess(this, menu);
			}
			else
			{
				menuInflater.inflate(R.menu.main_context_menu, menu);
				mMainContextMenuProcess = new MainContextMenuProcess(this, menu);

			}

		}
		else
		{

			menuInflater.inflate(R.menu.account_context_menu, menu);

			new LoginOptionsMenuProcess(this, menu);

		}

		super.onCreateContextMenu(menu, v, menuInfo);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		mOptionsMenu = menu;
		if (menu != null)
			menu.clear();
		if (loadMainLayout)
		{
			menuInflater.inflate(R.menu.main_options_menu, menu);
			MenuItem miSearch = (MenuItem) menu.findItem(R.id.mnuSearch);
			MenuItem miAccountManager = (MenuItem) menu
					.findItem(R.id.mnuAccountManager);
			MenuItem miLogout = (MenuItem) menu.findItem(R.id.mnuLogout);
			MenuItem miAbout = (MenuItem) menu.findItem(R.id.mnuAbout);
			MenuItem miSetting = (MenuItem) menu.findItem(R.id.mnuSetting);
			miSearch.setIcon(R.drawable.search);
			miAccountManager.setIcon(R.drawable.account_manager);
			miLogout.setIcon(R.drawable.logout);
			miAbout.setIcon(R.drawable.about);
			miSetting.setIcon(R.drawable.setting);

			mMainOptionsMenuProcess = new MainOptionsMenuProcess(this, menu);
		}
		else
		{
			menuInflater.inflate(R.menu.account_context_menu, menu);

			new LoginOptionsMenuProcess(this, menu);
		}
		return super.onCreateOptionsMenu(menu);
	}

	@Override
	public void finish()
	{
		try
		{
			new AlertDialog.Builder(this)
					.setIcon(R.drawable.question)
					.setTitle("Ƿ˳")
					.setPositiveButton("ȷ",
							new DialogInterface.OnClickListener()
							{
								public void onClick(DialogInterface dialog,
										int whichButton)
								{
									WeiboMain.super.finish();
								}
							})
					.setNegativeButton("ȡ",
							new DialogInterface.OnClickListener()
							{
								public void onClick(DialogInterface dialog,
										int whichButton)
								{

								}
							}).show();
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
	}

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);		
		super.onCreate(savedInstanceState);
		CleanCache.clearCache();

		if (happyBlogConfig == null)
			happyBlogConfig = new HappyBlogConfig(this);
		mainAlias = happyBlogConfig.getString(Values.MAIN_ALIAS, "");
		if (Values.ignoreLogin(mainAlias,
				happyBlogConfig.getInt(Values.DATA_TYPE)))
			loadMainLayout = true;

		if (!loadMainLayout)
		{
			mView = loadLoginLayout();
			  
			
		}
		else 
		{

			mView = loadMainLayout();
		}
	}
}