package sina.weibo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;

import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.MyHandler;
import sina.weibo.process.TaskListenerImpl;

import microblog.StaticResources;
import microblog.storage.SqliteCursor;
import microblog.thread.Task;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Bitmap.CompressFormat;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.speech.RecognizerIntent;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

public class WriteMicroBlog extends Activity implements OnClickListener,
		TextWatcher, OnMenuItemClickListener
{
	private EditText etMicroBlog;
	private TextView tvRemainWordCount;
	private ImageView ivPhoto;
	public static TaskListenerImpl mTaskProcess;
	private static byte[] mBitmapBytes;
	private static ByteArrayInputStream mBitmapInputStream;
	private static String mCurrentPhotoFilename;
	private static Bitmap mBitmap;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		View view = getLayoutInflater()
				.inflate(R.layout.writeblogandroid, null);

		setContentView(view);
		AndroidUtil.changeBackground(getWindow());
		AndroidUtil.changeColorTransparency(view);
		Button btnPost = (Button) findViewById(R.id.btnPost);
		etMicroBlog = (EditText) findViewById(R.id.etMicroBlog);
		tvRemainWordCount = (TextView) findViewById(R.id.tvRemainWordCount);
		ivPhoto = (ImageView) findViewById(R.id.ivPhoto);
		if (mBitmap != null)
			ivPhoto.setImageBitmap(mBitmap);
		btnPost.setOnClickListener(this);
		etMicroBlog.addTextChangedListener(this);
		registerForContextMenu(ivPhoto);
		updateMessage();

	}

	@Override
	public void afterTextChanged(Editable s)
	{
		// TODO Auto-generated method stub

	}

	static class SyncStatus implements Runnable
	{
		private MyHandler myHandler;
		private String mText;
		private byte[] mBitmapBytes;
		private Context mContext;

		public SyncStatus(Context context, String text, byte[] bitmapBytes)
		{
			mContext = context;
			mText = text;
			mBitmapBytes = bitmapBytes;
			myHandler = new MyHandler();

		}

		@Override
		public void run()
		{
			try
			{

				SqliteCursor sqliteCursor = AndroidUtil.getSystemDBService(
						mContext).getMicroBlogAccounts(
						WeiboMain.happyBlogAccount);

				while (sqliteCursor.moveToNext())
				{

					if (!sqliteCursor.getBoolean("sync"))
						continue;
					if (!sqliteCursor.getString("alias").equals(
							WeiboMain.mainAlias))
					{

						Task task = new Task();
						task.alias = sqliteCursor.getString("alias");
						task.msg = mText;
						task.taskListener = mTaskProcess;

						if (mBitmapInputStream != null
								&& (sqliteCursor.getString("microblog").equals(
										"sina") || sqliteCursor.getString(
										"microblog").equals("sohu")))
						{

							task.image = mBitmapBytes;
						}

						StaticResources.AddTask(task);
					}
				}
			}
			catch (Exception e)
			{
				Log.e("post_status_exception", String.valueOf(e));
			}

		}

	}

	@Override
	public void beforeTextChanged(CharSequence s, int start, int count,
			int after)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count)
	{
		updateMessage();

	}

	@Override
	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.btnPost:

				if ("".equals(etMicroBlog.getText().toString()))
				{
					if (mBitmap == null)
					{
						return;
					}
					else
					{
						etMicroBlog.setText("ͼƬ");
					}
				}

				Task task = new Task();

				task.alias = WeiboMain.mainAlias;
				mTaskProcess = new TaskListenerImpl(this);
				task.msg = etMicroBlog.getText().toString();
				task.taskListener = mTaskProcess;
				task.image = mBitmapBytes;
				StaticResources.AddTask(task);

				// ͬ΢
				new Thread(new SyncStatus(this, task.msg, mBitmapBytes))
						.start();

				etMicroBlog.setText("");

				if (mBitmap != null && !mBitmap.isRecycled())
					mBitmap.recycle();
				mBitmap = null;
				ivPhoto.setImageBitmap(null);
				Message.showTaskQueueMsg("д΢", this);
				finish();

				break;

			default:
				break;
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{

		if (resultCode == Activity.RESULT_OK)
		{
			switch (requestCode)
			{
				case Values.REQUEST_CODE_CAPTURE:
					mCurrentPhotoFilename = null;
					mBitmap = (Bitmap) data.getExtras().get("data");

					if (mBitmap != null)
					{
						ivPhoto.setImageBitmap(mBitmap);
						if (mBitmap != null)
						{
							ByteArrayOutputStream baos = new ByteArrayOutputStream();
							mBitmap.compress(CompressFormat.PNG, 100, baos);
							mBitmapBytes = baos.toByteArray();
							mBitmapInputStream = new ByteArrayInputStream(
									mBitmapBytes);
							try
							{
								FileOutputStream fos = new FileOutputStream(
										"/sdcard/temp.jpg");
								mCurrentPhotoFilename = "/sdcard/temp.jpg";
								fos.write(mBitmapBytes);
								fos.close();
							}
							catch (Exception e)
							{
								// TODO: handle exception
							}

						}
					}
					break;

				case Values.REQUEST_CODE_ALBUM:
					Uri uri = data.getData();

					try
					{
						Cursor cursor = getContentResolver().query(uri, null,
								null, null, null);
						cursor.moveToFirst();
						String imageFilePath = cursor.getString(1);
						mCurrentPhotoFilename = imageFilePath;
						cursor.close();
						mBitmap = Values.getFitBitmap(imageFilePath);
						if (mBitmap != null)
						{
							ivPhoto.setImageBitmap(mBitmap);
							ByteArrayOutputStream baos = new ByteArrayOutputStream();
							mBitmap.compress(CompressFormat.PNG, 100, baos);
							mBitmapBytes = baos.toByteArray();
							mBitmapInputStream = new ByteArrayInputStream(
									mBitmapBytes);

						}

					}
					catch (Exception e)
					{
						setTitle(e.getMessage());
					}
					break;
				case Values.REQUEST_CODE_FACE:
					// ѡ
					String face = data.getStringExtra("face");
					StringBuilder sb = new StringBuilder(etMicroBlog.getText()
							.toString());
					int start = etMicroBlog.getSelectionStart();
					sb.insert(start, face);

					etMicroBlog.setText(sb.toString());
					etMicroBlog.setSelection(start + face.length());
					break;
				case Values.REQUEST_CODE_VOICE_RECOGNITION:

					ArrayList<String> matches = data
							.getStringArrayListExtra(RecognizerIntent.EXTRA_RESULTS);
					if (matches.size() > 0)
					{
						sb = new StringBuilder(etMicroBlog.getText().toString());
						start = etMicroBlog.getSelectionStart();

						sb.insert(start, matches.get(0));
						etMicroBlog.setText(sb.toString());
						etMicroBlog.setSelection(start
								+ matches.get(0).length());
					}
					break;

			}
		}
		else if (resultCode == Values.RESULT_CODE_SAVE)
		{

			mCurrentPhotoFilename = Values.getEffectTempImageFilename();
			mBitmap = BitmapFactory.decodeFile(mCurrentPhotoFilename);
			if (mBitmap != null)
			{
				ivPhoto.setImageBitmap(mBitmap);
				try
				{
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					mBitmap.compress(CompressFormat.JPEG, 100, baos);
					mBitmapBytes = baos.toByteArray();
					baos.close();
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}

			}
		}

	}

	// /////////////////event//////////////////////
	public void onCapture_Click(View view)
	{

		Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
		startActivityForResult(intent, Values.REQUEST_CODE_CAPTURE);
	}

	public void onClick_Voice(View view)
	{
		AndroidUtil.voiceRecognizer(this);
	}

	public void onAlbum_Click(View view)
	{
		Intent intent = new Intent();
		intent.setType("image/*");
		intent.setAction(Intent.ACTION_GET_CONTENT);
		startActivityForResult(intent, Values.REQUEST_CODE_ALBUM);
	}

	public void onFace_Click(View view)
	{
		Intent intent = new Intent(this, FaceList.class);
		startActivityForResult(intent, 3);
	}

	public void onTopic_Click(View view)
	{

		StringBuilder sb = new StringBuilder(etMicroBlog.getText().toString());
		int start = etMicroBlog.getSelectionStart();
		sb.insert(start, "##");

		etMicroBlog.setText(sb.toString());
		etMicroBlog.setSelection(start + 1);
	}

	// /////////////////private/////////////////////
	private void updateMessage()
	{

		int remainWordCount = Values.getRemainWordCount(etMicroBlog.getText()
				.toString());
		if (remainWordCount >= 0)
		{
			tvRemainWordCount.setText("㻹" + remainWordCount + "");
			tvRemainWordCount.setTextColor(Color.BLACK);
		}

		else
		{
			remainWordCount = -remainWordCount;
			tvRemainWordCount.setText("ѳ" + remainWordCount + "");
			tvRemainWordCount.setTextColor(Color.RED);
		}

	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{
		switch (item.getItemId())
		{
			case R.id.mnuModifyPhoto:
				Intent intent = new Intent(this, PhotoViewer.class);
				Toast.makeText(this, mCurrentPhotoFilename, Toast.LENGTH_LONG)
						.show();
				intent.putExtra("filename", mCurrentPhotoFilename);
				startActivityForResult(intent, 0);

				break;

			case R.id.mnuDeletePhoto:
				ivPhoto.setImageBitmap(null);
				mBitmap = null;
				mBitmapBytes = null;
				mBitmapInputStream = null;
				mCurrentPhotoFilename = null;
				break;
		}
		return false;
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v,
			ContextMenuInfo menuInfo)
	{
		if (mBitmap == null)
			return;
		getMenuInflater().inflate(R.menu.photo_menu, menu);

		menu.findItem(R.id.mnuModifyPhoto).setOnMenuItemClickListener(this);
		menu.findItem(R.id.mnuDeletePhoto).setOnMenuItemClickListener(this);
		super.onCreateContextMenu(menu, v, menuInfo);
	}

}
