package sina.weibo.process;


import microblog.MyMicroBlogAsync;
import sina.weibo.R;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Values;
import sina.weibo.interfaces.HandlerRun;
import weibo4j.User;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;

public class AddAccountOperationProcess extends OperationProcess
{
	private String mHappyBlogAccount;
	private String mMicroBlog;
	private String mMicroBlogAccount;
	private String mPassword;
	private String mAlias;
	private MyMicroBlogAsync mMyMicroBlog;

	public AddAccountOperationProcess(Context context, String happyblogAccount,
			String microblog, String microblogAccount, String password,
			String alias, MyMicroBlogAsync myMicroBlog)
	{
		super(context);
		mHappyBlogAccount = happyblogAccount;
		mMicroBlog = microblog;
		mMicroBlogAccount = microblogAccount;
		mPassword = password;
		mAlias = alias;
		mMyMicroBlog = myMicroBlog; 

	}

	@Override
	public void onLoginSuccess(String msg, User user)
	{
		super.onLoginSuccess(msg, user);
		try
		{

			AndroidUtil.getSystemDBService(mContext).saveMicroBlogAccount(
					mHappyBlogAccount, mMicroBlog, mMicroBlogAccount,
					mPassword, mAlias);
			AndroidUtil.getMyMicroBlogs(mContext).put(mAlias, mMyMicroBlog);
			Intent intent = new Intent();
			intent.putExtra("alias", mAlias);
			((Activity) mContext).setResult(Values.RESULT_CODE_ADD_ACCOUNT, intent);
			((Activity) mContext).finish();
		}
		catch (final Exception e)
		{
			myHandler.run(new HandlerRun() 
			{

				@Override
				public void invoke()
				{

					mMessage.showMsg(mContext.getResources().getString(
							R.string.add_acount_exception));
				}
			});
		}

	}



}
