package sina.weibo.process;

import microblog.MyMicroBlogAsync;
import microblog.commons.Const;
import sina.weibo.WeiboMain;
import sina.weibo.R;
import sina.weibo.WriteMicroBlog;
import sina.weibo.commons.AndroidUtil;
import weibo4j.Paging;
import android.content.Intent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.LinearLayout;
 
public class MainButtonProcess extends ProcessParent implements OnClickListener
{
	private LinearLayout llRefresh;
	private LinearLayout llWrite;
	private LinearLayout llHome;
	private LinearLayout llMore;

	public MainButtonProcess(WeiboMain happyBlogAndroid)
	{
		super(happyBlogAndroid);
		llRefresh = (LinearLayout) happyBlogAndroid
				.findViewById(R.id.llRefresh);
		llWrite = (LinearLayout) happyBlogAndroid.findViewById(R.id.llWrite);
		llHome = (LinearLayout) happyBlogAndroid.findViewById(R.id.llHome);
		llMore = (LinearLayout) happyBlogAndroid.findViewById(R.id.llMore);
		llRefresh.setOnClickListener(this);
		llWrite.setOnClickListener(this);
		llHome.setOnClickListener(this);
		llMore.setOnClickListener(this);
		happyBlogAndroid.registerForContextMenu(llMore);
	}

	private void homeTimeline()
	{
		hideAllWidget();
		if (mlvHomeTimeline.getAdapter() != null)
		{
			mlvHomeTimeline.setVisibility(View.VISIBLE);
		//	View changePage = mHappyBlogAndroid.findViewById(R.id.llChangePage);
		//	changePage.setVisibility(View.VISIBLE);
			AndroidUtil
					.setMainTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getHomeTimelineOperationProcess(mHappyBlogAndroid));
			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil.getMainTimelineOperationProcess(
					mHappyBlogAndroid).getDataTypeTitle());			
			
		/*	AndroidUtil.getMainTimelineOperationProcess(mHappyBlogAndroid).mtvCurrentPageNumber
					.setText(String
							.valueOf(AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid).mPage));*/
		}
		else
		{
			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil
					.setMainTimelineOperationProcess(mHappyBlogAndroid,
							new TimelineOperationProcess(mHappyBlogAndroid,
									Const.TIMELINE_TYPE_STATUS,
									Const.DATA_TYPE_HOME_TIMELINE,
									R.id.lvHomeTimeline));

			AndroidUtil
					.setHomeTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid));
			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(mHappyBlogAndroid)
					.get(WeiboMain.mainAlias);
			myMicroBlogAsync.getHomeTimelineAsync(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid));
		}
	}

	@Override
	public void onClick(View view)
	{
		Intent intent = null;
		switch (view.getId())
		{
			case R.id.llRefresh:

				if (TimelineOperationProcess.mLoading)
					return;

				MyMicroBlogAsync myMicroBlogAsync =AndroidUtil.getMyMicroBlogs(mHappyBlogAndroid)
						.get(mHappyBlogAndroid.mainAlias);
				switch (AndroidUtil
						.getMainTimelineOperationProcess(mHappyBlogAndroid).mDataType)
				{
					case Const.DATA_TYPE_HOME_TIMELINE:

						AndroidUtil
								.getMainTimelineOperationProcess(mHappyBlogAndroid).mInitData = false;
						myMicroBlogAsync
								.getHomeTimelineAsync(AndroidUtil
										.getHomeTimelineOperationProcess(mHappyBlogAndroid));
						break;
					case Const.DATA_TYPE_PUBLIC_TIMELINE:

						AndroidUtil
								.getPublicTimelineOperationProcess(mHappyBlogAndroid).mInitData = false;
						myMicroBlogAsync
								.getPublicTimelineAsync(AndroidUtil
										.getPublicTimelineOperationProcess(mHappyBlogAndroid));
						break;
					case Const.DATA_TYPE_USER_TIMELINE:

						AndroidUtil
								.getUserTimelineOperationProcess(mHappyBlogAndroid).mInitData = false;

						myMicroBlogAsync
								.getUserTimelineAsync(AndroidUtil
										.getUserTimelineOperationProcess(mHappyBlogAndroid));
						break;
					case Const.DATA_TYPE_MENTIONS:

						AndroidUtil
								.getMentionsOperationProcess(mHappyBlogAndroid).mInitData = false;
						myMicroBlogAsync
								.getMentionsAsync(AndroidUtil
										.getMentionsOperationProcess(mHappyBlogAndroid));
						break;
					case Const.DATA_TYPE_COMMENTS_TIMELINE:

						AndroidUtil
								.getCommentsTimelineOperationProcess(mHappyBlogAndroid).mInitData = false;
						myMicroBlogAsync
								.getCommentsTimelineAsync(AndroidUtil
										.getCommentsTimelineOperationProcess(mHappyBlogAndroid));
						break;
					case Const.DATA_TYPE_COMMENT_BY_ME:

						AndroidUtil
								.getCommentByMeOperationProcess(mHappyBlogAndroid).mInitData = false;
						myMicroBlogAsync
								.getCommentsByMeAsync(AndroidUtil
										.getCommentByMeOperationProcess(mHappyBlogAndroid));
						break;
					case Const.DATA_TYPE_FAVORITES:

						AndroidUtil
								.getFavoritesOperationProcess(mHappyBlogAndroid).mInitData = false;
						myMicroBlogAsync
								.getFavoritesAsync(AndroidUtil
										.getFavoritesOperationProcess(mHappyBlogAndroid));
						break;
					case Const.DATA_TYPE_DIRECT_MESSAGE:
						AndroidUtil.getDirectMessageProcess(mHappyBlogAndroid).mInitData = false;
						myMicroBlogAsync.getDirectMessagesExtAsync(AndroidUtil
								.getDirectMessageProcess(mHappyBlogAndroid),
								new Paging());
						break;
					case Const.DATA_TYPE_DIRECT_MESSAGE_ME:
						AndroidUtil.getDirectMessageProcess(mHappyBlogAndroid).mInitData = false;
						myMicroBlogAsync.getDirectMessagesAsync(AndroidUtil
								.getDirectMessageProcess(mHappyBlogAndroid),
								new Paging());
						break;
				}

				break;
			case R.id.llWrite:
				intent = new Intent(mHappyBlogAndroid, WriteMicroBlog.class);
				mHappyBlogAndroid.startActivity(intent);
				
				//mHappyBlogAndroid.setTitle(String.valueOf(Debug.getNativeHeapAllocatedSize()));
				break;
			case R.id.llHome:
				homeTimeline();
				break;
			case R.id.llMore:
				mHappyBlogAndroid.openContextMenu(llMore);
				break;
		}

	}

}
