package sina.weibo.process;

import microblog.StaticResources;
import microblog.commons.Const;
import microblog.thread.Task;
import sina.weibo.BigImageViewer;
import sina.weibo.Comment;
import sina.weibo.WeiboMain;
import sina.weibo.R;
import sina.weibo.Repost;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import weibo4j.User;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MenuItem.OnMenuItemClickListener;

public class MainContextMenuProcess implements OnMenuItemClickListener
{

	private Menu mMenu;
	protected Context mContext;

	public MainContextMenuProcess()
	{

	}

	private void setMenuEvent(MenuItem item)
	{
		if (item == null)
			return;
		item.setOnMenuItemClickListener(this);

	}

	public MainContextMenuProcess(Context context, Menu menu)
	{
		try
		{
			mContext = context;
			mMenu = menu;
			MenuItem mnuComment = (MenuItem) menu.findItem(R.id.mnuComment);
			MenuItem mnuRepost = (MenuItem) menu.findItem(R.id.mnuRepost);
			MenuItem mnuFavorite = (MenuItem) menu.findItem(R.id.mnuFavorite);
			MenuItem mnuDestroyFavorite = (MenuItem) menu
					.findItem(R.id.mnuDestroyFavorite);
			MenuItem mnuViewBigImage = (MenuItem) menu
					.findItem(R.id.mnuViewBigImage);
			MenuItem mnuDeleteStatus = (MenuItem) menu
					.findItem(R.id.mnuDeleteStatus);
			MenuItem mnuCreateFriendShip = (MenuItem) menu
					.findItem(R.id.mnuCreateFriendShip);
			MenuItem mnuReplyComment = (MenuItem) menu
					.findItem(R.id.mnuReplyComment);
			switch (AndroidUtil.getMainTimelineOperationProcess(context)
					.getDataType())
			{
				case Const.DATA_TYPE_PUBLIC_TIMELINE:
				case Const.DATA_TYPE_COMMENT:
					mnuCreateFriendShip.setVisible(true);
					break;
				case Const.DATA_TYPE_FAVORITES:

					mnuFavorite.setVisible(false);
					mnuDestroyFavorite.setVisible(true);
					break;
				case Const.DATA_TYPE_COMMENT_BY_ME:
				case Const.DATA_TYPE_COMMENTS_TIMELINE:
					for (int i = 0; i < menu.size(); i++)
						menu.getItem(i).setVisible(false);
					mnuReplyComment.setVisible(true);
					break;
			}
			if (!AndroidUtil.getMainTimelineOperationProcess(mContext)
					.isMyStatus())
				mnuDeleteStatus.setVisible(false);

			if (WeiboMain.mCurrentStatus != null
					&& "".equals(WeiboMain.mCurrentStatus.getOriginalPic()))
				mnuViewBigImage.setVisible(false);
			setMenuEvent(mnuComment);
			setMenuEvent(mnuRepost);
			setMenuEvent(mnuFavorite);
			setMenuEvent(mnuDestroyFavorite);
			setMenuEvent(mnuViewBigImage);
			setMenuEvent(mnuDeleteStatus);
			setMenuEvent(mnuCreateFriendShip);
			setMenuEvent(mnuReplyComment);

		}
		catch (Exception e)
		{
			Log.d("MainContextMenuProcess_Constructure_Exception",
					e.getMessage());
		}
	}

	public MainContextMenuProcess(Context context)
	{
		mContext = context;
	}

	public void comment()
	{
		Intent intent = new Intent(mContext, Comment.class);

		if (Const.TIMELINE_TYPE_STATUS.equals(AndroidUtil
				.getMainTimelineOperationProcess(mContext).getType())
				|| Const.TIMELINE_TYPE_SEARCH_MBLOG.equals(AndroidUtil
						.getMainTimelineOperationProcess(mContext).getType()))
			intent.putExtra("statusId", WeiboMain.mCurrentStatusId);
		if (Const.TIMELINE_TYPE_COMMENT.equals(AndroidUtil
				.getMainTimelineOperationProcess(mContext).getType()))
			intent.putExtra("statusId", WeiboMain.mCurrentStatusId);

		intent.putExtra("taskType", Const.TASK_TYPE_COMMENT);
		mContext.startActivity(intent);
	}

	public void repost()
	{
		Intent intent = new Intent(mContext, Repost.class);
		intent.putExtra("hasRetweeting", WeiboMain.mhasRetweeting);

		intent.putExtra("statusText", WeiboMain.mCurrentStatusText);
		intent.putExtra("username", WeiboMain.mCurrentUserName);
		intent.putExtra("statusId", WeiboMain.mCurrentStatusId);
		intent.putExtra("retweetId", WeiboMain.mCurrentRetweetingId);

		intent.putExtra("retweetUsername", WeiboMain.mCurrentRetweetingUserName);

		mContext.startActivity(intent);
	}

	public void favorite()
	{
		Task task = new Task();
		task.taskType = Const.TASK_TYPE_FAVORITE;
		TaskListenerImpl taskListenerImpl = new TaskListenerImpl(mContext);
		task.taskListener = taskListenerImpl;
		task.alias = WeiboMain.mainAlias;

		task.statusId = WeiboMain.mCurrentStatusId;
		task.msg = WeiboMain.mCurrentStatusText;

		StaticResources.AddTask(task);
		Message.showTaskQueueMsg("ղ΢", mContext);
	}

	public void destroyFavorite()
	{
		Task task = new Task();
		task.taskType = Const.TASK_TYPE_DESTROY_FAVORITE;
		TaskListenerImpl taskListenerImpl = new TaskListenerImpl(mContext);
		task.taskListener = taskListenerImpl;
		task.alias = WeiboMain.mainAlias;
		if (false/*
				 * AndroidUtil.getMainTimelineOperationProcess(mContext).getDataType
				 * () == Const.DATA_TYPE_SEARCH_MBLOG
				 */)
		{
			task.srcid = WeiboMain.mCurrentMBlog.mblogId;
			WeiboMain.mProcessTasks.mDataType = Const.DATA_TYPE_SINA_REPOST;
		}
		else
		{

			task.statusId = WeiboMain.mCurrentStatusId;
			task.msg = WeiboMain.mCurrentStatusText;
		}
		StaticResources.AddTask(task);
		Message.showTaskQueueMsg("ȡղ", mContext);
	}

	public void viewBigImage()
	{
		Intent intent = new Intent(mContext, BigImageViewer.class);
		mContext.startActivity(intent);
	}

	public void replyComment()
	{
		Intent intent = new Intent(mContext, Comment.class);
		intent.putExtra("commentId", WeiboMain.mCurrentCommentId);
		intent.putExtra("statusId", WeiboMain.mCurrentComment.getStatus()
				.getId());

		intent.putExtra("taskType", Const.TASK_TYPE_REPLY_COMMENT);
		intent.putExtra("username", WeiboMain.mCurrentComment.getUser()
				.getName());
		intent.putExtra("commentText", WeiboMain.mCurrentCommentText);

		mContext.startActivity(intent);
	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{

		Intent intent = null;
		Task task = null;
		TaskListenerImpl taskListenerImpl = null;
		switch (item.getItemId())
		{
			case R.id.mnuComment:
				comment();
				break;
			case R.id.mnuRepost:
				repost();
				break;
			case R.id.mnuFavorite:
				favorite();
				break;
			case R.id.mnuDestroyFavorite:
				destroyFavorite();
				break;
			case R.id.mnuViewBigImage:
				viewBigImage();
				break;
			case R.id.mnuDeleteStatus:
				new AlertDialog.Builder(mContext).setTitle("ɾ΢")
						.setMessage("Ƿɾǰ΢")
						.setPositiveButton("ȷ", new OnClickListener()
						{

							@Override
							public void onClick(DialogInterface dialog,
									int which)
							{
								Task task = new Task();
								task.taskType = Const.TASK_TYPE_DELETE_STATUS;
								TaskListenerImpl taskListenerImpl = new TaskListenerImpl(
										mContext);
								task.taskListener = taskListenerImpl;
								task.alias = WeiboMain.mainAlias;
								task.statusId = WeiboMain.mCurrentStatusId;
								task.msg = WeiboMain.mCurrentStatusText;
								task.position = WeiboMain.mCurrentPosition;
								StaticResources.AddTask(task);
								Message.showTaskQueueMsg("ɾ΢", mContext);
							}
						}).setNegativeButton("ȡ", null).show();
				break;
			case R.id.mnuCreateFriendShip:
				User user = AndroidUtil.getMainTimelineOperationProcess(
						mContext).getUser(WeiboMain.mCurrentPosition);
				AndroidUtil.getMyMicroBlogs(mContext).get(WeiboMain.mainAlias)
						.createFriendshipAsync(String.valueOf(user.getId()));
				Message.showMsg(mContext, "ѹע<" + user.getName() + ">");
				break;
			case R.id.mnuReplyComment:
				replyComment();
				break;
			default:
				break;
		}
		return false;
	}

}
