package sina.weibo.process;

import java.io.File;

import sina.weibo.About;
import sina.weibo.AccountManager;
import sina.weibo.WeiboMain;
import sina.weibo.R;
import sina.weibo.Search;
import sina.weibo.Setting;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Values;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent; 
import android.view.Menu;
import android.view.MenuItem;
import android.view.MenuItem.OnMenuItemClickListener;

public class MainOptionsMenuProcess implements OnMenuItemClickListener
{
	private WeiboMain mHappyBlogAndroid;
	private Menu mMenu;

	public MainOptionsMenuProcess(WeiboMain happyBlogAndroid, Menu menu)
	{
		mHappyBlogAndroid = happyBlogAndroid;
		mMenu = menu;
		MenuItem miLogout = menu.findItem(R.id.mnuLogout);
		MenuItem miAbout = menu.findItem(R.id.mnuAbout);
		MenuItem miAccountManager = menu.findItem(R.id.mnuAccountManager);
		MenuItem miSearch = menu.findItem(R.id.mnuSearch);
		MenuItem miSetting = menu.findItem(R.id.mnuSetting);

		miLogout.setOnMenuItemClickListener(this);
		miAbout.setOnMenuItemClickListener(this);
		miAccountManager.setOnMenuItemClickListener(this);
		miSearch.setOnMenuItemClickListener(this);
		miSetting.setOnMenuItemClickListener(this);

	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{
		Intent intent = null;

		switch (item.getItemId())
		{
			case R.id.mnuLogout:
				new AlertDialog.Builder(mHappyBlogAndroid).setIcon(
						R.drawable.question).setTitle("Ƿע")
						.setPositiveButton("ȷ",
								new DialogInterface.OnClickListener()
								{
									public void onClick(DialogInterface dialog,
											int whichButton)
									{
										mHappyBlogAndroid.loadMainLayout = false;

										mHappyBlogAndroid
												.onCreateOptionsMenu(mHappyBlogAndroid.mOptionsMenu);
										mHappyBlogAndroid.loginProcess = null;
										mHappyBlogAndroid.mainAlias = null;
										mHappyBlogAndroid.happyBlogConfig
												.setValue(Values.MAIN_ALIAS, "");

										mHappyBlogAndroid.mMainOptionsMenuProcess = null;
										AndroidUtil
												.getMainTimelineOperationProcess(
														mHappyBlogAndroid)
												.clear();
										AndroidUtil
												.setMainTimelineOperationProcess(
														mHappyBlogAndroid, null);
										AndroidUtil
												.setHomeTimelineOperationProcess(
														mHappyBlogAndroid, null);
										try
										{
											new File(
													Values
															.getCacheFilename(
																	WeiboMain.mainAlias,
																	AndroidUtil
																			.getMainTimelineOperationProcess(
																					mHappyBlogAndroid)
																			.getDataType()))
													.delete();
										}
										catch (Exception e)
										{
											// TODO: handle exception
										}
										mHappyBlogAndroid.loadLoginLayout();
									}
								}).setNegativeButton("ȡ",
								new DialogInterface.OnClickListener()
								{
									public void onClick(DialogInterface dialog,
											int whichButton)
									{

									}
								}).show();

				break;
			case R.id.mnuAbout:
				intent = new Intent(mHappyBlogAndroid, About.class);
				mHappyBlogAndroid.startActivity(intent);
				break;
			case R.id.mnuAccountManager:
				intent = new Intent(mHappyBlogAndroid, AccountManager.class);
				mHappyBlogAndroid.startActivityForResult(intent,
						Values.REQUEST_CODE_ACCOUNT_MANAGER);
				break;
			case R.id.mnuSearch:
				intent = new Intent(mHappyBlogAndroid, Search.class);
				mHappyBlogAndroid.startActivity(intent);
				break;
			case R.id.mnuSetting:
				intent = new Intent(mHappyBlogAndroid, Setting.class);
				mHappyBlogAndroid.startActivity(intent);
				break;

		}
		return false;
	}

	public void setMenu(Menu menu)
	{
		mMenu = menu;
	}
}
