package sina.weibo.process;

import microblog.commons.Const;
import microblog.net.interfaces.TaskListener;
import microblog.thread.Task;
import sina.weibo.R;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.interfaces.HandlerRun;
import weibo4j.Comment;
import android.content.Context;
import android.util.Log;

public class TaskListenerImpl implements TaskListener
{
	private MyHandler myHandler = new MyHandler();
	private Message message;
	private Context mContext; 
	private int mId;

	public TaskListenerImpl(Context context)
	{
		message = new Message(context);
		mContext = context;

	}

	private NotificationParams getDefaultNotificationParams()
	{
		NotificationParams params = new NotificationParams();
		params.id = Values.UPDATE_TASK_ID;
		params.icon = R.drawable.update;
		params.contentTitle = "ֲ״̬Ϣ.";
		return params;
	}

	@Override
	public void onStartTask(final Task task)
	{

		myHandler.run(new HandlerRun()
		{

			@Override
			public void invoke()
			{
				try
				{

					String tickerText = "";
					if (Const.TASK_TYPE_STATUS.equals(task.taskType))
					{
						tickerText = "ڷ"
								+ Values.getNotificationValue(mContext,
										"sina") + "(" + task.alias
								+ ").";
					}
					else if (Const.TASK_TYPE_COMMENT.equals(task.taskType))
					{
						tickerText = "ڷ.";
					}
					else if (Const.TASK_TYPE_REPOST.equals(task.taskType))
					{
						tickerText = "ת΢.";
					}
					else if (Const.TASK_TYPE_FAVORITE.equals(task.taskType))
					{
						tickerText = "ղ΢.";
					}
					else if (Const.TASK_TYPE_DESTROY_FAVORITE.equals(task.taskType))
					{
						tickerText = "ȡղ.";
					}
					else if (Const.TASK_TYPE_DELETE_STATUS
							.equals(task.taskType))
					{
						tickerText = "ɾ΢.";
					}
					else if (Const.TASK_TYPE_REPLY_COMMENT
							.equals(task.taskType))
					{
						tickerText = "ڻظ.";
					}
					else if (Const.TASK_TYPE_SEND_DIRECT_MESSAGE
							.equals(task.taskType))
					{
						tickerText = "<" + task.nick + ">˽.";
					}

					mId = AndroidUtil.getSystemDBService(mContext) 
							.insertNotificationTask(task.msg, task.taskType);

					 AndroidUtil.getSystemDBService(mContext).insertNotification(mId,
							tickerText, Const.STATE_READY, "sina",
							task.alias);

					NotificationParams params = getDefaultNotificationParams();
					params.tickerText = tickerText;
					params.contentText = ""
							+  AndroidUtil.getSystemDBService(mContext) 
									.getNotificationCount() + "Ϣ.";

					NotificationProcess.addNotification(params);

				}
				catch (Exception e)
				{
					Log.d("taskprocess_start_error", String.valueOf(e));
				}

			}
		});

	}

	@Override
	public void onTaskFailed(final Task task)
	{

		myHandler.run(new HandlerRun()
		{

			@Override
			public void invoke()
			{
				try
				{

					String tickerText = "";
					if (Const.TASK_TYPE_STATUS.equals(task.taskType))
					{
						tickerText = ""
								+ Values.getNotificationValue(mContext,
										"sina") + "(" + task.alias
								+ ")ʧ.";
					}

					else if (Const.TASK_TYPE_COMMENT.equals(task.taskType))
					{
						tickerText = "ʧ.";
					}
					else if (Const.TASK_TYPE_REPOST.equals(task.taskType))
					{
						tickerText = "ת΢ʧ.";
					}
					else if (Const.TASK_TYPE_FAVORITE.equals(task.taskType))
					{
						tickerText = "ղ΢ʧ.";
					}
					else if (Const.TASK_TYPE_DESTROY_FAVORITE.equals(task.taskType))
					{
						tickerText = "ȡղʧ.";
					}
					else if (Const.TASK_TYPE_DELETE_STATUS
							.equals(task.taskType))
					{
						tickerText = "ɾ΢ʧ.";
					}
					else if (Const.TASK_TYPE_REPLY_COMMENT
							.equals(task.taskType))
					{
						tickerText = "ظʧ.";
					}
					else if (Const.TASK_TYPE_SEND_DIRECT_MESSAGE
							.equals(task.taskType))
					{
						tickerText = "<" + task.nick + ">˽ʧ.";
					}
					 AndroidUtil.getSystemDBService(mContext).insertNotification(mId,
							tickerText, Const.STATE_FAILED, "sina",
							task.alias);
					NotificationParams params = getDefaultNotificationParams();
					params.tickerText = tickerText;
					//params.deleteIntent = new intent = new Intent(Values.DELETE_NOTIFICATION_BROADCAST_ACTION);
					//notification.deleteIntent = PendingIntent.getBroadcast(mContext, 0,
					//		intent, PendingIntent.FLAG_UPDATE_CURRENT);
					params.contentText = ""
							+  AndroidUtil.getSystemDBService(mContext) 
									.getNotificationCount() + "Ϣ.";
					NotificationProcess.addNotification(params);

				}
				catch (Exception e)
				{
					Log.d("taskprocess_failed_error", e.getMessage());
				}

			}
		});

	}

	@Override
	public void onTaskSuccess(final Task task, weibo4j.Status status, Comment comment)
	{

		myHandler.run(new HandlerRun() 
		{

			@Override
			public void invoke()
			{
				try
				{
					String tickerText = "";
					if (Const.TASK_TYPE_STATUS.equals(task.taskType))
					{
						tickerText = "ɹ"
								+ Values.getNotificationValue(mContext,
										"sina") + "(" + task.alias
								+ ").";
					}

					else if (Const.TASK_TYPE_COMMENT.equals(task.taskType))
					{
						tickerText = "ɹ";
					}
					else if (Const.TASK_TYPE_REPOST.equals(task.taskType))
					{
						tickerText = "ɹת΢";
					}
					else if (Const.TASK_TYPE_FAVORITE.equals(task.taskType))
					{
						tickerText = "ɹղ΢.";
					}
					else if (Const.TASK_TYPE_DESTROY_FAVORITE.equals(task.taskType))
					{
						tickerText = "ɹȡղ.";
					}
					else if (Const.TASK_TYPE_DELETE_STATUS
							.equals(task.taskType))
					{
						tickerText = "ɹɾ΢.";
					}
					else if (Const.TASK_TYPE_REPLY_COMMENT
							.equals(task.taskType))
					{
						tickerText = "ɹظ.";

					}
					else if (Const.TASK_TYPE_SEND_DIRECT_MESSAGE
							.equals(task.taskType))
					{
						tickerText = "ɹ<" + task.nick + ">˽.";

					}
					 AndroidUtil.getSystemDBService(mContext) .insertNotification(mId,
							tickerText, Const.STATE_SUCCESS, "sina",
							task.alias);
					NotificationParams params = getDefaultNotificationParams();
					params.tickerText = tickerText;
					params.contentText = ""
							+  AndroidUtil.getSystemDBService(mContext) 
									.getNotificationCount() + "Ϣ.";

					NotificationProcess.addNotification(params);
					if (AndroidUtil.getMainTimelineOperationProcess(mContext) != null
							&& Const.TASK_TYPE_DELETE_STATUS
									.equals(task.taskType))
					{
						AndroidUtil.getMainTimelineOperationProcess(mContext)
								.setDeletedState(task.position, task.statusId);
					}

				}
				catch (Exception e)
				{
					Log.d("taskprocess_success_error", e.getMessage());
				}

			}
		});

	}

}
