package sina.weibo.process;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import microblog.MyMicroBlogAsync;
import microblog.MyUtil;
import microblog.commons.Const;
import microblog.commons.EncryptDecrypt;
import microblog.net.PullFile;
import sina.weibo.DirectMessageSessionViewer;
import sina.weibo.WeiboMain;
import sina.weibo.MicroBlogViewer;
import sina.weibo.R;
import sina.weibo.Search;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.interfaces.HandlerRun;
import sina.weibo.storage.Cache;
import weibo4j.Comment;
import weibo4j.DirectMessage;
import weibo4j.MBlog;
import weibo4j.Msg;
import weibo4j.Paging;
import weibo4j.RetweetDetails;
import weibo4j.Status;
import weibo4j.Weibo;
import weibo4j.WeiboResponse;
import weibo4j.User;
import weibo4j.UserInfo;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Handler;
import android.text.Html;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AbsListView.OnScrollListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

//  ʹstatic͵ı
public class TimelineOperationProcess extends OperationProcess implements
		OnScrollListener, OnItemLongClickListener, OnItemClickListener,
		OnClickListener
{
	private ListView mlvTimeline;

	public WeakReference<TimelineAdapter> mWeakReferenceAdapter;
	public List<WeiboResponse> mWeiboResponses = new ArrayList<WeiboResponse>();
	private Map<Integer, String> mDeletedStateMap = new HashMap<Integer, String>();
	private LinearLayout mLoadStatusesLayout;
	private TextView mtvWaitMsg;
	private PullFile mPullFile;
	private int mFirstVisibleItem = 0;

	private ProgressBar mpbRefresh;
	private ImageView mivRefresh;
	public TextView mtvCurrentPageNumber;

	private String mType; // statuscomment

	public int mDataType = Const.DATA_TYPE_HOME_TIMELINE;

	public int mListViewResourceId = R.id.lvHomeTimeline;

	// trueʾڻһҳһҳ΢
	public boolean mMoreStatus = false;
	public int mPage = 1;

	// //////////////public/////////////////////
	public static boolean mLoading = false;
	public boolean mRefresh = false;
	// ñΪtrueʾڳʼݣʱҪCacheжȡ
	public boolean mInitData = false;

	public void clear()
	{
		mWeiboResponses.clear();
		mDeletedStateMap.clear();
	}

	public int getDataType()
	{

		return mDataType;
	}

	public String getType()
	{
		return mType;
	}

	public void loadBitmap(String path, ImageView imageView)
	{
		try
		{
			((TimelineAdapter) mWeakReferenceAdapter.get()).loadBitmap(path,
					imageView, false);
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
	}

	public ListView getListView()
	{
		return mlvTimeline;
	}

	// ڻҪ˽ŵnickscreen name
	// ӵǰʾĻỰбnickûжԷnick򷵻ؿմ
	public String getNick()
	{
		for (int i = 0; i < AndroidUtil
				.getMainTimelineOperationProcess(mContext).mWeiboResponses
				.size(); i++)
		{
			Msg msg = (Msg) AndroidUtil
					.getMainTimelineOperationProcess(mContext).mWeiboResponses
					.get(i);
			if (!"".equals(msg.nick))
			{

				return msg.nick;
			}
		}
		return "";
	}

	// ͻĲ
	public String getDataTypeTitle()
	{
		switch (mDataType)
		{
			case Const.DATA_TYPE_HOME_TIMELINE:
				return "ҳ";
			case Const.DATA_TYPE_PUBLIC_TIMELINE:
				return "㿴";
			case Const.DATA_TYPE_USER_TIMELINE:
				return "ҵ΢";
			case Const.DATA_TYPE_MENTIONS:
				return "@ᵽҵ";
			case Const.DATA_TYPE_COMMENTS_TIMELINE:
				return "յ";
			case Const.DATA_TYPE_COMMENT_BY_ME:
				return "";
			case Const.DATA_TYPE_FAVORITES:
				return "ҵղ";
			case Const.DATA_TYPE_DIRECT_MESSAGE:
			case Const.DATA_TYPE_DIRECT_MESSAGE_SESSION:
			case Const.DATA_TYPE_DIRECT_MESSAGE_ME:
				return "˽";
			case Const.DATA_TYPE_COMMENT:
				return "鿴";

		}
		return "";
	}

	@Override
	public void onClick(View view)
	{
		if (AndroidUtil.getMainTimelineOperationProcess(mContext).mMoreStatus
				|| AndroidUtil.getMainTimelineOperationProcess(mContext).mLoading)
			return;
		switch (view.getId())
		{
			case R.id.ivPrevPage:
				if (AndroidUtil.getMainTimelineOperationProcess(mContext).mPage == 1)
				{
					Message.showMsg(mActivity, "Ѿǵ1ҳ.");
					return;
				}
				--AndroidUtil.getMainTimelineOperationProcess(mContext).mPage;
				break;

			case R.id.ivNextPage:
				if (AndroidUtil.getMainTimelineOperationProcess(mContext).mPage == 99)
				{
					Message.showMsg(mActivity, "ʾ99ҳ.");
					return;
				}

				++AndroidUtil.getMainTimelineOperationProcess(mContext).mPage;
				break;
		}

		MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
				mContext).get(WeiboMain.mainAlias);
		AndroidUtil.getMainTimelineOperationProcess(mContext).mLoading = true;
		AndroidUtil.getMainTimelineOperationProcess(mContext).mMoreStatus = true;
		Paging paging = new Paging(
				AndroidUtil.getMainTimelineOperationProcess(mContext).mPage);
		mActivity.setProgressBarIndeterminateVisibility(true);

		switch (AndroidUtil.getMainTimelineOperationProcess(mContext).mDataType)
		{
			case Const.DATA_TYPE_HOME_TIMELINE:

				myMicroBlogAsync.getHomeTimelineAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging);

				break;
			case Const.DATA_TYPE_USER_TIMELINE:

				myMicroBlogAsync.getUserTimelineAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging);
				break;
			case Const.DATA_TYPE_MENTIONS:

				myMicroBlogAsync.getMentionsAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging);
				break;
			case Const.DATA_TYPE_COMMENTS_TIMELINE:

				myMicroBlogAsync.getCommentsTimelineAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging);
				break;
			case Const.DATA_TYPE_COMMENT_BY_ME:

				myMicroBlogAsync.getCommentsByMeAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging);
				break;
			case Const.DATA_TYPE_FAVORITES:

				myMicroBlogAsync.getFavoritesAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging);
				break;
			case Const.DATA_TYPE_DIRECT_MESSAGE:

				myMicroBlogAsync.getDirectMessagesExtAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging);
			case Const.DATA_TYPE_DIRECT_MESSAGE_ME:

				myMicroBlogAsync.getDirectMessagesAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging);
				break;
			case Const.DATA_TYPE_DIRECT_MESSAGE_SESSION:
				myMicroBlogAsync.getDirectMessagesExtAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						paging, DirectMessageSessionViewer.mUserId);
				break;
			case Const.DATA_TYPE_COMMENT:

				myMicroBlogAsync.getCommentAsync(
						AndroidUtil.getMainTimelineOperationProcess(mContext),
						WeiboMain.mCurrentStatusId, paging);
				break;
			case Const.DATA_TYPE_SEARCH_MBLOG:
				try
				{
					paging.setCount(20);
					paging.setKeyword(Search.mKeyword);
					myMicroBlogAsync.searchMicroBlogAsync(
							Search.mSearchMBlogOperationProcess, paging);
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}

				break;
			case Const.DATA_TYPE_SEARCH_USER:
				try
				{
					myMicroBlogAsync.searchUserAsync(
							Search.mSearchUserOperationProcess, paging,
							Search.mKeyword);
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}
				break;
		}

	}

	public void loadStatuses()
	{

		if (WeiboMain.loadMainLayout == false)
			return;
		myHandler.run(new HandlerRun()
		{

			@Override
			public void invoke()
			{
				AndroidUtil.loadProfileImage(mActivity);
				mlvTimeline = (ListView) mActivity
						.findViewById(mListViewResourceId);
				WeiboMain.mtvName = (TextView) mActivity
						.findViewById(R.id.tvName);
				WeiboMain.mtvStatus = (TextView) mActivity
						.findViewById(R.id.tvStatus);
				mlvTimeline.setOnScrollListener(TimelineOperationProcess.this);
				mlvTimeline.setOnCreateContextMenuListener(mActivity);
				mlvTimeline
						.setOnItemLongClickListener(TimelineOperationProcess.this);
				mlvTimeline
						.setOnItemClickListener(TimelineOperationProcess.this);

				mlvTimeline.setAdapter(((TimelineAdapter) mWeakReferenceAdapter
						.get()));
				mlvTimeline.setSelection(mFirstVisibleItem);

				mLoadStatusesLayout.setVisibility(View.GONE);

				mlvTimeline.setVisibility(View.VISIBLE);

				mpbRefresh = (ProgressBar) mActivity
						.findViewById(R.id.pbRefresh);
				mivRefresh = (ImageView) mActivity.findViewById(R.id.ivRefresh);
				mMoreStatus = false;
				if (mDataType != Const.DATA_TYPE_PUBLIC_TIMELINE)
				{
					ImageView ivPrevPage = (ImageView) mActivity
							.findViewById(R.id.ivPrevPage);
					ImageView ivNextPage = (ImageView) mActivity
							.findViewById(R.id.ivNextPage);
					if (ivPrevPage != null)
					{
						ivPrevPage
								.setOnClickListener(TimelineOperationProcess.this);
						ivNextPage
								.setOnClickListener(TimelineOperationProcess.this);
					}
				}
				AndroidUtil.getMainTimelineOperationProcess(mContext).mtvCurrentPageNumber = (TextView) mActivity
						.findViewById(R.id.tvCurrentPageNumber);
				if (AndroidUtil.getMainTimelineOperationProcess(mContext).mtvCurrentPageNumber != null)
				{
					AndroidUtil.getMainTimelineOperationProcess(mContext).mtvCurrentPageNumber.setText(String.valueOf(AndroidUtil
							.getMainTimelineOperationProcess(mContext).mPage));
				}

				WeiboMain.loadMainLayout = true;
				setActivityTitle();
				hideChangePage();

			}
		});

	}

	@Override
	public void onScroll(AbsListView view, int firstVisibleItem,
			int visibleItemCount, int totalItemCount)
	{
		if (view.getAdapter() != null)
			mFirstVisibleItem = firstVisibleItem;
	}

	public void setDeletedState(int position, String statusId)
	{
		mDeletedStateMap.put(position, statusId);
		mWeakReferenceAdapter.get().notifyDataSetChanged();

	}

	public boolean isDeleted(int position, String statusId)
	{
		String s = mDeletedStateMap.get(position);
		if (s == null)
			return false;
		return statusId.equals(s);
	}

	public boolean isDeleted()
	{
		String s = mDeletedStateMap.get(WeiboMain.mCurrentPosition);
		if (s == null)
			return false;
		return WeiboMain.mCurrentStatusId.equals(s);

	}

	public boolean isMyStatus()
	{
		if (Const.TIMELINE_TYPE_STATUS.equals(mType))
		{
			Status status = (Status) mWeiboResponses
					.get(WeiboMain.mCurrentPosition);

			return (status.getUser().getName()
					.equals(WeiboMain.mCurrentUser.getName()));
		}
		else
		{
			return false;
		}
	}

	public String getMinId()
	{
		if (mWeiboResponses.size() > 0)
		{
			WeiboResponse WeiboResponse = mWeiboResponses.get(mWeiboResponses
					.size() - 1);

			return WeiboResponse.getId();
		}
		else
		{
			return null;
		}
	}

	public boolean isMyComment()
	{
		if (Const.TIMELINE_TYPE_COMMENT.equals(mType))
		{
			Comment comment = (Comment) mWeiboResponses
					.get(WeiboMain.mCurrentPosition);

			return (comment.getUser().getName()
					.equals(WeiboMain.mCurrentUser.getName()));
		}
		else
		{
			return false;
		}

	}

	public boolean isDirectMessage()
	{
		if (Const.TIMELINE_TYPE_DIRECT_MESSAGE.equals(mType))
		{

			return true;
		}
		else
		{
			return false;
		}

	}

	public String getId(int position)
	{
		if (Const.TIMELINE_TYPE_COMMENT.equals(mType))
		{
			return ((Comment) mWeiboResponses.get(position)).getId();
		}
		else if (Const.TIMELINE_TYPE_STATUS.equals(mType))
		{
			return ((Status) mWeiboResponses.get(position)).getId();
		}
		return null;

	}

	public User getUser(int position)
	{
		if (position == mWeiboResponses.size())
			return null;
		if (Const.TIMELINE_TYPE_COMMENT.equals(mType))
		{
			return ((Comment) mWeiboResponses.get(position)).getUser();
		}
		else if (Const.TIMELINE_TYPE_STATUS.equals(mType)
				|| Const.TIMELINE_TYPE_SEARCH_MBLOG.equals(mType))
		{
			return ((Status) mWeiboResponses.get(position)).getUser();
		}
		else if (Const.TIMELINE_TYPE_SEARCH_USER.equals(mType))
		{
			return (User) mWeiboResponses.get(position);
		}
		return null;

	}

	public String getText(int position)
	{
		if (Const.TIMELINE_TYPE_COMMENT.equals(mType))
		{
			return ((Comment) mWeiboResponses.get(position)).getText();
		}
		else if (Const.TIMELINE_TYPE_STATUS.equals(mType))
		{
			return ((Status) mWeiboResponses.get(position)).getText();
		}

		return null;

	}

	@Override
	public void onItemClick(AdapterView<?> parent, View view, int position,
			long id)
	{
		if (position == mWeiboResponses.size())
		{

			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mContext).get(WeiboMain.mainAlias);
			AndroidUtil.getMainTimelineOperationProcess(mContext).mLoading = true;
			AndroidUtil.getMainTimelineOperationProcess(mContext).mMoreStatus = true;
			Paging paging = new Paging();
			String minId = getMinId();
			if (getDataType() == Const.DATA_TYPE_SEARCH_USER)
			{
				mPage++;
				paging.setPage(mPage);
			}
			else
			{
				if (minId != null)
				{
					Long minId_Long = Long.parseLong(minId);
					minId_Long--;
					paging.setMaxId(minId_Long);

				}
			}

			View more = view.findViewById(R.id.tvMore);
			View moreProgress = view.findViewById(R.id.llMoreProgress);

			more.setVisibility(View.GONE);
			moreProgress.setVisibility(View.VISIBLE);

			switch (AndroidUtil.getMainTimelineOperationProcess(mContext).mDataType)
			{
				case Const.DATA_TYPE_HOME_TIMELINE:

					myMicroBlogAsync.getHomeTimelineAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging);

					break;
				case Const.DATA_TYPE_USER_TIMELINE:

					myMicroBlogAsync.getUserTimelineAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging);
					break;
				case Const.DATA_TYPE_MENTIONS:

					myMicroBlogAsync.getMentionsAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging);
					break;
				case Const.DATA_TYPE_COMMENTS_TIMELINE:

					myMicroBlogAsync.getCommentsTimelineAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging);

					break;
				case Const.DATA_TYPE_COMMENT_BY_ME:

					myMicroBlogAsync.getCommentsByMeAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging);
					break;
				case Const.DATA_TYPE_FAVORITES:

					myMicroBlogAsync.getFavoritesAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging);

					break;
				case Const.DATA_TYPE_DIRECT_MESSAGE:

					myMicroBlogAsync.getDirectMessagesExtAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging);
				case Const.DATA_TYPE_DIRECT_MESSAGE_ME:

					myMicroBlogAsync.getDirectMessagesAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging);
					break;
				case Const.DATA_TYPE_DIRECT_MESSAGE_SESSION:
					myMicroBlogAsync.getDirectMessagesExtAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext), paging,
							DirectMessageSessionViewer.mUserId);
					break;
				case Const.DATA_TYPE_COMMENT:

					myMicroBlogAsync.getCommentAsync(AndroidUtil
							.getMainTimelineOperationProcess(mContext),
							WeiboMain.mCurrentStatusId, paging);
					break;
				case Const.DATA_TYPE_SEARCH_MBLOG:
					try
					{
						paging.setCount(20);
						paging.setKeyword(Search.mKeyword);
						myMicroBlogAsync.searchMicroBlogAsync(
								Search.mSearchMBlogOperationProcess, paging);
					}
					catch (Exception e)
					{
						// TODO: handle exception
					}

					break;
				case Const.DATA_TYPE_SEARCH_USER:
					try
					{
						paging.setKeyword(Search.mKeyword);
						myMicroBlogAsync.searchUsersAsync(AndroidUtil
								.getMainTimelineOperationProcess(mContext),
								paging);

					}
					catch (Exception e)
					{
						// TODO: handle exception
					}
					break;
			}

		}
		else
		{

			String type = AndroidUtil.getMainTimelineOperationProcess(mContext)
					.getType();
			if (Const.TIMELINE_TYPE_STATUS.equals(type)
					&& position == mWeiboResponses.size())
			{
				mMoreStatus = true;

				LinearLayout linearLayout = (LinearLayout) view
						.findViewById(R.id.llMoreProgress);
				TextView tvMore = (TextView) view.findViewById(R.id.tvMore);
				tvMore.setText("");
				linearLayout.setVisibility(View.VISIBLE);
				String minStatusId = ((Status) mWeiboResponses
						.get(mWeiboResponses.size() - 1)).getId();
				AndroidUtil.getMainTimelineOperationProcess(mContext).mActivity
						.setTitle(minStatusId);
				WeiboMain happyBlogAndroid = (WeiboMain) mActivity;
				MyMicroBlogAsync myMicroBlogAsync = AndroidUtil
						.getMyMicroBlogs(mContext).get(
								happyBlogAndroid.mainAlias);
				Paging paging = new Paging(++mPage);
				// paging.setMaxId(Long.parseLong(minStatusId) - 1);
				myMicroBlogAsync.getHomeTimelineAsync(this, paging);
			}
			else if (Const.TIMELINE_TYPE_STATUS.equals(type))
			{
				onItemLongClick(parent, view, position, id);
				Intent intent = new Intent(mContext, MicroBlogViewer.class);
				mContext.startActivity(intent);
			}
			else if (Const.TIMELINE_TYPE_DIRECT_MESSAGE.equals(type))
			{

				String userId = ((Msg) mWeiboResponses.get(position)).userId;
				Intent intent = new Intent(mActivity,
						DirectMessageSessionViewer.class);
				intent.putExtra("userId", userId);
				mContext.startActivity(intent);
			}
			else if (Const.TIMELINE_TYPE_SEARCH_MBLOG.equals(type))
			{
				onItemLongClick(parent, view, position, id);
				Intent intent = new Intent(mContext, MicroBlogViewer.class);
				mContext.startActivity(intent);
			}
		}
	}

	@Override
	public boolean onItemLongClick(AdapterView<?> parent, View view,
			int position, long id)
	{
		try
		{
			if (position == mWeiboResponses.size())
			{
				mActivity.unregisterForContextMenu(mlvTimeline);
			}
			else
			{
				if (mType == Const.TIMELINE_TYPE_DIRECT_MESSAGE_ME)
				{
					mActivity.unregisterForContextMenu(mlvTimeline);

				}
				else
				{

					mActivity.registerForContextMenu(mlvTimeline);
				}
				WeiboMain.mCurrentPosition = position;

				Status status = null;
				Comment comment = null;
				User user = null;
				if (Const.TIMELINE_TYPE_STATUS.equals(mType)
						|| Const.TIMELINE_TYPE_SEARCH_MBLOG.equals(mType))
				{

					WeiboMain.mCurrentStatus = (Status) mWeiboResponses
							.get(position);

					status = (Status) mWeiboResponses.get(position);
					WeiboMain.mCurrentStatusId = status.getId();
					user = status.getUser();
					WeiboMain.mCurrentStatusText = status.getText();
					RetweetDetails retweetDetails = status.getRetweetDetails();
					if (retweetDetails != null)
					{
						String retweetDetailProfileImagePath = ((TimelineAdapter) mWeakReferenceAdapter
								.get()).getProfileImagePath(retweetDetails
								.getRetweetingUser());
						WeiboMain.mCurrentRetweetDetailProfileImagePath = retweetDetailProfileImagePath;
						WeiboMain.mhasRetweeting = true;
						WeiboMain.mCurrentRetweetingId = status
								.getRetweetDetails().getRetweetId();

						WeiboMain.mCurrentRetweetingUserName = status
								.getRetweetDetails().getRetweetingUser()
								.getName();

					}
					else
					{
						WeiboMain.mCurrentRetweetDetailProfileImagePath = null;
						WeiboMain.mhasRetweeting = false;
					}
				}
				else if (Const.TIMELINE_TYPE_COMMENT.equals(mType))
				{

					WeiboMain.mCurrentComment = (Comment) mWeiboResponses
							.get(position);
					comment = (Comment) mWeiboResponses.get(position);
					WeiboMain.mCurrentCommentId = comment.getId();
					user = comment.getUser();
					WeiboMain.mCurrentCommentText = comment.getText();
				}
				else if (false/* Const.TIMELINE_TYPE_SEARCH_MBLOG.equals(mType) */)
				{
					WeiboMain.mCurrentMBlog = (MBlog) mWeiboResponses
							.get(position);

				}
				if (user != null)
				{
					String profileImagePath = ((TimelineAdapter) mWeakReferenceAdapter
							.get()).getProfileImagePath(user);

					WeiboMain.mCurrentProfileImagePath = profileImagePath;

					WeiboMain.mCurrentUserName = user.getName();
				}
			}
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}

		return false;
	}

	@Override
	public void onScrollStateChanged(AbsListView view, int scrollState)
	{
		// TODO Auto-generated method stub

	}

	private void init(Context context, String type, int dataType,
			int listviewResourceId)
	{
		mListViewResourceId = listviewResourceId;
		init(context, type, dataType);
	}

	private void init(Context context, String type, int dataType)
	{
		mWeakReferenceAdapter = new WeakReference<TimelineAdapter>(
				new TimelineAdapter(this, context));

		// mTimelineAdapter = new TimelineAdapter(this, context);

		mlvTimeline = (ListView) mActivity.findViewById(mListViewResourceId);

		if (Const.TIMELINE_TYPE_STATUS.equals(type)
				|| Const.TIMELINE_TYPE_COMMENT.equals(type)
				|| Const.TIMELINE_TYPE_DIRECT_MESSAGE_ME.equals(type))
		{
			mlvTimeline.setOnCreateContextMenuListener(mActivity);
			mlvTimeline.setOnScrollListener(this);
			mlvTimeline.setOnItemLongClickListener(this);
			mlvTimeline.setOnItemClickListener(this);
		}
		if (Const.TIMELINE_TYPE_SEARCH_MBLOG.equals(type))
		{
			mlvTimeline.setOnItemLongClickListener(this);

		}
		mlvTimeline.setAdapter(mWeakReferenceAdapter.get());

		mLoadStatusesLayout = (LinearLayout) mActivity
				.findViewById(R.id.loading);
		mtvWaitMsg = (TextView) mActivity.findViewById(R.id.tvWaitMsg);

		if (mtvWaitMsg != null)
			mtvWaitMsg.setText("ڻݣԺ...");

		mType = type;
		mDataType = dataType;

		mpbRefresh = (ProgressBar) mActivity.findViewById(R.id.pbRefresh);
		mivRefresh = (ImageView) mActivity.findViewById(R.id.ivRefresh);
		if (mDataType != Const.DATA_TYPE_PUBLIC_TIMELINE)
		{

			ImageView ivPrevPage = (ImageView) mActivity
					.findViewById(R.id.ivPrevPage);
			ImageView ivNextPage = (ImageView) mActivity
					.findViewById(R.id.ivNextPage);
			mtvCurrentPageNumber = (TextView) mActivity
					.findViewById(R.id.tvCurrentPageNumber);
			if (ivPrevPage != null)
			{
				ivPrevPage.setOnClickListener(this);
				ivNextPage.setOnClickListener(this);
			}
		}

	}

	public TimelineOperationProcess(WeiboMain happyBlogAndroid)
	{
		this(happyBlogAndroid, Const.TIMELINE_TYPE_STATUS);

	}

	public TimelineOperationProcess(WeiboMain happyBlogAndroid,
			int listviewResourceId)
	{
		this(happyBlogAndroid, Const.TIMELINE_TYPE_STATUS);
	}

	public TimelineOperationProcess(WeiboMain happyBlogAndroid,
			String type)
	{
		super(happyBlogAndroid);

		init(happyBlogAndroid, type, Const.DATA_TYPE_HOME_TIMELINE);
	}

	public TimelineOperationProcess(Context context, String type, int dataType,
			int listviewResourceId)

	{
		super(context);
		init(context, type, dataType, listviewResourceId);
	}

	public TimelineOperationProcess(Context context, String type, int dataType)
	{
		super(context);
		init(context, type, dataType);

	}

	private String getCacheName()
	{

		return WeiboMain.mainAlias + String.valueOf(mDataType);
	}

	@Override
	public void onTimelineSuccess(String msg,
			final List<WeiboResponse> WeiboResponses)
	{

		super.onTimelineSuccess(msg, WeiboResponses);

		if (WeiboResponses != null)
		{

			try
			{
				if (WeiboMain.loadMainLayout == false)
					return;
				if (false)/*
						 * !((Const.TIMELINE_TYPE_SEARCH_USER.equals(mType) ||
						 * Const.TIMELINE_TYPE_SEARCH_MBLOG .equals(mType)) &&
						 * Search.mOldKeyword .equals(Search.mKeyword)))
						 */
				{
					clear();

					mWeiboResponses.addAll(WeiboResponses);
				}
				else
				{
					if (WeiboResponses.size() > 0)
					{
						long id1 = 0;
						long id2 = 0;

						id1 = Long.parseLong((WeiboResponses.get(0)).getId());
						if (mWeiboResponses.size() == 0)
						{
							id2 = -1;
						}
						else
						{
							id2 = Long.parseLong((mWeiboResponses.get(0))
									.getId());
						}
						if (id1 > id2)
						{
							mWeiboResponses.clear();
							mFirstVisibleItem = 0;
						}
						else if (mDataType == Const.DATA_TYPE_SEARCH_USER
								|| mDataType == Const.DATA_TYPE_SEARCH_MBLOG)
						{
							Log.d("clear", "clear");
							mWeiboResponses.clear();
						}

						mWeiboResponses.addAll(WeiboResponses);

					}
				}
				WeiboMain.happyBlogConfig.setValue(Values.DATA_TYPE,
						mDataType);

				if (Const.TIMELINE_TYPE_STATUS.equals(mType) && !mMoreStatus)
					Cache.save(getCacheName(), WeiboResponses);

				android.os.Message message = new android.os.Message();
				message.what = 4;
				message.obj = msg;
				mHandler.sendMessage(message);
			}
			catch (Exception e)
			{
				Log.e("exception_onTimelineSuccess", e.getMessage());
			}

		}

	}

	public static class TimelineAdapter extends BaseAdapter
	{
		private LayoutInflater mLayoutInflater;

		// private Map<Integer, View> mViews = new HashMap<Integer, View>();
		private View mMore;
		private TimelineOperationProcess mTimelineOperationProcess;

		public TimelineAdapter(
				TimelineOperationProcess timelineOperationProcess,
				Context context)
		{
			mTimelineOperationProcess = timelineOperationProcess;
			mLayoutInflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		}

		@Override
		public int getCount()
		{
			int increment = 1;
			if (mTimelineOperationProcess.getDataType() == Const.DATA_TYPE_PUBLIC_TIMELINE
					|| mTimelineOperationProcess.getDataType() == Const.DATA_TYPE_COMMENTS_TIMELINE
					|| mTimelineOperationProcess.getDataType() == Const.DATA_TYPE_COMMENT_BY_ME
					|| mTimelineOperationProcess.getDataType() == Const.DATA_TYPE_FAVORITES)
				increment = 0;
			if (mTimelineOperationProcess.mWeiboResponses.size() > 0)
				return mTimelineOperationProcess.mWeiboResponses.size()
						+ increment;
			else
				return 0;
		}

		@Override
		public Object getItem(int position)
		{

			return mTimelineOperationProcess.mWeiboResponses.get(position);
		}

		public View getMoreView()
		{
			return mMore;
		}

		public String getId(int position)
		{

			if (Const.TIMELINE_TYPE_STATUS
					.equals(mTimelineOperationProcess.mType))
			{
				return ((Status) mTimelineOperationProcess.mWeiboResponses
						.get(position)).getId();
			}
			else if (Const.TIMELINE_TYPE_COMMENT
					.equals(mTimelineOperationProcess.mType))
			{
				return ((Comment) mTimelineOperationProcess.mWeiboResponses
						.get(position)).getId();
			}
			return null;
		}

		@Override
		public long getItemId(int position)
		{

			return 0;
		}

		public Bitmap getProfileImageBitmap(String path, InputStream is)
		{
			Bitmap bitmap = null;
			try
			{
				bitmap = Cache.restoreBitmap(path);
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
			if (bitmap == null)
			{
				try
				{
					// Ĵ൱Cache.save(...)
					String filename = Values.getBitmapCachePath()
							+ EncryptDecrypt.encrypt(path);
					FileOutputStream fis = new FileOutputStream(filename);
					byte[] buffer = new byte[8192];
					int count = 0;

					while ((count = is.read(buffer)) >= 0)
					{
						fis.write(buffer, 0, count);
					}
					fis.close();

					bitmap = Values.getFitBitmap(filename);

				}
				catch (Exception e)
				{
					Log.e("exception_TimelineOperationProcess_getProfileImageBitmap",
							String.valueOf(e));
				}
				try
				{
					Cache.save(path, bitmap);
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}

			}

			return bitmap;
		}

		public Bitmap getProfileImageBitmap(String path)
		{
			Bitmap bitmap = null;
			try
			{
				bitmap = Cache.restoreBitmap(path);
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}

			return bitmap;
		}

		public void setDeletedState(int position, String id)
		{
			if (!id.equals(getId(position)))
				return;
			/*
			 * View view = mViews.get(position); ImageView ivDeleted =
			 * (ImageView) view.findViewById(R.id.ivDeleted); TextView tvDeleted
			 * = (TextView) view.findViewById(R.id.tvDeleted);
			 * ivDeleted.setVisibility(View.VISIBLE);
			 * tvDeleted.setVisibility(View.VISIBLE);
			 */
		}

		public void loadBitmap(String path, ImageView imageView, boolean cache)
		{
			Bitmap bitmap = null;
			try
			{
				if (cache)
					bitmap = Cache.restoreBitmap(path);

			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
			if (bitmap != null)
			{
				imageView.setImageBitmap(bitmap);

			}
			else
			{
				mTimelineOperationProcess.mPullFile = new PullFile();
				mTimelineOperationProcess.mPullFile
						.setOnPullListener(new PullProfileImageProcess(this));
				mTimelineOperationProcess.mPullFile.pull(path, imageView);

			}
		}

		public void loadBitmap(String path, ImageView imageView)
		{
			loadBitmap(path, imageView, true);
		}

		public boolean isDeleted(int position, String id)
		{
			try
			{

				return false;
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
			return false;

		}

		private String getProfileImagePath(User user)
		{
			return "http://" + user.getProfileImageURL().getHost()
					+ user.getProfileImageURL().getPath();
		}

		private int getProfileImageKey(User user)
		{
			int imageKey = getProfileImagePath(user).hashCode();

			return imageKey;

		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent)
		{

			Date createdAt = null;

			try
			{
				if (convertView == null)
				{
					while (true)
					{
						try
						{
							if (Const.TIMELINE_TYPE_STATUS
									.equals(mTimelineOperationProcess.mType)
									|| Const.TIMELINE_TYPE_SEARCH_MBLOG
											.equals(mTimelineOperationProcess.mType))
							{
								convertView = mLayoutInflater.inflate(
										R.layout.microblog_content_item, null);
								TextView tvMore = (TextView) convertView
										.findViewById(R.id.tvMore);
								TextView tvWaitMsg = (TextView) convertView
										.findViewById(R.id.tvWaitMsg);
								tvMore.setText("ø΢");
								tvWaitMsg.setText("ڻø΢...");

							}
							else if (Const.TIMELINE_TYPE_COMMENT
									.equals(mTimelineOperationProcess.mType))
							{
								convertView = mLayoutInflater.inflate(
										R.layout.comment_content_item, null);
								TextView tvMore = (TextView) convertView
										.findViewById(R.id.tvMore);
								TextView tvWaitMsg = (TextView) convertView
										.findViewById(R.id.tvWaitMsg);
								tvMore.setText("ø");
								tvWaitMsg.setText("ڻø...");
							}
							else if (Const.TIMELINE_TYPE_DIRECT_MESSAGE
									.equals(mTimelineOperationProcess.mType)
									|| Const.TIMELINE_TYPE_DIRECT_MESSAGE_ME
											.equals(mTimelineOperationProcess.mType))
							{
								convertView = mLayoutInflater.inflate(
										R.layout.direct_message_content_item,
										null);
								TextView tvMore = (TextView) convertView
										.findViewById(R.id.tvMore);
								TextView tvWaitMsg = (TextView) convertView
										.findViewById(R.id.tvWaitMsg);
								tvMore.setText("ø˽");
								tvWaitMsg.setText("ڻø˽...");

							}
							else if (Const.TIMELINE_TYPE_DIRECT_MESSAGE_SESSION
									.equals(mTimelineOperationProcess.mType))
							{
								convertView = mLayoutInflater
										.inflate(
												R.layout.direct_message_session_content_item,
												null);
								TextView tvMore = (TextView) convertView
										.findViewById(R.id.tvMore);
								TextView tvWaitMsg = (TextView) convertView
										.findViewById(R.id.tvWaitMsg);
								tvMore.setText("ø˽");
								tvWaitMsg.setText("ڻø˽...");

							}
							else if (Const.TIMELINE_TYPE_SEARCH_USER
									.equals(mTimelineOperationProcess.mType))
							{
								convertView = mLayoutInflater.inflate(
										R.layout.userinfo_content_item, null);
								TextView tvMore = (TextView) convertView
										.findViewById(R.id.tvMore);
								TextView tvWaitMsg = (TextView) convertView
										.findViewById(R.id.tvWaitMsg);
								tvMore.setText("øû");
								tvWaitMsg.setText("ڻøû...");

							}
							break;
						}
						catch (Exception e)
						{

						}
					}
				} // if(convertView == null)
				View more = convertView.findViewById(R.id.flMore);
				View microblogContent = convertView
						.findViewById(R.id.llContent);

				if (position == mTimelineOperationProcess.mWeiboResponses
						.size())
				{

					more.setVisibility(View.VISIBLE);
					microblogContent.setVisibility(View.GONE);
				}
				else
				{

					more.setVisibility(View.GONE);
					microblogContent.setVisibility(View.VISIBLE);
					Status status = null;
					MBlog mBlog = null;
					Comment comment = null;
					DirectMessage directMessage = null;

					Msg msg = null;
					UserInfo userInfo = null;
					User user = null;
					ImageView ivProfileImage = (ImageView) convertView
							.findViewById(R.id.ivProfileImage);

					ivProfileImage
							.setImageResource(R.drawable.default_profile_image);
					TextView tvText = (TextView) convertView
							.findViewById(R.id.tvText);
					if (tvText != null)
						tvText.setLinkTextColor(WeiboMain.happyBlogConfig
								.getInt("link_color", Color.BLUE));
					TextView tvName = (TextView) convertView
							.findViewById(R.id.tvName);
					if (tvName != null)
					{
						int nameColor = WeiboMain.happyBlogConfig
								.getInt("name_color", Color.RED);

						tvName.setTextColor(nameColor);
					}

					TextView tvSource = (TextView) convertView
							.findViewById(R.id.tvSource);

					ImageView ivVerified = (ImageView) convertView
							.findViewById(R.id.ivVerified);
					ivVerified.setVisibility(View.GONE);
					//TextView tvFriendNum = (TextView) convertView
					//		.findViewById(R.id.tvFriendNum);
					TextView tvFollowerCount = (TextView) convertView
							.findViewById(R.id.tvFollowerCount);
					TextView tvFriendCount = (TextView) convertView
							.findViewById(R.id.tvFriendCount);
					TextView tvStatusCount = (TextView) convertView
							.findViewById(R.id.tvStatusCount);
					String text = "";
					String source = "";
					if (Const.TIMELINE_TYPE_STATUS
							.equals(mTimelineOperationProcess.mType)
							|| Const.TIMELINE_TYPE_SEARCH_MBLOG
									.equals(mTimelineOperationProcess.mType))
					{
						status = (Status) mTimelineOperationProcess.mWeiboResponses
								.get(position);
						user = status.getUser();
						TextView tvRetweetDetailText = (TextView) convertView
								.findViewById(R.id.tvRetweetDetailText);
						ImageView ivtvRetweetDetailProfileImage = (ImageView) convertView
								.findViewById(R.id.ivRetweetDetailProfileImage);
						ImageView ivPicture = (ImageView) convertView
								.findViewById(R.id.ivPicture);
						ImageView ivStatusImage = (ImageView) convertView
								.findViewById(R.id.ivStatusImage);
						ImageView ivStatusImage1 = (ImageView) convertView
								.findViewById(R.id.ivStatusImage1);
						ivStatusImage.setVisibility(View.GONE);
						ivStatusImage1.setVisibility(View.GONE);
						ivStatusImage.setImageBitmap(null);
						ivStatusImage1.setImageBitmap(null);
						ivProfileImage
								.setImageResource(R.drawable.default_profile_image);
						ImageView ivDeleted = (ImageView) convertView
								.findViewById(R.id.ivDeleted);
						TextView tvDeleted = (TextView) convertView
								.findViewById(R.id.tvDeleted);
						if (isDeleted(position, status.getId()))
						{
							ivDeleted.setVisibility(View.VISIBLE);
							tvDeleted.setVisibility(View.VISIBLE);
						}
						else
						{
							ivDeleted.setVisibility(View.GONE);
							tvDeleted.setVisibility(View.GONE);

						}

						ivtvRetweetDetailProfileImage
								.setImageResource(R.drawable.default_profile_image);
						LinearLayout linearLayout3 = (LinearLayout) convertView
								.findViewById(R.id.linearlayout3);
						text = status.getText();
						source = status.getSource();
						if (!"".equals(status.getBmiddlePic()))
							ivPicture.setVisibility(View.VISIBLE);
						else
							ivPicture.setVisibility(View.GONE);

						RetweetDetails retweetDetails = status
								.getRetweetDetails();

						if (retweetDetails != null)
						{
							linearLayout3.setVisibility(View.VISIBLE);
							tvRetweetDetailText.setText(Html
									.fromHtml(AndroidUtil.atBlue("@"
											+ retweetDetails
													.getRetweetingUser()
													.getName() + ":"
											+ retweetDetails.getText())));

							String retweetDetailProfileImagePath = getProfileImagePath(retweetDetails
									.getRetweetingUser());

							loadBitmap(retweetDetailProfileImagePath,
									ivtvRetweetDetailProfileImage);

						}
						else
						{
							linearLayout3.setVisibility(View.GONE);
						}
						ivStatusImage.setVisibility(View.VISIBLE);
						ivStatusImage1.setVisibility(View.VISIBLE);

						if (status.getThumbnailPic() != null)
						{
							if (retweetDetails != null)
							{
								loadBitmap(status.getThumbnailPic(),
										ivStatusImage);

								ivStatusImage1.setVisibility(View.GONE);
							}
							else
							{
								loadBitmap(status.getThumbnailPic(),
										ivStatusImage1);

								ivStatusImage.setVisibility(View.GONE);

							}
						}
						else
						{
							ivStatusImage.setVisibility(View.GONE);
							ivStatusImage1.setVisibility(View.GONE);
						}

						createdAt = status.getCreatedAt();

					}

					else if (Const.TIMELINE_TYPE_COMMENT
							.equals(mTimelineOperationProcess.mType))
					{
						comment = (Comment) mTimelineOperationProcess.mWeiboResponses
								.get(position);
						user = comment.getUser();
						source = comment.getSource();
						createdAt = comment.getCreatedAt();
						text = comment.getText();
					}
					else if (Const.TIMELINE_TYPE_DIRECT_MESSAGE
							.equals(mTimelineOperationProcess.mType)
							|| Const.TIMELINE_TYPE_DIRECT_MESSAGE_SESSION
									.equals(mTimelineOperationProcess.mType))
					{
						msg = (Msg) mTimelineOperationProcess.mWeiboResponses
								.get(position);
						text = msg.content;
						if (msg.type == 0)
						{
							if (msg.num > 0)
							{

								tvName.setText(Html.fromHtml(msg.nick
										+ " "
										+ AndroidUtil
												.setTextColor("To", "blue")
										+ " "
										+ AndroidUtil.setTextColor(" ("
												+ msg.num + ")", "blue")));
							}
							else
							{
								tvName.setText(msg.nick);

							}
						}
						else if (msg.type == 1)
						{
							if (msg.num > 0)
							{
								tvName.setText(Html.fromHtml("  "
										+ AndroidUtil
												.setTextColor("To", "blue")
										+ " "
										+ msg.nick
										+ AndroidUtil.setTextColor(" ("
												+ msg.num + ")", "blue")));
							}
							else
							{
								tvName.setText(" ");
							}

						}
						createdAt = msg.time;
					}
					else if (Const.TIMELINE_TYPE_DIRECT_MESSAGE_ME
							.equals(mTimelineOperationProcess.mType))
					{
						directMessage = (DirectMessage) mTimelineOperationProcess.mWeiboResponses
								.get(position);
						text = directMessage.getText();
						tvSource.setVisibility(View.GONE);
						if (!directMessage
								.getSender()
								.getName()
								.equals(WeiboMain.mCurrentUser.getName()))
						{

							tvName.setText(Html.fromHtml(directMessage
									.getSender().getName()
									+ " "
									+ AndroidUtil.setTextColor("To", "blue")
									+ " "));
						}
						else
						{
							tvName.setText(Html.fromHtml("   "
									+ AndroidUtil.setTextColor("To", "blue")
									+ directMessage.getRecipient().getName()));
						}

						createdAt = directMessage.getCreatedAt();
					}
					else if (Const.TIMELINE_TYPE_SEARCH_USER
							.equals(mTimelineOperationProcess.mType))
					{
						user = (User) mTimelineOperationProcess.mWeiboResponses
								.get(position);

						int friendCount = user.getFriendsCount();
						int followerCount = user.getFollowersCount();
						tvName.setText(user.getName());

						tvFollowerCount.setText("˿\n"
								+ user.getFollowersCount());
						tvFriendCount.setText("ע\n" + user.getFriendsCount());
						tvStatusCount.setText("΢\n" + user.getStatusesCount());

					}
					if (tvText != null)
					{
						if (Const.TIMELINE_TYPE_SEARCH_MBLOG
								.equals(mTimelineOperationProcess.mType))
						{
							tvText.setText(Html.fromHtml(AndroidUtil
									.colorForKeyword(AndroidUtil.atBlue(text),
											Search.mKeyword)));
						}
						else
						{
							tvText.setText(Html.fromHtml(AndroidUtil
									.atBlue(text)));
						}

					}
					if (user != null)
					{

						tvName.setText(user.getName());
						if (user.isVerified())
							ivVerified.setVisibility(View.VISIBLE);
						else
							ivVerified.setVisibility(View.INVISIBLE);
						if (tvSource != null)
						{

							tvSource.setText(Html.fromHtml(""
									+ AndroidUtil.setTextColor(
											source,
											String.valueOf(WeiboMain.happyBlogConfig
													.getInt("source_color",
															Color.BLUE)))));
						}
						String profileImagePath = getProfileImagePath(user);
						loadBitmap(profileImagePath, ivProfileImage);
					}
					else
					{
						int vip = 0;
						if (mBlog != null)
						{
							vip = mBlog.vip;
						}
						else if (userInfo != null)
						{
							vip = userInfo.vip;
						}
						else if (directMessage != null)
						{
							// vip = directMessage.getSender().isVerified() ? 1
							// : 0;
							vip = 0;
						}

						if (vip == 0)
							ivVerified.setVisibility(View.INVISIBLE);
						else
							ivVerified.setVisibility(View.VISIBLE);
						if (Const.TIMELINE_TYPE_SEARCH_MBLOG
								.equals(mTimelineOperationProcess.mType))
						{
							tvSource.setVisibility(View.VISIBLE);
							tvSource.setText(Html.fromHtml(""
									+ AndroidUtil.setTextColor(
											mBlog.source,
											String.valueOf(WeiboMain.happyBlogConfig
													.getInt("source_color",
															Color.BLUE)))));
						}
						else
						{
							if (tvSource != null)
								tvSource.setVisibility(View.GONE);
						}
						if (msg != null)
							loadBitmap(msg.portrait, ivProfileImage);
						else if (mBlog != null)
							loadBitmap(mBlog.portrait, ivProfileImage);
						else if (directMessage != null)
							loadBitmap(directMessage.getSender()
									.getProfileImageURL().toString(),
									ivProfileImage);
					}

					if (mTimelineOperationProcess.mWeiboResponses.get(position) instanceof Status)
						createdAt = ((Status) mTimelineOperationProcess.mWeiboResponses
								.get(position)).getCreatedAt();
					else if (mTimelineOperationProcess.mWeiboResponses
							.get(position) instanceof Comment)
						createdAt = ((Comment) mTimelineOperationProcess.mWeiboResponses
								.get(position)).getCreatedAt();
					else if (mTimelineOperationProcess.mWeiboResponses
							.get(position) instanceof Msg)
						createdAt = ((Msg) mTimelineOperationProcess.mWeiboResponses
								.get(position)).time;
				}
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}

			TextView tvCreatedAt = (TextView) convertView
					.findViewById(R.id.tvCreatedAt);
			if (tvCreatedAt != null)
				tvCreatedAt.setTextColor(WeiboMain.happyBlogConfig
						.getInt("time_color", Color.BLACK));

			if (createdAt != null)
			{
				tvCreatedAt.setText(MyUtil.getTimeStr(createdAt, new Date()));
			}

			return convertView;

		}

	}

	// ˢʱʾ
	private void refresh(boolean flag)
	{

		if (mpbRefresh == null || mivRefresh == null)
			return;

		if (flag)
		{
			mpbRefresh.setVisibility(View.VISIBLE);
			mivRefresh.setVisibility(View.GONE);
		}
		else
		{
			mpbRefresh.setVisibility(View.GONE);
			mivRefresh.setVisibility(View.VISIBLE);

		}

	}

	private void setActivityTitle()
	{
		if (mDataType == Const.DATA_TYPE_PUBLIC_TIMELINE)
		{
			if (WeiboMain.mCurrentUser != null)
			{
				WeiboMain.mtvName.setText(WeiboMain.mCurrentUser
						.getName());
				WeiboMain.mtvStatus.setText(getDataTypeTitle());

			}
			else
			{
				WeiboMain.mtvName.setText(Values.MAIN_TITLE);
				WeiboMain.mtvStatus.setText(getDataTypeTitle());
			}
		}
		else if (mDataType == Const.DATA_TYPE_SEARCH_MBLOG
				|| mDataType == Const.DATA_TYPE_SEARCH_USER)
		{

			AndroidUtil.getMainTimelineOperationProcess(mContext).mActivity
					.setTitle("");
		}
		else
		{
			if (WeiboMain.mCurrentUser != null)
			{
				WeiboMain.mtvName.setText(WeiboMain.mCurrentUser
						.getName());
				WeiboMain.mtvStatus.setText(getDataTypeTitle());

			}
			else
			{

				WeiboMain.mtvName.setText(Values.MAIN_TITLE);
				WeiboMain.mtvStatus.setText(getDataTypeTitle());

			}
		}
	}

	private void hideChangePage()
	{
		View changePage = mActivity.findViewById(R.id.llChangePage);
		if (changePage == null)
			return;
		if (mDataType == Const.DATA_TYPE_PUBLIC_TIMELINE)
		{
			changePage.setVisibility(View.GONE);

		}
		else
		{

			// changePage.setVisibility(View.VISIBLE);
			changePage.setVisibility(View.GONE);

		}
	}

	private Handler mHandler = new Handler()
	{

		@Override
		public void handleMessage(android.os.Message msg)
		{

			switch (msg.what)
			{
				case 1: // wait
					mLoading = true;
					if (mtvWaitMsg != null)
						mtvWaitMsg.setText("ڻݣԺ...");
					if (AndroidUtil.getMainTimelineOperationProcess(mContext).mWeiboResponses
							.size() > 0)
					{

						if ((mDataType != Const.DATA_TYPE_SEARCH_MBLOG)
								&& (mDataType != Const.DATA_TYPE_SEARCH_USER)
								&& (mDataType != Const.DATA_TYPE_DIRECT_MESSAGE_SESSION))
							refresh(true);
						if (mActivity != null)
							AndroidUtil
									.getMainTimelineOperationProcess(mContext).mActivity
									.setProgressBarIndeterminateVisibility(true);
						if (mContext != null)
							((Activity) AndroidUtil
									.getMainTimelineOperationProcess(mContext).mContext)
									.setProgressBarIndeterminateVisibility(true);

					}
					else if ((mDataType == Const.DATA_TYPE_SEARCH_MBLOG)
							|| (mDataType == Const.DATA_TYPE_SEARCH_USER))
					{
						if (mActivity != null)
							AndroidUtil
									.getMainTimelineOperationProcess(mContext).mActivity
									.setProgressBarIndeterminateVisibility(true);
						if (mContext != null)
							((Activity) AndroidUtil
									.getMainTimelineOperationProcess(mContext).mContext)
									.setProgressBarIndeterminateVisibility(true);
					}
					else if ((mDataType == Const.DATA_TYPE_COMMENT || mDataType == Const.DATA_TYPE_DIRECT_MESSAGE_SESSION))
					{

						if (mLoadStatusesLayout != null)
						{
							mLoadStatusesLayout.setVisibility(View.VISIBLE);
							// mtvWaitMsg.setText((String) msg.obj);
						}
					}

					else
					{

						if (mLoadStatusesLayout != null)
						{

							mLoadStatusesLayout.setVisibility(View.VISIBLE);
							// mtvWaitMsg.setText((String) msg.obj);

						}

					}

					break;
				case 2: // end
					refresh(false);
					if (mActivity != null)
					{
						mActivity.setProgressBarIndeterminateVisibility(false);
						// mActivity
						// .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
					}
					else
					{
						((Activity) mContext)
								.setProgressBarIndeterminate(false);
					}
					mRefresh = false;
					if (mLoadStatusesLayout != null)
						mLoadStatusesLayout.setVisibility(View.GONE);

					break;
				case 3: // exception

					refresh(false);
					
					if (mActivity != null)
					{
						mActivity.setProgressBarIndeterminateVisibility(false);
						// mActivity
						// .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
						mRefresh = false;
					}
					else
					{
						((Activity) mContext)
								.setProgressBarIndeterminateVisibility(false);
					}
					if (mLoadStatusesLayout != null)
						mLoadStatusesLayout.setVisibility(View.GONE);
					if (mMoreStatus)
					{
						Message.showMsg(mActivity, "ø΢Ϣʧ.");
					}
					else
					{
						Message.showMsg(mActivity, "ˢʧ.");
					}

					mMoreStatus = false;
					mLoading = false;
					break;
				case 4: // success

					if (mProcessParent != null)
						mProcessParent.hideAllWidget();

					hideChangePage();
					mWeakReferenceAdapter = new WeakReference<TimelineAdapter>(
							new TimelineAdapter(TimelineOperationProcess.this,
									mContext));
					mlvTimeline.setVisibility(View.VISIBLE);
					mlvTimeline.setAdapter(mWeakReferenceAdapter.get());
					if (mLoadStatusesLayout != null)
						mLoadStatusesLayout.setVisibility(View.GONE);
					/*
					 * if (mActivity != null) mActivity
					 * .setRequestedOrientation(ActivityInfo
					 * .SCREEN_ORIENTATION_SENSOR); else ((Activity) mContext)
					 * .setRequestedOrientation
					 * (ActivityInfo.SCREEN_ORIENTATION_SENSOR);
					 */
					if (!mMoreStatus)
						AndroidUtil.getMainTimelineOperationProcess(mContext).mPage = 1;
					if (AndroidUtil.getMainTimelineOperationProcess(mContext).mtvCurrentPageNumber != null)
						AndroidUtil.getMainTimelineOperationProcess(mContext).mtvCurrentPageNumber
								.setText(String.valueOf(AndroidUtil
										.getMainTimelineOperationProcess(mContext).mPage));
					setActivityTitle();
					mRefresh = false;
					mMoreStatus = false;
					mLoading = false;
					mlvTimeline.setSelection(mFirstVisibleItem);
					break;
				case 5:
					hideChangePage();
					setActivityTitle();
					break;
			}
			super.handleMessage(msg);
		}

	};

	@Override
	public boolean onWait(final String msg, int type)
	{

		if (mMoreStatus)
			return true;

		android.os.Message message = new android.os.Message();
		message.what = 1;
		message.obj = msg;
		mHandler.sendMessage(message);
		if (mActivity.getRequestedOrientation() == ActivityInfo.SCREEN_ORIENTATION_PORTRAIT)
		{

			// / mActivity
			// .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
		}
		else if (mActivity.getRequestedOrientation() == ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE)
		{
			// mActivity
			// .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);

		}
		if (WeiboMain.mCurrentUser == null)
		{

			String password = AndroidUtil.getSystemDBService(mContext)
					.getPassword(WeiboMain.mainAlias);
			MyMicroBlogAsync myMicroBlogAsync = new MyMicroBlogAsync(
					WeiboMain.mainAlias, password);
			try
			{

				if (new File(
						Values.getCacheFilename(WeiboMain.mainAlias))
						.exists())
				{

					WeiboMain.mCurrentUser = Cache
							.restoreUser(WeiboMain.mainAlias);
				}
				else
				{
					WeiboMain.mCurrentUser = myMicroBlogAsync.login();
				}
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
		}
		if (mInitData)
		{

			// ӻװ
			if (new File(Values.getCacheFilename(getCacheName())).exists())
			{
				try
				{

					mWeiboResponses = Cache
							.restore(getCacheName(), new Weibo());

				}
				catch (Exception e)
				{
					Log.d("restore_exception", String.valueOf(e));
				}

				loadStatuses();

				android.os.Message message1 = new android.os.Message();
				message1.what = 5;
				mHandler.sendMessage(message1);
				mLoading = false;
				return false;
			}

		}

		return super.onWait(msg, type);

	}

	@Override
	public void onEnd(final String msg, Object obj, int type)
	{

		android.os.Message message = new android.os.Message();
		message.what = 2;
		message.obj = msg;
		mHandler.sendMessage(message);

		super.onEnd(msg, obj, type);

	}

	@Override
	public void onException(String msg, int type)
	{
		super.onException(msg, type);
		android.os.Message message = new android.os.Message();
		message.what = 3;
		message.obj = msg;
		mHandler.sendMessage(message);
	}

}
