package sina.weibo.storage;

import android.database.Cursor;
import microblog.storage.SqliteCursor;

public class SqliteCursorImpl implements SqliteCursor
{
	private Cursor mCursor;

	public SqliteCursorImpl(Cursor cursor)
	{
		mCursor = cursor;
	}

	@Override
	public int getInt(String columnName)
	{
		return mCursor.getInt(mCursor.getColumnIndex(columnName));
	}

	@Override
	public boolean getBoolean(String columnName)
	{
		int value = getInt(columnName);
		if (value == 1)
		{
			return true;
		}
		else
		{
			return false;
		}

	}

	@Override
	public String getString(String columnName)
	{

		return mCursor.getString(mCursor.getColumnIndex(columnName));
	}

	@Override
	public boolean moveToNext()
	{

		return mCursor.moveToNext();
	}

	@Override
	public boolean requery()
	{
		return mCursor.requery();

	}

	@Override
	public boolean moveToFirst()
	{

		return mCursor.moveToFirst();
	}

	@Override
	public void close()
	{
		mCursor.close();
	}

	@Override
	public boolean moveToPosition(int position)
	{
		return mCursor.moveToPosition(position);
	}

	@Override
	public int getCount()
	{

		return mCursor.getCount();
	}

}
