package sina.weibo.widget;

import java.util.ArrayList;
import java.util.List;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ImageView;

public class Toolbar implements OnClickListener
{

	private int[] toolbarImageResIds;
	private int[] toolbarSelectedImageResIds;
	private int[] toolbarImageViewResIds;

	// ֮ԸΪ-1Ϊ˱ʾһselectedͼñΪ-1ټ1ͱ-2
	// ֵΪ-2ʱʾһselectedͼ񣬽λΪ0
	private int mToolbarCurrentPosition = -1;
	private List<ImageView> mToolbarImageView = new ArrayList<ImageView>();
	private View view;

	public int[] getToolbarImageResIds()
	{
		return toolbarImageResIds;
	}

	public void setToolbarImageResIds(int[] toolbarImageResIds)
	{
		this.toolbarImageResIds = toolbarImageResIds;
	}

	public int[] getToolbarSelectedImageResIds()
	{
		return toolbarSelectedImageResIds;
	}

	public void setToolbarSelectedImageResIds(int[] toolbarSelectedImageResIds)
	{
		this.toolbarSelectedImageResIds = toolbarSelectedImageResIds;
	}

	public int[] getToolbarImageViewResIds()
	{
		return toolbarImageViewResIds;
	}

	public void setToolbarImageViewResIds(int[] toolbarImageViewResIds)
	{
		this.toolbarImageViewResIds = toolbarImageViewResIds;
	}

	public View getView()
	{
		return view;
	}

	public void setView(View view)
	{
		this.view = view;
	}

	// ¼
	@Override
	public void onClick(View view)
	{
		mToolbarCurrentPosition = Integer.parseInt(String
				.valueOf(view.getTag()));
		restoreToolbarImage();
		ImageView imageView = mToolbarImageView.get(mToolbarCurrentPosition);
		imageView
				.setImageResource(toolbarSelectedImageResIds[mToolbarCurrentPosition]);

	}

	public void onKeyUp(int keyCode, KeyEvent event)
	{
		restoreToolbarImage();
		
		if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT
				|| keyCode == KeyEvent.KEYCODE_DPAD_RIGHT)
		{
			switch (keyCode)
			{
				case KeyEvent.KEYCODE_DPAD_LEFT:

					mToolbarCurrentPosition--;
					if (mToolbarCurrentPosition == -2)
						mToolbarCurrentPosition = 0;
					else if (mToolbarCurrentPosition == -1)
						mToolbarCurrentPosition = mToolbarImageView.size() - 1;

					break;

				case KeyEvent.KEYCODE_DPAD_RIGHT:
					mToolbarCurrentPosition++;
					if (mToolbarCurrentPosition == mToolbarImageView.size())
						mToolbarCurrentPosition = 0;

					break;
			}
			ImageView imageView = mToolbarImageView
					.get(mToolbarCurrentPosition);
			imageView
					.setImageResource(toolbarSelectedImageResIds[mToolbarCurrentPosition]);
		}
	}

	// ////////////////////////////////
	private void restoreToolbarImage()
	{
		for (int i = 0; i < toolbarImageResIds.length; i++)
		{
			mToolbarImageView.get(i).setImageResource(toolbarImageResIds[i]);
		}
	}

	public void setAllImageViewData()
	{

		for (int i = 0; i < toolbarImageResIds.length; i++)
		{

			mToolbarImageView.add((ImageView) view
					.findViewById(toolbarImageViewResIds[i]));
			mToolbarImageView.get(i).setTag(i);
			mToolbarImageView.get(i).setOnClickListener(this);
		}
	}

}
