/* ---------------------------------------
**
**   Connect to XSPICE
**   1998 07 23
**   Volodymyr Marchuk
**
*/

#include "devdefs.h"
#include "iferrmsg.h"

extern SPICEdev * FAR DynDEVices[];

#include "MIFdefs.h" 
#include "MIFproto.h" 
#include "MIFparse.h" 
#include "CMtypes.h"

#undef FAR
#include <windows.h>
#include "Dfunctbl.h"

FuncTable *pMainFT;


#define DllExport    __declspec( dllexport )


DllExport int vm_entry_dynmodel( SPICEdev * FAR DEVices[], int *current )
{
	int i, numb;

    numb = 1; /* sizeof(DynDEVices)/sizeof(SPICEdev *); */
	if( current != NULL )
	{
		for( i = 0; i < numb; i++ )
			DEVices[ i + *current ] = DynDEVices[i];
		*current += numb;
	}

	return( numb );
}

DllExport int vm_pass_hmaindll( FuncTable *pPassedFT )
{
	pMainFT = pPassedFT;

	return( OK );
}



int MIFsetup(
    SMPmatrix             *matrix,
    struct sGENmodel      *inModel,
    CKTcircuit            *ckt,
    int                   *state )
{
	return( pMainFT->MIFsetup( matrix, inModel, ckt, state ) );
}


int MIFunsetup(
    struct sGENmodel      *inModel,
    CKTcircuit            *ckt
)
{
	return( pMainFT->MIFunsetup( inModel, ckt ) );
}



int MIFload(
    struct sGENmodel      *inModel,
    CKTcircuit    *ckt
)
{
	return( pMainFT->MIFload( inModel, ckt ) );
}



int MIFmParam(
    int param_index,
    union uIFvalue *value,
    struct sGENmodel *inModel
)
{
	return( pMainFT->MIFmParam( param_index, value, inModel ) );
}


int MIFask(
    CKTcircuit *ckt,
    struct sGENinstance *inst,
    int param_index,
    union uIFvalue *value,
    union uIFvalue *select
)
{
	return( pMainFT->MIFask( ckt, inst, param_index, value, select ) );
}


int MIFmAsk(
    CKTcircuit *ckt,
    struct sGENmodel *inModel,
    int param_index,
    union uIFvalue *value
)
{
	return( pMainFT->MIFmAsk( ckt, inModel, param_index, value ) );
}


int MIFtrunc(
    struct sGENmodel   *inModel,
    CKTcircuit *ckt,
    double     *timeStep
)
{
	return( pMainFT->MIFtrunc( inModel, ckt, timeStep	) );
}


int MIFconvTest(
    struct sGENmodel   *inModel,
    CKTcircuit *ckt
)
{
	return( pMainFT->MIFconvTest( inModel, ckt ) );
}


int MIFdelete(
    struct sGENmodel *inModel,
    IFuid    name,
    struct sGENinstance  **inst
)
{
	return( pMainFT->MIFdelete( inModel, name, inst ) );
}


int MIFmDelete(
    struct sGENmodel **inModel,
    IFuid    modname,
    struct sGENmodel *model
)
{
	return( pMainFT->MIFmDelete( inModel, modname, model ) );
}


void MIFdestroy(
    struct sGENmodel **inModel
)
{
	pMainFT->MIFdestroy( inModel );
}


void cm_event_alloc(InstanceHandle inst,int tag, int bytes)
{
	pMainFT->cm_event_alloc( inst, tag, bytes );
}


void *cm_event_get_ptr(InstanceHandle inst,int tag, int timepoint)
{
	return( pMainFT->cm_event_get_ptr( inst, tag, timepoint ) );
}


void cm_climit_fcn(double in, double in_offset, double cntl_upper, 
                   double cntl_lower, double lower_delta, 
                   double upper_delta, double limit_range, 
                   double gain, int percent, double *out_final,
                   double *pout_pin_final, double *pout_pcntl_lower_final,
                   double *pout_pcntl_upper_final)
{
	pMainFT->cm_climit_fcn(in, in_offset, cntl_upper, 
                   cntl_lower, lower_delta, 
                   upper_delta, limit_range, 
                   gain, percent, out_final,
                   pout_pin_final, pout_pcntl_lower_final,
                   pout_pcntl_upper_final);
}


void cm_smooth_corner(double x_input, double x_center, double y_center,
                 double domain, double lower_slope, double upper_slope,
                 double *y_output, double *dy_dx)
{
	pMainFT->cm_smooth_corner( x_input,  x_center,  y_center,
                  domain,  lower_slope,  upper_slope,
                  y_output,  dy_dx);
}

void cm_smooth_discontinuity(double x_input, double x_lower, double y_lower,
                 double x_upper, double y_upper,
                 double *y_output, double *dy_dx)
{
	pMainFT->cm_smooth_discontinuity( x_input,  x_lower,  y_lower,
                  x_upper,  y_upper,
                  y_output,  dy_dx);
}

double cm_smooth_pwl(double x_input, double *x, double *y, int size,
               double input_domain, double *dout_din)
{
	return( pMainFT->cm_smooth_pwl( x_input,  x,  y,  size,
                input_domain,  dout_din) );
}

double cm_analog_ramp_factor(InstanceHandle inst)
{
	return( pMainFT->cm_analog_ramp_factor(inst) );
}

void cm_analog_alloc(InstanceHandle inst,int tag, int bytes)
{
	pMainFT->cm_analog_alloc( inst, tag,  bytes);
}

void *cm_analog_get_ptr(InstanceHandle inst,int tag, int timepoint)
{
	return( pMainFT->cm_analog_get_ptr( inst, tag,  timepoint) );
}

int  cm_analog_integrate(InstanceHandle inst,double integrand, double *integral, double *partial)
{
	return( pMainFT-> cm_analog_integrate( inst, integrand,  integral,  partial) );
}

int  cm_analog_converge(InstanceHandle inst,double *state)
{
	return( pMainFT-> cm_analog_converge( inst, state) );
}

int  cm_analog_set_temp_bkpt(InstanceHandle inst,double time)
{
	return( pMainFT-> cm_analog_set_temp_bkpt( inst, time) );
}

int  cm_analog_set_perm_bkpt(InstanceHandle inst,double time)
{
	return( pMainFT-> cm_analog_set_perm_bkpt( inst, time) );
}

void cm_analog_not_converged(InstanceHandle inst)
{
	pMainFT->cm_analog_not_converged( inst);
}

void cm_analog_auto_partial(InstanceHandle inst)
{
	pMainFT->cm_analog_auto_partial( inst);
}


int  cm_event_queue(InstanceHandle inst,double time)
{
	return( pMainFT->cm_event_queue( inst, time) );
}

char *cm_message_get_errmsg(InstanceHandle inst)
{
	return( pMainFT->cm_message_get_errmsg( inst) );
}

int  cm_message_send(InstanceHandle inst,char *msg)
{
	return( pMainFT-> cm_message_send( inst, msg) );
}

double cm_netlist_get_c(InstanceHandle inst)
{
	return( pMainFT->cm_netlist_get_c( inst) );
}

double cm_netlist_get_l(InstanceHandle inst)
{
	return( pMainFT->cm_netlist_get_l( inst) );
}

Complex_t cm_complex_set(double real, double imag)
{
	return( pMainFT->cm_complex_set( real,  imag) );
}

Complex_t cm_complex_add(Complex_t x, Complex_t y)
{
	return( pMainFT->cm_complex_add( x,  y) );
}

Complex_t cm_complex_subtract(Complex_t x, Complex_t y)
{
	return( pMainFT->cm_complex_subtract( x,  y) );
}

Complex_t cm_complex_multiply(Complex_t x, Complex_t y)
{
	return( pMainFT->cm_complex_multiply( x,  y) );
}

Complex_t cm_complex_divide(Complex_t x, Complex_t y)
{
	return( pMainFT->cm_complex_divide( x,  y) );
}

