#ifndef HDR_basic_h
#define HDR_basic_h

  #ifdef _DEBUG
  #ifdef _MSC_VER
  #pragma message( "  parsing Basic.H" )
  #endif /*_MSC_VER*/
  #endif /*_DEBUG*/

  #include "confdef.h"

      /* using an ansi C compiler, so we have the void* construct */
  typedef void GENERIC;

  #ifdef XSPICE_BUILD
    #ifndef EXPORT
      #ifdef EWB_IIT
         #if defined(IIT) && defined(DLL)
             #ifdef MSVC
                 #define EXPORT      __stdcall
             #elif defined(IIT_WIN32)
                 #define EXPORT      __stdcall _export
             #else
                 #define EXPORT      far pascal _export
             #endif
         #else
            #define EXPORT
         #endif
      #else
         #define EXPORT
      #endif
    #endif
  #else
    #ifndef EXPORT
            #ifdef MSVC
//                   #define EXPORT      __stdcall 
                   #define EXPORT      __stdcall __declspec(dllexport) 
            #elif defined(WIN32)
                   #define EXPORT      __stdcall _export
            #else
                   #define EXPORT      far pascal _export
            #endif
    #endif
    #ifndef IIT
      #define IIT
    #endif
    #ifndef EWB_IIT
      #define EWB_IIT
    #endif
    #ifndef ERR_WARNING
      #define ERR_WARNING ERR_WARN
    #endif
  #endif

#if defined(MSVC)
    #define IITEXPORT(type,name)        type (EXPORT *name)
#else
    #define IITEXPORT(type,name)        type EXPORT (*name)
#endif

  typedef struct CKTcircuit_tag CKTcircuit;

  typedef struct sMIFmodel    MIFmodel;
  typedef struct sMIFinstance MIFinstance;

  /*
   * Some preliminary definitions:
   *
   * IFnode's are returned by the simulator, thus we don't really
   * know what they look like, just that we get to carry pointers
   * to them around all the time, and will need to save them occasionally
   *
   */

  typedef void * IFnode;

  /*
   *
   * datatype: IFuid
   *
   * unique identifier for all name-type data in the simulator.
   * this permits the front end to use something other than
   * a unique, fully qualified character string to identify
   * an object.
   *
   */

  typedef GENERIC *IFuid;


#endif
