#include "xspice.h"

//#ifdef IIT
//#define _complex _rename_complex_to_avoid_redefinition_problems_with_microsoft_compiler
//#define complex rename_complex_to_avoid_redefinition_problems_with_microsoft_compiler
//#endif

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 * Standard definitions. This file serves as the header file for std.c and
 * wlist.c
 */

#ifndef _STD_H_
#define _STD_H_

typedef int BOOL;

#include "misc.h"
#include "util.h"

#ifndef FILE
/* XXX Bogus */
#  include <stdio.h>
#endif

/* Doubly linked lists of words. */

struct wordlist {
    char *wl_word;
    struct wordlist *wl_next;
    struct wordlist *wl_prev;
} ;

typedef struct wordlist wordlist;

/* Complex numbers. */

struct SPICE_complex {   /* IBM portability... */
    double cx_real;
    double cx_imag;
} ;

typedef struct SPICE_complex SPICE_complex;

#define realpart(cval)  ((struct SPICE_complex *) (cval))->cx_real
#define imagpart(cval)  ((struct SPICE_complex *) (cval))->cx_imag

/* Externs defined in std.c */
extern int cp_numdgt;

#ifndef IIT
extern void setenv(InstanceHandle inst);
extern char *gethome(InstanceHandle inst);
extern char *getusername(InstanceHandle inst);
#endif

extern void quit(InstanceHandle inst);
extern void fatal(InstanceHandle inst);
extern char *tildexpand(InstanceHandle inst, char *string);
extern char *printnum(InstanceHandle inst, double num);
extern void cp_printword(InstanceHandle inst, char *string,FILE *fp);

/* Externs from wlist.c */

extern char **wl_mkvec(InstanceHandle inst, wordlist *wlist);
extern char *wl_flatten(InstanceHandle inst, wordlist *wlist);
extern int wl_length(InstanceHandle inst, wordlist *wlist);
extern void wl_free(InstanceHandle inst, wordlist *wlist);
extern void wl_print(InstanceHandle inst, wordlist *wlist,FILE *fp);
extern void wl_sort(InstanceHandle inst, wordlist *wlist);
extern wordlist *wl_append(InstanceHandle inst, wordlist *wlist,wordlist *nwl);
extern wordlist *wl_build(InstanceHandle inst, char *v[]);
extern wordlist *wl_copy(InstanceHandle inst, wordlist *wlist);
extern wordlist *wl_nthelem(InstanceHandle inst, int i,wordlist *wl);
extern wordlist * wl_range(InstanceHandle inst, wordlist* wl, int low, int up);
extern wordlist *wl_reverse(InstanceHandle inst, wordlist *wlist);
extern wordlist *wl_splice(InstanceHandle inst, wordlist *elt,wordlist *list);

#endif /* _STD_H_*/
