#include "xspice.h"

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef DEV
#define DEV

#include "optdefs.h"
#include "gendefs.h"
#include "ifsim.h"
#include "cktdefs.h"
#include "noisedef.h"
#include "complex.h"

double DEVlimvds(InstanceHandle inst, double,double);
double DEVpnjlim(InstanceHandle inst, double,double,double,double,int*);
double DEVfetlim(InstanceHandle inst, double,double,double);
void DEVcmeyer(InstanceHandle inst, double,double,double,double,double,double,double,double,double,
        double,double,double*,double*,double*,double,double,double,double);
void DEVqmeyer(InstanceHandle inst, double,double,double,double,double,double*,double*,double*,
        double,double);
#ifdef notdef
void DEVcap(InstanceHandle inst, CKTcircuit*, double, double, double, double, double, double,
        double, double, double, double, double, double, double, double,
        double*, double*, double*, double*, double*, double*, double*,
        double*, double*, double*, double*, double*, double, double,
        double, double*, double*, double);
#endif
double DEVpred(InstanceHandle inst, CKTcircuit*,int);

#if defined(IIT) || defined(IIT) 
typedef int (*SPICEdev_DEVparam_t)(int,IFvalue*,GENinstance*,IFvalue *);
        /* routine to input a parameter to a device instance */
typedef int (*SPICEdev_DEVmodParam_t)(int,IFvalue*,GENmodel*);
        /* routine to input a paramater to a model */
typedef int (*SPICEdev_DEVload_t)(GENmodel*,CKTcircuit*);
        /* routine to load the device into the matrix */
typedef int (*SPICEdev_DEVsetup_t)(SMPmatrix*,GENmodel*,CKTcircuit*,int*);
        /* setup routine to preprocess devices once before soloution begins */
//...
typedef int (*SPICEdev_DEVunsetup_t)(GENmodel*,CKTcircuit*);
	/* clean up before running again */
//...
typedef int (*SPICEdev_DEVpzSetup_t)(SMPmatrix*,GENmodel*,CKTcircuit*,int*);
        /* setup routine to process devices specially for pz analysis */
typedef int (*SPICEdev_DEVtemperature_t)(GENmodel*,CKTcircuit*);
        /* subroutine to do temperature dependent setup processing */
typedef int (*SPICEdev_DEVtrunc_t)(GENmodel*,CKTcircuit*,double*);
        /* subroutine to perform truncation error calc. */
typedef int (*SPICEdev_DEVfindBranch_t)(CKTcircuit*,GENmodel*,IFuid);
        /* subroutine to search for device branch eq.s */
typedef int (*SPICEdev_DEVacLoad_t)(GENmodel*,CKTcircuit*);
        /* ac analysis loading function */
typedef int (*SPICEdev_DEVaccept_t)(CKTcircuit*,GENmodel*);
        /* subroutine to call on acceptance of a timepoint */
typedef void (*SPICEdev_DEVdestroy_t)(GENmodel**);
        /* subroutine to destroy all models and instances */

typedef int (*SPICEdev_DEVmodDelete_t)(GENmodel**,IFuid,GENmodel*);
        /* subroutine to delete a model and all instances */
typedef int (*SPICEdev_DEVdelete_t)(GENmodel*,IFuid,GENinstance**);
        /* subroutine to delete an instance */
typedef int (*SPICEdev_DEVsetic_t)(GENmodel*,CKTcircuit*);
        /* routine to pick up device init conds from rhs */
typedef int (*SPICEdev_DEVask_t)(CKTcircuit*,GENinstance*,int,IFvalue*,IFvalue*);
        /* routine to ask about device details*/
typedef int (*SPICEdev_DEVmodAsk_t)(CKTcircuit*,GENmodel*,int,IFvalue*);
        /* routine to ask about model details*/

typedef int (*SPICEdev_DEVpzLoad_t)(GENmodel*,CKTcircuit*,SPcomplex*);
	/* routine to load for pole-zero analysis */
typedef int (*SPICEdev_DEVconvTest_t)(GENmodel*,CKTcircuit*);
	/* convergence test function */
typedef int (*SPICEdev_DEVsenSetup_t)(SENstruct*,GENmodel*);
	/* routine to setup the device sensitivity info */
typedef int (*SPICEdev_DEVsenLoad_t)(GENmodel*,CKTcircuit*);
	/* routine to load the device sensitivity info */
typedef int (*SPICEdev_DEVsenUpdate_t)(GENmodel*,CKTcircuit*);
	/* routine to update the device sensitivity info */

typedef int (*SPICEdev_DEVsenAcLoad_t)(GENmodel*,CKTcircuit*);
	/* routine to load  the device ac sensitivity info */
typedef void (*SPICEdev_DEVsenPrint_t)(GENmodel*,CKTcircuit*);
	/* subroutine to print out sensitivity info */
typedef int (*SPICEdev_DEVsenTrunc_t)(GENmodel*,CKTcircuit*,double*);
	/* subroutine to print out sensitivity info */
//...
typedef int (*SPICEdev_DEVdisto_t)(int,GENmodel*,CKTcircuit*);
	/* procedure to do distortion operations */
typedef int (*SPICEdev_DEVnoise_t)(int, int, GENmodel*,CKTcircuit*, Ndata *, double *);
	/* noise routine */
//...
#endif

typedef struct SPICEdev {
    IFdevice DEVpublic;

#if defined(IIT) || defined(IIT)
        SPICEdev_DEVparam_t DEVparam;
        /* routine to input a parameter to a device instance */
        SPICEdev_DEVmodParam_t DEVmodParam;
        /* routine to input a paramater to a model */
        SPICEdev_DEVload_t DEVload;
        /* routine to load the device into the matrix */
        SPICEdev_DEVsetup_t DEVsetup;
        /* setup routine to preprocess devices once before soloution begins */
//...
        SPICEdev_DEVunsetup_t DEVunsetup;
	/* clean up before running again */
//...
        SPICEdev_DEVpzSetup_t DEVpzSetup;
        /* setup routine to process devices specially for pz analysis */
        SPICEdev_DEVtemperature_t DEVtemperature;
        /* subroutine to do temperature dependent setup processing */
        SPICEdev_DEVtrunc_t DEVtrunc;
        /* subroutine to perform truncation error calc. */
        SPICEdev_DEVfindBranch_t DEVfindBranch;
        /* subroutine to search for device branch eq.s */
        SPICEdev_DEVacLoad_t DEVacLoad;
        /* ac analysis loading function */
        SPICEdev_DEVaccept_t DEVaccept;
        /* subroutine to call on acceptance of a timepoint */
        SPICEdev_DEVdestroy_t DEVdestroy;
        /* subroutine to destroy all models and instances */

        SPICEdev_DEVmodDelete_t DEVmodDelete;
        /* subroutine to delete a model and all instances */
        SPICEdev_DEVdelete_t DEVdelete;
        /* subroutine to delete an instance */
        SPICEdev_DEVsetic_t DEVsetic;
        /* routine to pick up device init conds from rhs */
        SPICEdev_DEVask_t DEVask;
        /* routine to ask about device details*/
        SPICEdev_DEVmodAsk_t DEVmodAsk;
        /* routine to ask about model details*/

        SPICEdev_DEVpzLoad_t DEVpzLoad;
	/* routine to load for pole-zero analysis */
        SPICEdev_DEVconvTest_t DEVconvTest;
	/* convergence test function */
        SPICEdev_DEVsenSetup_t DEVsenSetup;
	/* routine to setup the device sensitivity info */
        SPICEdev_DEVsenLoad_t DEVsenLoad;
	/* routine to load the device sensitivity info */
        SPICEdev_DEVsenUpdate_t DEVsenUpdate;
	/* routine to update the device sensitivity info */

        SPICEdev_DEVsenAcLoad_t DEVsenAcLoad;
	/* routine to load  the device ac sensitivity info */
        SPICEdev_DEVsenPrint_t DEVsenPrint;
	/* subroutine to print out sensitivity info */
        SPICEdev_DEVsenTrunc_t DEVsenTrunc;
	/* subroutine to print out sensitivity info */
//...
        SPICEdev_DEVdisto_t DEVdisto;
	/* procedure to do distortion operations */
        SPICEdev_DEVnoise_t DEVnoise;
	/* noise routine */
//...
#endif /* IIT */

#if defined(IIT) || !defined(XSPICE)
    int *DEVinstSize;    /* size of an instance */
    int *DEVmodSize;     /* size of a model */
#else
    int DEVinstSize;    /* size of an instance */
    int DEVmodSize;     /* size of a model */
#endif

} SPICEdev;  /* instance of structure for each possible type of device */

/* IOP( )	Input/output parameter
 * IOPP( )	IO parameter which the principle value of a device (used
 *			for naming output variables in sensetivity)
 * IOPA( )	IO parameter significant for time-varying (non-dc) analyses
 * IOPAP( )	Principle value is significant for time-varying analyses
 * IOPAA( )	IO parameter significant for ac analyses only
 * IOPAAP( )	IO parameter principle value for ac analyses only
 * IOPN( )	IO parameter significant for noise analyses only
 * IOPR( )	Redundant IO parameter name (e.g. "vto" vs. "vt0")
 * IOPX( )	IO parameter which is not used by sensetivity in any case
 *
 * IOPQ( )	This (Q) parameter must be non-zero for sensetivity of
 *			following Z parameter (model params done first)
 * IOPZ( )	Prev. 'Q' parameter must be non-zero for sensetivity
 * IOPQO( )	Like Q, but or-ed with previous Q value
 * ....U( )	uninteresting for default "show" command output
 */

#ifndef HAS_MINDATA

# define IOP(a,b,c,d)   { a, b, c|IF_SET|IF_ASK,			d }
# define IOPU(a,b,c,d)   { a, b, c|IF_SET|IF_ASK|IF_UNINTERESTING,	d }
# define IOPP(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_PRINCIPAL,		d }
# define IOPA(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_AC,			d }
# define IOPAU(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC|IF_UNINTERESTING,d }
# define IOPAP(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC|IF_PRINCIPAL,	d }
# define IOPAA(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY,		d }
# define IOPAAU(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY|IF_UNINTERESTING,d}
# define IOPPA(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY|IF_PRINCIPAL, d }
# define IOPN(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NOISE,		d }
//# define IOPR(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_REDUNDANT,       NULL }
# define IOPR(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_REDUNDANT,       d }
# define IOPX(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NONSENSE,		d }
# define IOPXU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NONSENSE|IF_UNINTERESTING,\
									d }
# define IOPQ(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_SETQUERY,		d }
# define IOPQU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_SETQUERY|IF_UNINTERESTING,\
									d }
# define IOPZ(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_CHKQUERY,		d }
# define IOPZU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_CHKQUERY|IF_UNINTERESTING,\
									d }
# define IOPQO(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_ORQUERY,		d }

# define IP(a,b,c,d) { a , b , c|IF_SET , d }
# define OP(a,b,c,d) { a , b , c|IF_ASK , d }
# define OPU(a,b,c,d) { a , b , c|IF_ASK|IF_UNINTERESTING , d }
# define OPR(a,b,c,d) { a , b , c|IF_ASK|IF_REDUNDANT , d }
# define P(a,b,c,d) { a , b , c , d }

#else /* HAS_MINDATA */

/*
 * these are for the IBM PC which gets upset by the long description 
 * strings used in IFparm definitions because they add up to more than
 * 64k of static data
 */

# define IOP(a,b,c,d)   { a, b, c|IF_SET|IF_ASK,            NULL }
# define IOPU(a,b,c,d)   { a, b, c|IF_SET|IF_ASK|IF_UNINTERESTING,	NULL }
# define IOPP(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_PRINCIPAL,		NULL }
# define IOPA(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_AC,			NULL }
# define IOPAU(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC|IF_UNINTERESTING, NULL }
# define IOPAP(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC|IF_PRINCIPAL,	NULL }
# define IOPAA(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY,		NULL }
# define IOPAAU(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY|IF_UNINTERESTING,\
									NULL }
# define IOPPA(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY|IF_PRINCIPAL,NULL }
# define IOPN(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NOISE,		NULL }
# define IOPR(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_REDUNDANT,		NULL }
# define IOPX(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NONSENSE,		NULL }
# define IOPXU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NONSENSE|IF_UNINTERESTING,\
									NULL }
# define IOPQ(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_SETQUERY,		NULL }
# define IOPQU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_SETQUERY|IF_UNINTERESTING,\
									NULL }
# define IOPZ(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_CHKQUERY,		NULL }
# define IOPZU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_CHKQUERY|IF_UNINTERESTING,\
									NULL }
# define IOPQO(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_ORQUERY,		NULL }

# define IP(a,b,c,d) { a, b, c|IF_SET , NULL }
# define OP(a,b,c,d) { a, b, c|IF_ASK , NULL }
# define OPU(a,b,c,d) { a , b , c|IF_ASK|IF_UNINTERESTING , NULL }
# define OPR(a,b,c,d) { a , b , c|IF_ASK|IF_REDUNDANT , NULL }
# define P(a,b,c,d) { a, b, c , NULL }

#endif /* HAS_MINDATA */

#define DEV_DEFAULT	0x1


#ifdef IIT
    //* THE FOLLOWING PARAMETERS MAY BE DEFINED FOR ANY DEVICE
    #define GENDEV_TMAX        -1
    #define GENDEV_IS_LINEAR   -2
#endif

#endif /*DEV*/
