#ifndef EVTPROTO_HEADER
#define EVTPROTO_HEADER 

/* ===========================================================================
FILE    EVTproto.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains ANSI C function prototypes for functions
    in the event-driven simulation algorithm package.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

#include "CKTdefs.h"
#include "CPstd.h"
#include "MIFdefs.h"
#include "IPC.h"


/* ******************* */
/* Function Prototypes */
/* ******************* */


int EVTinit1(CKTcircuit *ckt);
int EVTinit2(CKTcircuit *ckt);

void EVTtermInsert(
    struct CKTcircuit_tag      *ckt,
    struct sMIFinstance  *fast,
    char            *node_name,
    char            *type_name,
    int             conn_num,
    int             port_num,
    char            **err_msg);

int EVTsetup(struct CKTcircuit_tag *ckt);

int EVTiter(struct CKTcircuit_tag *ckt);

void EVTbackup(struct CKTcircuit_tag *ckt, double new_time);

double EVTnext_time(struct CKTcircuit_tag *ckt);

void EVTqueue_output(
    struct CKTcircuit_tag *ckt,
    int        output_index,
    int        udn_index,
    struct Evt_Output_Event_s  *new_event,
    double     posted_time,
    double     event_time);


void EVTqueue_inst(
    struct CKTcircuit_tag *ckt,
    int        inst_index,
    double     posted_time,
    double     event_time);

void EVTdequeue(struct CKTcircuit_tag *ckt, double time);

int EVTload(struct CKTcircuit_tag *ckt, int inst_index);

void EVTprint(InstanceHandle inst,wordlist *wl);

int EVTop(
    struct CKTcircuit_tag *ckt,
    long       firstmode,
    long       continuemode,
    int        max_iter,
    Mif_BOOLEAN_t  first_call);

void EVTop_save(
    struct CKTcircuit_tag    *ckt,
    Mif_BOOLEAN_t op,
    double        step);

void EVTnode_copy(
    struct CKTcircuit_tag    *ckt,
    int           node_index,
    struct Evt_Node_s    *from,
    struct Evt_Node_s    **to);

void EVTcall_hybrids(struct CKTcircuit_tag *ckt);

void EVTdump(
    struct CKTcircuit_tag    *ckt,
    Ipc_Anal_t    mode,
    double        step);

void EVTaccept(
    struct CKTcircuit_tag *ckt,    /* main circuit struct */
    double     time);    /* time at which analog soln was accepted */


#endif /* EVTPROTO_HEADER */
