/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef JOBdef
#define JOBdef


#include "ifsim.h"

typedef struct sJOB{
    int JOBtype;                /* type of job */
    struct sJOB *JOBnextJob;    /* next job in list */
    IFuid JOBname;              /* name of this job */

} JOB;

#define NODOMAIN	0
#define TIMEDOMAIN	1
#define FREQUENCYDOMAIN 2
#define SWEEPDOMAIN	3

#endif /*JOBdef*/



#ifdef CKTcircuit_has_been_defined
#ifndef JOBdef_part2
#define JOBdef_part2

#ifdef IIT
typedef int (*SPICEanalysis_setParm_t)(struct CKTcircuit_tag* ckt, GENERIC *anal, int which, union uIFvalue *value);
typedef int (*SPICEanalysis_askQuest_t)(struct CKTcircuit_tag*, GENERIC *anal, int which, union uIFvalue *value);
typedef int (*SPICEanalysis_an_init_t)(struct CKTcircuit_tag*, JOB *job);
typedef int (*SPICEanalysis_an_func_t)(struct CKTcircuit_tag*, int restart);
#endif


typedef struct {
    IFanalysis public_;
    int size;
    int domain;
    int do_ic;
#ifdef IIT
    SPICEanalysis_setParm_t  setParm;
    SPICEanalysis_askQuest_t askQuest;
    SPICEanalysis_an_init_t  an_init;
    SPICEanalysis_an_func_t  an_func;
#else
    int (*(setParm))( );
    int (*(askQuest))( );
    int (*an_init)( );
    int (*an_func)( );
#endif

} SPICEanalysis;
#endif
#endif
