#ifndef MIFPROTO
#define MIFPROTO

/* ===========================================================================
FILE    MIFproto.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains ANSI C function prototypes for functions in the
    MIF package.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */



#include "MIFtypes.h"
#include "MIFdefs.h"
#include "IFsim.h"
#include "INPdefs.h"
#include "SMPdefs.h"
#include "CKTdefs.h"



extern void MIF_INP2A(
    GENERIC      *ckt,      /* circuit structure to put mod/inst structs in */
    struct sINPtables    *tab,      /* symbol table for node names, etc.            */
    struct card         *current   /* the card we are to parse                     */
);


extern char * MIFgetMod(
    GENERIC   *ckt,
    char      *name,
    struct sINPmodel  **model,
    struct sINPtables *tab
);


extern union uIFvalue * MIFgetValue(
    GENERIC   *ckt,
    char      **line,
    int       type,
    struct sINPtables *tab,
    char      **err
);


extern int MIFsetup(
    SMPmatrix             *matrix,
    struct sGENmodel      *inModel,
    CKTcircuit            *ckt,
    int                   *state
);

extern int MIFunsetup(
    struct sGENmodel      *inModel,
    CKTcircuit            *ckt
);

extern int MIFload(
    struct sGENmodel      *inModel,
    CKTcircuit    *ckt
);


extern int MIFmParam(
    int param_index,
    union uIFvalue *value,
    struct sGENmodel *inModel
);

extern int MIFask(
    CKTcircuit *ckt,
    struct sGENinstance *inst,
    int param_index,
    union uIFvalue *value,
    union uIFvalue *select
);

extern int MIFmAsk(
    CKTcircuit *ckt,
    struct sGENmodel *inModel,
    int param_index,
    union uIFvalue *value
);

extern int MIFtrunc(
    struct sGENmodel   *inModel,
    CKTcircuit *ckt,
    double     *timeStep
);

extern int MIFconvTest(
    struct sGENmodel   *inModel,
    CKTcircuit *ckt
);

extern int MIFdelete(
    struct sGENmodel *inModel,
    IFuid    name,
    struct sGENinstance  **inst
);

extern int MIFmDelete(
    struct sGENmodel **inModel,
    IFuid    modname,
    struct sGENmodel *model
);

extern void MIFdestroy(
    struct sGENmodel **inModel
);

extern char  *MIFgettok(
    InstanceHandle inst,
    char **s
);


extern char  *MIFget_token(InstanceHandle inst,
    char **s,
    Mif_Token_Type_t *type
);


extern Mif_Cntl_Src_Type_t MIFget_cntl_src_type(
    Mif_Port_Type_t in_port_type,
    Mif_Port_Type_t out_port_type
);

extern char *MIFcopy(InstanceHandle,char *);

#ifdef EWB_IIT
MIF_Init_Error_Enum EXPORT
MIF_init_xspice_instance(GENERIC* ckt,       /* circuit structure to put mod/inst structs in */
                         char const* name,   /* the name of the instance */
                         MIFmodel*   mdfast, /* the name of the model */
                         MIFinstance* fast, /* pointer to instance struct */
                         int         type,   /* the type of the model for this instance */
                                             /* the integer index into the DEVices data
                                                array for this  model */
                         struct XSPort_def*  nodes,   /* list of nodes */
                         int*           nnodes,  /* number of nodes per port */
                         int            nvnodes  /* number of ports */
                        );
#endif

#endif  /* MIFPROTO */
