#ifndef MIFTYPES
#define MIFTYPES

/* ===========================================================================
FILE    MIFtypes.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains typedefs shared by several header files in
    the MIF package.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


#include "basic.h"

/* ***************************************************************************** */


typedef int Mif_BOOLEAN_t;

#define  MIF_FALSE  0
#define  MIF_TRUE   1


typedef int Mif_Status_t;

#define  MIF_OK     0
#define  MIF_ERROR  1

/*
typedef enum {
    MIF_OK,
    MIF_ERROR,
} Mif_Status_t;
*/


/* ***************************************************************************** */


/*
 * The type of call to a code model - analog or event-driven
 */

typedef enum {
    MIF_ANALOG,         /* Analog call */
    MIF_EVENT_DRIVEN,   /* Event-driven call */
} Mif_Call_Type_t;



/*
 * Analysis type enumerations
 */

typedef enum {
    MIF_DC,                /* A DC or DCOP analysis */
    MIF_AC,                /* A swept AC analysis   */
    MIF_TRAN,              /* A transient analysis  */
} Mif_Analysis_t;



/*
 * Port type enumerations
 */

typedef enum {
    MIF_VOLTAGE,                /* v - Single-ended voltage */
    MIF_DIFF_VOLTAGE,           /* vd - Differential voltage */
    MIF_CURRENT,                /* i - Single-ended current */
    MIF_DIFF_CURRENT,           /* id - Differential current */
    MIF_VSOURCE_CURRENT,        /* vnam - Voltage source current */
    MIF_CONDUCTANCE,            /* g - Single-ended VCIS */
    MIF_DIFF_CONDUCTANCE,       /* gd - Differential VCIS */
    MIF_RESISTANCE,             /* h - Single-ended ICVS */
    MIF_DIFF_RESISTANCE,        /* hd - Differential ICVS */
    MIF_DIGITAL,                /* d - Digital */
    MIF_USER_DEFINED,           /* <identifier> - Any user defined type */
} Mif_Port_Type_t;



/*
 * The direction of a connector
 */

typedef enum {
    MIF_IN,                    /* Input only */
    MIF_OUT,                   /* Output only */
    MIF_INOUT,                 /* Input and output (e.g. g or h type) */
} Mif_Dir_t;



/*
 * The type of a parameter
 */

typedef enum {

    MIF_BOOLEAN,
    MIF_INTEGER,
    MIF_REAL,
    MIF_COMPLEX,
    MIF_STRING,

} Mif_Data_Type_t;



/*
 * The type of a token
 */

typedef enum {

    MIF_LARRAY_TOK,
    MIF_RARRAY_TOK,
    MIF_LCOMPLEX_TOK,
    MIF_RCOMPLEX_TOK,
    MIF_PERCENT_TOK,
    MIF_TILDE_TOK,
    MIF_STRING_TOK,
    MIF_NULL_TOK,
    MIF_NO_TOK,

} Mif_Token_Type_t;



/* 
 * Type of controlled source
 */

typedef enum {
    MIF_VCVS,
    MIF_VCIS,
    MIF_ICVS,
    MIF_ICIS,
} Mif_Cntl_Src_Type_t;


/* ***************************************************************************** */


/*
 * Complex numbers
 */

typedef struct {

    double  real;
    double  imag;

} Mif_Complex_t;



/*
 * Values of different types used by the load, ... routines
 */

typedef union {

    Mif_BOOLEAN_t  bvalue;         /* For digital node value */
    int            ivalue;         /* For integer parameters */
    double         rvalue;         /* For spice node values and real parameters */  
    Mif_Complex_t  cvalue;         /* For complex parameters */
    char           *svalue;        /* For string parameters  */
    void           *pvalue;        /* For user defined nodes */

} Mif_Value_t;




/*
 * Values of different types used by the parser.  Note that this is a structure
 * instead of a union because we need to do initializations in the ifspec.c files for
 * the models and unions cannot be initialized in any useful way in C
 *
 */

typedef struct {

    Mif_BOOLEAN_t     bvalue;         /* For BOOLEAN values */
    int               ivalue;         /* For integer values */
    double            rvalue;         /* For real values */  
    Mif_Complex_t     cvalue;         /* For complex values */
    char              *svalue;        /* For string values  */

} Mif_Parse_Value_t;

#ifdef EWB_IIT
  // Node information about a port.
  typedef struct XSPort_def {
    int             node;
    int             is_negated;
    Mif_Port_Type_t type;
    GENERIC*        node_ptr;
    IFuid           nodeUid;
  } XSPort_def_t;

  /*
  // The following 'Mif_Port_Type_t' is used by the XSPort_def
  // structure to specify that we should use the default type for
  // the port.
  */
  #define MIF_DEFAULT_PORT ((Mif_Port_Type_t)(MIF_USER_DEFINED+1))

  /* The following are the error messages that may be returned by
   * the 'MIF_init_xspice_instance' function.
   */
  typedef enum MIF_Init_Error {
     MIF_IE_okay,
     MIF_IE_Invalid_model_type_for_A_type_device,
     MIF_IE_too_many_connections,
     MIF_IE_too_few_connections,
     MIF_IE_NULL_connection_found_where_not_allowed,
     MIF_IE_Null_found_for_connection_where_not_allowed,
     MIF_IE_too_few_ports_in_connection,
     MIF_IE_too_many_ports_in_connection,
     MIF_IE_parameter_on_model_has_no_default,
     MIF_IE_defaulted_array_parameter_must_have_associated_array_connection,
     MIF_IE_Array_parameter_size_on_model_does_not_match_connection_size,
     MIF_IE_port_type_is_invalid,
     MIF_IE_ERROR__Negation_not_allowed_on_analog_nodes,
     MIF_IE_INTERNAL_ERROR__Impossible_connection_type,
     MIF_IE_ERROR__Impossible_direction_type_in_MIF_init_inst,
     MIF_IE_unable_to_insert_instance_into_event_table
  } MIF_Init_Error_Enum;

#endif

#endif /* MIFTYPES */
