/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/

#ifndef MISC_H
#define MISC_H

#ifdef IIT
#include "spice.h"
#include "os_msdos.h"
#endif

#define BSIZE_SP      512

#ifdef HAS_EXIT1
#  define EXIT_NORMAL 1
#  define EXIT_BAD    0
#else
#  define EXIT_NORMAL 0
#  define EXIT_BAD    1
#endif

#ifdef HAS_CTYPE
#  ifndef isalpha
#    include <ctype.h>
#  endif
#endif

#define eq(a,b)  (!strcmp((a), (b)))
#define eqc(inst, a,b)  (cieq((a), (b)))
#define isalphanum(c)   (isalpha(c) || isdigit(c))
#define hexnum(c) ((((c) >= '0') && ((c) <= '9')) ? ((c) - '0') : ((((c) >= \
        'a') && ((c) <= 'f')) ? ((c) - 'a' + 10) : ((((c) >= 'A') && \
        ((c) <= 'F')) ? ((c) - 'A' + 10) : 0)))

#include "strext.h"

extern char* tmalloc(InstanceHandle inst, int num);
extern char* trealloc(InstanceHandle inst, char* str,int num);
extern void txfree(InstanceHandle inst, char* ptr);

#define tfree(inst, x)    (txfree(inst, (char*)x), x = 0)

#define alloc(inst, TYPE) ((TYPE *) tmalloc(inst, sizeof(TYPE)))

int prefix(InstanceHandle inst, char *p,char *s);
char* copy(InstanceHandle inst, char *str);
extern int substring(InstanceHandle inst, char* str,char *sub);
extern void appendc(InstanceHandle inst, char* s,char  c);
extern int scannum(InstanceHandle inst, char* str);
extern int cieq(char* p, char* s);
extern int ciprefix(InstanceHandle inst, char *p,char  *s);
extern void strtolower(InstanceHandle inst, char* str);
extern char* gettok(InstanceHandle inst, char **s);

extern char *tilde_expand(InstanceHandle inst, char *string);
extern void cp_printword(InstanceHandle inst, char *string,FILE *fp);

extern char *datestring(void);
extern double EXPORT seconds(InstanceHandle inst);

extern char *smktemp(InstanceHandle inst, char* id);

/* Externs from libc */

#ifdef HAS_STDLIB
#  ifndef _STDLIB_INCLUDED
#    define _STDLIB_INCLUDED
#    include <stdlib.h>
#  endif
#endif

#ifndef IIT
#ifndef HAS_BSDRAND
#  define random	rand
#  define srandom	srand
#endif
#endif

#ifdef HAS_DOSDIRS
   char *getcwd( );
#endif

#ifdef HAS_BSDRAND
   #ifdef IIT
   #include <stdlib.h>
   #else
   extern long random();
   #endif
   extern void srandom();
#else
#ifndef IIT
#  define random	rand
#endif
#  define srandom	srand
#endif
#ifdef IIT
   #include <stdio.h>
   #include <stdlib.h>
#else
     extern char *calloc();
     extern char *malloc();
     extern char *realloc();
     extern char *getenv();
     extern int errno;
     extern char *sys_errlist[];
     extern char *getenv();
     extern char *getwd();
     extern int rand();
     extern int srand();
     extern int atoi();
     extern int kill();
     extern int getpid();
     extern int qsort();
#endif
#ifdef notdef
     extern void exit();
#endif

#ifdef HAS_GETCWD
     extern char *getcwd( );
#endif

#ifdef HAS_CLEARERR
#  ifndef clearerr
//      extern void clearerr();
#include <stdio.h>
#  endif /* clearerr */
#endif /* HAS_CLEARERR */

#ifndef bzero
      extern int bzero(char *ptr,int num);
#endif
#ifndef bcopy
      extern void bcopy(char* from,char* to,int num);
#endif

#ifndef index
#  ifdef HAS_INDEX
      extern char* index(char *s, char c);
      extern char* rindex(char *s, char c);
#  else
#include <string.h>

#  endif
#endif

#ifndef HAS_INDEX
#  ifndef index
#    ifdef HAS_STRCHR
#      define	index	strchr
#      define	rindex	strrchr
#    endif
#  endif
#endif

#ifdef HAS_VPERROR
extern void perror();
#endif

#ifdef HAS_TIME_
#  ifdef HAS_BSDTIME
extern char *timezone();
#  endif
extern char *asctime();
extern struct tm *localtime();
#endif

#ifndef HAS_MEMAVL
#  ifdef HAS_RLIMIT_
extern char *sbrk();
#  endif
#endif

#define false 0
#define true 1

#ifdef HAS_DOSDIRS
#ifdef IIT
typedef int     DIR;
#else
typedef	int	*DIR;
#endif
struct direct {
	int	d_reclen;
	short	d_ino;
	short	d_namelen;
	char	d_name[20];
	};

#  ifdef IIT
extern DIR *opendir(char *);
extern struct direct *readdir(DIR *);
#  else
extern DIR *opendir( );
extern struct direct *readdir( );
#  endif
#endif

#endif /* MISC_H */
