/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef UTIL
#define UTIL

#include "instance.h"

/* #define MALLOC(x) calloc(1,(unsigned)(x)) */
#define MALLOC(inst, x) tmalloc(inst, (unsigned)(x))

#define ALLOC(inst, type,number)  ((type *)tmalloc(inst, (unsigned)(sizeof(type)*(number))))
#define FREE(inst, x) {if ((x)!=NULL) {txfree(inst, (char *)(x));(x) = 0;}}

#define REALLOC_SET(inst, ptr,type,number)  \
           ptr = (type*)REALLOC(inst, ptr,(unsigned)(sizeof(type)*(number)) )

/* Calloc that properly handles allocating a cleared vector. */
#define CALLOC_VEC(inst, ptr,type,number)                     \
{   int i; ptr = ALLOC(inst, type, number);                   \
    if (ptr != (type *)NULL)                            \
        for(i=(number)-1;i>=0; i--) ptr[i] = (type) 0;  \
}



#define REALLOC(inst, x,y) trealloc(inst, (char*)(x),(unsigned)(y))
#define ZERO(PTR,TYPE)  (bzero((char*)(PTR),sizeof(TYPE)))


#include <stdlib.h>
extern char *trealloc(InstanceHandle, char*,int);
extern char *tmalloc(InstanceHandle, int);

#define TRUE 1
#define FALSE 0

#ifdef DEBUG
#define DEBUGMSG(textargs) printf(textargs)
#else
#define DEBUGMSG(testargs) 
#endif

#include <math.h>

/* XXX Move these into the above ifdef someday */
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define SIGN(a,b) ( b >= 0 ? (a >= 0 ? a : - a) : (a >= 0 ? - a : a))

#define ABORT() fflush(stderr);fflush(stdout);abort();

#define ERRORMESSAGE(CODE,MESSAGE)	{					      \
    errMsg = MALLOC(inst, strlen(MESSAGE) + 1);                     \
	strcpy(errMsg, (MESSAGE));					      \
	return (CODE);							      \
	}

#define NEW(inst, TYPE)   ((TYPE *) MALLOC(inst, sizeof(TYPE)))
#define NEWN(inst, TYPE,COUNT) ((TYPE *) MALLOC(inst, sizeof(TYPE) * (COUNT)))

#define	R_NORM(A,B) {							      \
	if ((A) == 0.0) {						      \
	    (B) = 0;							      \
	} else {							      \
	    while (FABS(A) > 1.0) {					      \
		(B) += 1;						      \
		(A) /= 2.0;						      \
	    }								      \
	    while (FABS(A) < 0.5) {					      \
		(B) -= 1;						      \
		(A) *= 2.0;						      \
	    }								      \
	}								      \
    }

#endif /*UTIL*/

