#include <stdio.h>
#include <io.h>
#include <stdlib.h>

static void  usage   ( char * );
static void  clean_up( char * );
static void  make_c  ( char * );
static void  make_obj( char * );
static void  make_dll( char * );


#define  COMP_CMD  \
"cl %s.c /c /nologo /W3 /GX /O2 /MT /I..\\cmdynmod\\include\\  \
/D \"WIN32\" /D \"NDEBUG\" /D \"_WINDOWS\" /D \"INSIDE_XSPICE\" "

#define  LINK_DLL  \
"link /dll ..\\cmdynmod\\entrydll.obj %s.obj /out:%s.dll < ..\\cmdynmod\\dll.opt"



main( int argc, char *argv[] )
{
   printf( "\n   Link custom defined model to XSPICE\n" );
   if( argc != 2 ) usage( argv[0] );

   clean_up( argv[1] );
   make_c  ( argv[1] );
   make_obj( argv[1] );
   make_dll( argv[1] );

   return( 1 );
}

void usage( char *name )
{
   printf( "\n  Use: %s <model name>\n", name );
   exit( 1 );
}


void clean_up( char *model )
{
   char cmd[512];

   sprintf( cmd, "%s", model );
   _chdir( cmd );
   if( access( "ifspec.ifs", 0 ) == -1 )
   {
      printf( "\n  ERR: File ifspec.ifs was not found\n" );
      system( "cd .." );
      exit( -1 );
   }
   if( access( "cfunc.mod", 0 ) == -1 )
   {
      printf( "\n  ERR: File cfunc.mod was not found\n" );
      system( "cd .." );
      exit( -1 );
   }

   sprintf( cmd, "%s.c", model );
   if( access( cmd, 0 ) != -1 )
   {
      sprintf( cmd, "rm %s.c", model );
      system( cmd );
   }
   sprintf( cmd, "%s.dll", model );
   if( access( cmd, 0 ) != -1 )
   {
      sprintf( cmd, "rm %s.dll", model );
      system( cmd );
   }
}

void make_c( char *model )
{
   char cmd[512];

   system( "..\\cmpp -ifs" );
   system( "..\\cmpp -mod" );
   sprintf( cmd, "cat ifspec.c cfunc.c > %s.c", model );
   system( cmd );
   system( "rm cfunc.c ifspec.c" );

   sprintf( cmd, "%s.c", model );
   if( access( cmd, 0 ) == -1 )
   {
      printf( "\n  ERR: Cannot create file %s\n", cmd );
      system( "cd .." );
      exit( -1 );
   }
}

void make_obj( char *model )
{
   char cmd[512];

   sprintf( cmd, COMP_CMD, model );
   system( cmd );
   sprintf( cmd, "%s.obj", model );
   if( access( cmd, 0 ) == -1 )
   {
      printf( "\n  ERR: Cannot create file %s\n", cmd );
      system( "cd .." );
      exit( -1 );
   }
}

void make_dll( char *model )
{
   char cmd[512];

   sprintf( cmd, LINK_DLL, model, model );
   system( cmd );

   sprintf( cmd, "%s.dll", model );
   if( access( cmd, 0 ) == -1 )
   {
      printf( "\n  ERR: Cannot create file %s\n", cmd );
      system( "cd .." );
      exit( -1 );
   }
   else
   {
      system( "rm *.obj *.lib *.exp" );
      printf( "\n   %s was done\n", cmd );
      system( "cd .." );
   }
}
