/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CKT
#define CKT "CKTdefs.h $Revision: 1.13 $  on $Date: 89/04/05 13:09:39 $ "
  #ifdef _DEBUG
  #ifdef _MSC_VER
  #pragma message( "  parsing CKTdefs.H" )
  #endif /*_MSC_VER*/
  #endif /*_DEBUG*/

  #include "basic.h"
  #include "xspice.h"

  #ifdef XSPICE
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
    #include "EVT.h"
    #include "ENH.h"
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
  #endif


  #define MAXNUMDEVS 32
  extern int DEVmaxnum;
  #define MAXNUMDEVNODES 4

  #include "smpdefs.h"
  #include "ifsim.h"
  #include "acdefs.h"
  #include "gendefs.h"
  #include "trcvdefs.h"
  #include "optdefs.h"
  #include "sen2defs.h"
  #include "pzdefs.h"



  typedef struct sCKTnode {
      IFuid name;
      int type;

      #define SP_VOLTAGE 3
      #define SP_CURRENT 4
      #define NODE_VOLTAGE SP_VOLTAGE
      #define NODE_CURRENT SP_CURRENT

      int number;
      double ic;
      double nodeset;
      double *ptr;
      struct sCKTnode *next;
      unsigned int icGiven:1;
      unsigned int nsGiven:1;
  } CKTnode;

  /* defines for node parameters */
  #define PARM_NS 1
  #define PARM_IC 2
  #define PARM_NODETYPE 3


  struct CKTcircuit_tag {
     #ifdef IIT
         InstanceHandle m_instance_handle;
     #endif

     #ifdef XSPICE
     /* gtri - begin - wbk - change declaration to allow dynamic sizing */

     /* An associated change is made in CKTinit.c to alloc the space */
     /* required for the pointers.  No changes are needed to the source */
     /* code at the 3C1 level, although the compiler will generate */
     /* slightly different code for references to this data. */

     /*  GENmodel *CKThead[MAXNUMDEVS];  */
         struct sGENmodel **CKThead;

     /* gtri - end   - wbk - change declaration to allow dynamic sizing */
     #else
         struct sGENmodel *CKThead[MAXNUMDEVS];
     #endif
         STATistics *CKTstat;
         double *(CKTstates[8]);
     #define CKTstate0 CKTstates[0]
     #define CKTstate1 CKTstates[1]
     #define CKTstate2 CKTstates[2]
     #define CKTstate3 CKTstates[3]
     #define CKTstate4 CKTstates[4]
     #define CKTstate5 CKTstates[5]
     #define CKTstate6 CKTstates[6]
     #define CKTstate7 CKTstates[7]
         double CKTtime;
         double CKTdelta;
         double CKTdeltaOld[7];
         double CKTtemp;
         double CKTnomTemp;
         double CKTvt;
         double CKTag[7];        /* the gear variable coefficient matrix */
     #ifdef PREDICTOR
         double CKTagp[7];       /* the gear predictor variable coefficient matrix */
     #endif /*PREDICTOR*/
         int CKTorder;           /* the integration method order */
         int CKTmaxOrder;        /* maximum integration method order */
         int CKTintegrateMethod; /* the integration method to be used */

     /* known integration methods */
     #define TRAPEZOIDAL 1
     #define GEAR 2

         SMPmatrix *CKTmatrix;   /* pointer to sparse matrix */
         int CKTniState;         /* internal state */
         double *CKTrhs;         /* current rhs value - being loaded */
         double *CKTrhsOld;      /* previous rhs value for convergence testing */
         double *CKTrhsSpare;    /* spare rhs value for reordering */
         double *CKTirhs;        /* current rhs value - being loaded (imag) */
         double *CKTirhsOld;     /* previous rhs value (imaginary)*/
         double *CKTirhsSpare;   /* spare rhs value (imaginary)*/
     #ifdef PREDICTOR
         double *CKTpred;        /* predicted solution vector */
         double *CKTsols[8];     /* previous 8 solutions */
     #endif /* PREDICTOR */

         double *CKTrhsOp;      /* operating point values */
         double *CKTsenRhs;      /* current sensitivity rhs  values */
         double *CKTseniRhs;      /* current sensitivity rhs  values (imag)*/


     /*
      *  symbolic constants for CKTniState
      *      Note that they are bitwise disjoint
      */

     #define NISHOULDREORDER 0x1
     #define NIREORDERED 0x2
     #define NIUNINITIALIZED 0x4
     #define NIACSHOULDREORDER 0x10
     #define NIACREORDERED 0x20
     #define NIACUNINITIALIZED 0x40
     #define NIDIDPREORDER 0x100
     #define NIPZSHOULDREORDER 0x200

         int CKTmaxEqNum;
         int CKTcurrentAnalysis; /* the analysis in progress (if any) */

     /* defines for the value of  CKTcurrentAnalysis */
     /* are in TSKdefs.h */

         CKTnode *CKTnodes;
         CKTnode *CKTlastNode;
     #define NODENAME(ckt,nodenum) CKTnodName(ckt,nodenum)
         int CKTnumStates;
         long CKTmode;

     /* defines for CKTmode */

     /* old 'mode' parameters */
     #define MODE 0x3
     #define MODETRAN 0x1
     #define MODEAC 0x2

     /* old 'modedc' parameters */
     #define MODEDC 0x70
     #define MODEDCOP 0x10
     #define MODETRANOP 0x20
     #define MODEDCTRANCURVE 0x40

     /* old 'initf' parameters */
     #define INITF 0x3f00
     #define MODEINITFLOAT 0x100
     #define MODEINITJCT 0x200
     #define MODEINITFIX 0x400
     #define MODEINITSMSIG 0x800
     #define MODEINITTRAN 0x1000
     #define MODEINITPRED 0x2000

     /* old 'nosolv' paramater */
     #define MODEUIC 0x10000l

         int CKTbypass;
         int CKTdcMaxIter;       /* iteration limit for dc op.  (itl1) */
         int CKTdcTrcvMaxIter;   /* iteration limit for dc tran. curv (itl2) */
         int CKTtranMaxIter;     /* iteration limit for each timepoint for tran*/
                                 /* (itl4) */
         int CKTbreakSize;
         int CKTbreak;
         double CKTsaveDelta;
         double CKTminBreak;
         double *CKTbreaks;
         double CKTabstol;
         double CKTpivotAbsTol;
         double CKTpivotRelTol;
         double CKTreltol;
         double CKTchgtol;
         double CKTvoltTol;
     #ifdef NEWTRUNC
         double CKTlteReltol;
         double CKTlteAbstol;
     #endif /* NEWTRUNC */
         double CKTgmin;
         double CKTdelmin;
         double CKTtrtol;
         double CKTfinalTime;
         double CKTstep;
         double CKTmaxStep;
         double CKTinitTime;
         double CKTomega;
         double CKTsrcFact;
         double CKTdiagGmin;
         int CKTnumSrcSteps;
         int CKTnumGminSteps;
         int CKTnoncon;
         double CKTdefaultMosL;
         double CKTdefaultMosW;
         double CKTdefaultMosAD;
         double CKTdefaultMosAS;
         unsigned int CKThadNodeset:1;
         unsigned int CKTfixLimit:1; /* flag to indicate that the limiting of
                                      * MOSFETs should be done as in SPICE2 */
         unsigned int CKTnoOpIter:1; /* flag to indicate not to try the operating
                                      * point brute force, but to use gmin stepping
                                      * first */
         unsigned int CKTisSetup:1;  /* flag to indicate if CKTsetup done */
         JOB *CKTcurJob;

         SENstruct *CKTsenInfo;	/* the sensitivity information */
         double *CKTtimePoints;	/* list of all accepted timepoints in the
				        current transient simulation */
         double *CKTdeltaList;	/* list of all timesteps in the current
				        transient simulation */
         int CKTtimeListSize;	/* size of above lists */
         int CKTtimeIndex;		/* current position in above lists */
         int CKTsizeIncr;		/* amount to increment size of above arrays
				        when you run out of space */
         unsigned int CKTtryToCompact:1; /* try to compact past history for LTRA
				        lines */
         unsigned int CKTbadMos3:1; /* Use old, unfixed MOS3 equations */
         unsigned int CKTkeepOpInfo:1; /* flag for small signal analyses */
         int CKTtroubleNode;		/* Non-convergent node number */
         struct sGENinstance *CKTtroubleElt;	/* Non-convergent device instance */
     #ifdef EWB_IIT
	     double CKTiitBreakPoint;
	     double CKTiitSaveDelta;
     #endif
     #ifdef XSPICE
     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */

         struct Evt_Ckt_Data_s *evt;  /* all data about event driven stuff */
         struct Enh_Ckt_Data_t *enh;  /* data used by general enhancements */

     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
     #endif
     #ifdef IIT
         int oldCKTmaxEqNum;
     #endif

#ifdef IIT
     //* Transient analysis options
     #define EXT_MODE_ZERO_IC    0x00000l
     #define EXT_MODE_AUTO_IC    0x000002
     #define EXT_MODE_AUTO_TMAX  0x000004
     #define EXT_MODE_AUTO_TSTEP 0x000008
     long CKText_mode;
#endif
  };

  #ifdef IIT
    #define CKTcircuit_has_been_defined
    #include "jobdefs.h"

    struct s_sgen* sgen_init(CKTcircuit* ckt,int is_dc);
    int sgen_next(InstanceHandle INST, struct s_sgen **xsg);
    int sens_getp(InstanceHandle INST, struct s_sgen *sg, CKTcircuit *ckt,union uIFvalue* val);
  #endif

  #ifdef EWB_IIT
    int EXPORT getMatrixElement( GENERIC*, GENERIC*, GENERIC*, double**);
    int EXPORT getVoltage(GENERIC*, GENERIC*, GENERIC*, double*);
    int EXPORT addVoltage(GENERIC*, GENERIC*, double);
    int EXPORT getCurrent(GENERIC*, GENERIC*, double*);
    int EXPORT addCurrent(GENERIC*, GENERIC*, GENERIC*, double);
    int EXPORT setBreakPoint(GENERIC*, double);
    int EXPORT setRelativeBreakPoint(GENERIC*, double);
    int EXPORT changeCapacitorValue(GENERIC*, GENERIC*, double);
    int EXPORT changeInductorValue(GENERIC*, GENERIC*, double);
    int EXPORT isFirstIteration(GENERIC*, int*);
    int EXPORT setMaxStep(GENERIC*, double);
  #endif

  #ifdef DLL
    #if defined(MSVC) || !defined(WIN32)
      #undef FAR
    #endif

    #include <windows.h>

    #if defined(MSVC)
      #undef FAR
      #define FAR
	#elif !defined(WIN32)
      #undef FAR
      #define FAR far
    #endif

    #ifdef MSVC
      int EXPORT  SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #else
      int CALLBACK _export SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #endif
  #else
    int SPIinit(InstanceHandle inst);
  #endif

  int ACan(CKTcircuit *, int );
  int ACaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int ACsetParm( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int CKTacDump( CKTcircuit *, double , GENERIC *);
  int CKTacLoad( CKTcircuit *);
  int CKTaccept( CKTcircuit *);
  int CKTacct( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int EXPORT CKTask( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskAnalQ( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskNodQst( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTbindNode( GENERIC *, GENERIC *, int , GENERIC *);
  void CKTbreakDump( CKTcircuit *);
  int CKTclrBreak( CKTcircuit *);
  int CKTconvTest( CKTcircuit *);
  int EXPORT CKTcrtElt( GENERIC *, GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTdelTask( GENERIC *, GENERIC *);
  int EXPORT CKTdestroy( GENERIC *);
  int CKTdltAnal( GENERIC *, GENERIC *, GENERIC *);
  int EXPORT CKTdltInst( GENERIC *, GENERIC *);
  int EXPORT CKTdltMod( GENERIC *, GENERIC *);
  int EXPORT CKTdltNod( GENERIC *, GENERIC *);
  int EXPORT CKTdoJob( GENERIC *, int , GENERIC *);
  void CKTdump( CKTcircuit *, double, GENERIC *);
  int EXPORT CKTfndAnal( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int CKTfndBranch( CKTcircuit *, IFuid);
  int EXPORT CKTfndDev( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int EXPORT CKTfndMod( GENERIC *, int *, GENERIC **, IFuid );
  int EXPORT CKTfndNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTfndTask( GENERIC *, GENERIC **, IFuid  );
  int EXPORT CKTground( GENERIC *, GENERIC **, IFuid );
  int CKTic( CKTcircuit *);
  int EXPORT CKTinit(InstanceHandle handle, GENERIC **);
  int EXPORT CKTinst2Node( GENERIC *, GENERIC *, int , GENERIC **, IFuid *);
  int CKTlinkEq(CKTcircuit*,CKTnode*);
  int CKTload( CKTcircuit *);
  int CKTmapNode( GENERIC *, GENERIC **, IFuid );
  int CKTmkCur( CKTcircuit  *, CKTnode **, IFuid , char *);
  int CKTmkNode(CKTcircuit*,CKTnode**);
  int CKTmkVolt( CKTcircuit  *, CKTnode **, IFuid , char *);
  int EXPORT CKTmodAsk( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTmodCrt( GENERIC *, int , GENERIC **, IFuid );
  int EXPORT CKTmodParam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTnames(CKTcircuit *, int *, IFuid **);
  int EXPORT CKTnewAnal( GENERIC *, int , IFuid , GENERIC **, GENERIC *);
  int CKTnewEq( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewTask( GENERIC *, GENERIC **, IFuid );
  IFuid CKTnodName( CKTcircuit *, int );
  void CKTnodOut( CKTcircuit *);
  CKTnode * CKTnum2nod( CKTcircuit *, int );
  int CKTop(CKTcircuit *, long, long, int );
  int CKTpModName( char *, union uIFvalue *, CKTcircuit *, int , IFuid , struct sGENmodel **);
  int CKTpName( char *, union uIFvalue *, CKTcircuit *, int , char *, struct sGENinstance **);
  int EXPORT CKTparam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTpzFindZeros( CKTcircuit *, PZtrial **, int * );
  int CKTpzLoad( CKTcircuit *, SPcomplex * );
  int CKTpzSetup( CKTcircuit *, int);
  int CKTsenAC( CKTcircuit *);
  int CKTsenComp( CKTcircuit *);
  int CKTsenDCtran( CKTcircuit *);
  int CKTsenLoad( CKTcircuit *);
  void CKTsenPrint( CKTcircuit *);
  int CKTsenSetup( CKTcircuit *);
  int CKTsenUpdate( CKTcircuit *);
  int EXPORT CKTsetAnalPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetBreak( CKTcircuit *, double );
  int EXPORT CKTsetNodPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetOpt( GENERIC *, GENERIC *, int , union uIFvalue *);
  int CKTsetup( CKTcircuit *);
  int CKTunsetup(CKTcircuit *ckt);
  int CKTtemp( CKTcircuit *);
  char * EXPORT CKTtrouble(GENERIC *, char *);
  void CKTterr( int , CKTcircuit *, double *);
  int CKTtrunc( CKTcircuit *, double *);
  int CKTtypelook( char *);
  int DCOaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCOsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCTaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCTsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCop(CKTcircuit *);
  int DCtrCurv(CKTcircuit *, int );
  int DCtran(CKTcircuit *, int );
  int DISTOan(CKTcircuit *, int);
  int NOISEan(CKTcircuit *, int);
  int PZan(CKTcircuit *, int );
  int PZinit(CKTcircuit * );
  int PZpost(CKTcircuit * );
  int PZaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int PZsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  void SENdestroy(InstanceHandle, SENstruct *);
  int SENsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENstartup(CKTcircuit *);
  char* SPerror(InstanceHandle INST, int type);
  int TFanal(CKTcircuit *, int );
  int TFaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TFsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANinit(CKTcircuit *, JOB *);
  int NIacIter(CKTcircuit * );
  int NIcomCof(CKTcircuit * );
  int NIconvTest(CKTcircuit * );
  void NIdestroy(CKTcircuit * );
  int NIinit(CKTcircuit  * );
  int NIintegrate(CKTcircuit *, double *, double *, double , int );
  int NIiter(CKTcircuit * , int );
  int NIpzMuller(InstanceHandle, PZtrial **, PZtrial *);
  int NIpzComplex(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym2(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIreinit(CKTcircuit *);
  int NIsenReinit(CKTcircuit *);
  int EXPORT isFirstIteration (GENERIC *inCkt, int *first_iteration);

  #ifdef EWB_IIT
    int EXPORT modelInitialize(InstanceHandle INST, int modelType,GENERIC* model, IFuid modelUid);
  #endif

  #include "noisedef.h"

  int CKTnoise (CKTcircuit *ckt,int mode, int operation, Ndata *data);
  int CKTdisto(CKTcircuit *ckt,int mode);
  int NIdIter(CKTcircuit *ckt);
  void NInzIter(CKTcircuit *ckt, int posDrive, int negDrive);
#ifndef IIT
  extern struct sIFfrontEnd *SPfrontEnd;
#endif

#ifndef IIT
#ifdef DO_RAWFILE_ALSO
  extern struct sIFfrontEnd *EWB_frontEnd;
  extern struct sIFfrontEnd nutmeginfo;
#endif /* DO_RAWFILE_ALSO */
#endif

#endif /*CKT*/
