/* -------------------------------------------
**
** function pointers table for call from user 
** defined model DLL 
*/

#ifndef IFuid
	#define IFuid void*
#endif

typedef struct FT 
{
	int   (*MIFsetup)(struct MatrixFrame*, struct sGENmodel*,
					  struct CKTcircuit_tag*, int*);
	int   (*MIFunsetup)(struct sGENmodel*, struct CKTcircuit_tag*);
	int   (*MIFload)(struct sGENmodel*, struct CKTcircuit_tag*);
	int   (*MIFmParam)(int, union uIFvalue*, struct sGENmodel*);
	int   (*MIFask)(struct CKTcircuit_tag*, struct sGENinstance *, int,
					union uIFvalue*, union uIFvalue*);
	int   (*MIFmAsk)(struct CKTcircuit_tag*, struct sGENmodel*, int,
					union uIFvalue*);
	int   (*MIFtrunc)(struct sGENmodel*, struct CKTcircuit_tag*, double*);
	int   (*MIFconvTest)(struct sGENmodel*, struct CKTcircuit_tag*);
	int   (*MIFdelete)(struct sGENmodel*, IFuid, struct sGENinstance**);
	int   (*MIFmDelete)(struct sGENmodel**, IFuid, struct sGENmodel*);
	void  (*MIFdestroy)(struct sGENmodel**);
	void  (*cm_event_alloc)(struct Instance*, int, int);
	void *(*cm_event_get_ptr)(struct Instance*, int, int);
	void (*cm_climit_fcn)(double in, double in_offset, double cntl_upper, 
                   double cntl_lower, double lower_delta, 
                   double upper_delta, double limit_range, 
                   double gain, int percent, double *out_final,
                   double *pout_pin_final, double *pout_pcntl_lower_final,
                   double *pout_pcntl_upper_final);
	void (*cm_smooth_corner)(double x_input, double x_center, double y_center,
                 double domain, double lower_slope, double upper_slope,
                 double *y_output, double *dy_dx);
	void (*cm_smooth_discontinuity)(double x_input, double x_lower, double y_lower,
                 double x_upper, double y_upper,
                 double *y_output, double *dy_dx);
	double (*cm_smooth_pwl)(double x_input, double *x, double *y, int size,
               double input_domain, double *dout_din);
	double (*cm_analog_ramp_factor)(InstanceHandle inst);
	void (*cm_analog_alloc)(InstanceHandle inst,int tag, int bytes);
	void *(*cm_analog_get_ptr)(InstanceHandle inst,int tag, int timepoint);
	int  (*cm_analog_integrate)(InstanceHandle inst,double integrand, double *integral, double *partial);
	int  (*cm_analog_converge)(InstanceHandle inst,double *state);
	int  (*cm_analog_set_temp_bkpt)(InstanceHandle inst,double time);
	int  (*cm_analog_set_perm_bkpt)(InstanceHandle inst,double time);
	void (*cm_analog_not_converged)(InstanceHandle inst);
	void (*cm_analog_auto_partial)(InstanceHandle inst);
	int  (*cm_event_queue)(InstanceHandle inst,double time);
	char *(*cm_message_get_errmsg)(InstanceHandle inst);
	int  (*cm_message_send)(InstanceHandle inst,char *msg);
	double (*cm_netlist_get_c)(InstanceHandle inst);
	double (*cm_netlist_get_l)(InstanceHandle inst);
	Complex_t (*cm_complex_set)(double real, double imag);
	Complex_t (*cm_complex_add)(Complex_t x, Complex_t y);
	Complex_t (*cm_complex_subtract)(Complex_t x, Complex_t y);
	Complex_t (*cm_complex_multiply)(Complex_t x, Complex_t y);
	Complex_t (*cm_complex_divide)(Complex_t x, Complex_t y);
} FuncTable;
