/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef INP
#define INP

    /* structure declarations used by either/both input package */

#include "ifsim.h"
#include "gendefs.h"
#include "inpptree.h"

struct INPtab {
    char *t_ent;
    struct INPtab *t_next;
};

struct INPnTab {
    char *t_ent;
    GENERIC* t_node;
    struct INPnTab *t_next;
};

typedef struct sINPtables{
    struct INPtab **INPsymtab;
    struct INPnTab **INPtermsymtab;
    int INPsize;
    int INPtermsize;
    GENERIC *defAmod;
    GENERIC *defBmod;
    GENERIC *defCmod;
    GENERIC *defDmod;
    GENERIC *defEmod;
    GENERIC *defFmod;
    GENERIC *defGmod;
    GENERIC *defHmod;
    GENERIC *defImod;
    GENERIC *defJmod;
    GENERIC *defKmod;
    GENERIC *defLmod;
    GENERIC *defMmod;
    GENERIC *defNmod;
    GENERIC *defOmod;
    GENERIC *defPmod;
    GENERIC *defQmod;
    GENERIC *defRmod;
    GENERIC *defSmod;
    GENERIC *defTmod;
    GENERIC *defUmod;
    GENERIC *defVmod;
    GENERIC *defWmod;
    GENERIC *defYmod;
    GENERIC *defZmod;
} INPtables;

typedef struct card{
    int linenum;
    char *line;
    char *error;
    struct card *nextcard;
    struct card *actualLine;
} card;

/* structure used to save models in after they are read during pass 1 */
typedef struct sINPmodel{
    IFuid INPmodName;   /* uid of model */
    int INPmodType;     /* type index of device type */
    struct sINPmodel *INPnextModel;  /* link to next model */
    int INPmodUsed;     /* flag to indicate it has already been used */
    card *INPmodLine;   /* pointer to line describing model */
    GENERIC *INPmodfast;   /* high speed pointer to model for access */
} INPmodel;

/* listing types - used for debug listings */
#define LOGICAL 1
#define PHYSICAL 2

int EXPORT IFnewUid(GENERIC*,IFuid*,IFuid,char*,int,GENERIC**);
int EXPORT IFdelUid(GENERIC*,IFuid,int);
int INPaName(InstanceHandle inst, char*,union uIFvalue*,GENERIC*,int*,char*,GENERIC**,struct sIFsimulator*,int*,
        union uIFvalue*);
int INPapName(GENERIC*,int,GENERIC*,char*,union uIFvalue*);
void INPcaseFix(InstanceHandle inst, char*);
char * INPdevParse(InstanceHandle inst, char**,GENERIC*,int,GENERIC*,double*,int*,INPtables*);
char *INPdomodel(InstanceHandle inst, GENERIC *,card*, INPtables*);
void INPdoOpts(InstanceHandle inst, GENERIC*,GENERIC*,card*,INPtables*);
#ifdef XSPICE_BUILD
char *INPerrCat(InstanceHandle inst, char *, char *);
#endif
char *INPerror(InstanceHandle inst, int type);
double INPevaluate(InstanceHandle inst, char**,int*,int);
char * INPfindLev(InstanceHandle inst, char*,int*);
char * INPgetMod(InstanceHandle inst, GENERIC*,char*,INPmodel**,INPtables*);
int INPgetTok(InstanceHandle inst, char**,char**,int);
void INPgetTree(InstanceHandle inst, char**,INPparseTree**,GENERIC*,INPtables*);
union uIFvalue * INPgetValue(InstanceHandle inst, GENERIC*,char**,int,INPtables*);
int INPgndInsert(InstanceHandle inst, GENERIC*,char**,INPtables*,GENERIC**);
int INPinsert(InstanceHandle inst, char**,INPtables*);
int INPremove(InstanceHandle inst, char*,INPtables*);
int INPlookMod(InstanceHandle inst, char*);
int INPmakeMod(InstanceHandle inst, char*,int,card*);
#ifdef XSPICE_BUILD
char *INPmkTemp(InstanceHandle inst, char*);
#endif
void INPpas1(InstanceHandle inst, GENERIC*,card*,INPtables*);
void INPpas2(InstanceHandle inst, GENERIC*,card*,INPtables*,GENERIC *);
int INPpName(InstanceHandle inst, char*,union uIFvalue*,GENERIC*,int,GENERIC*);
int INPtermInsert(InstanceHandle inst, GENERIC*,char**,INPtables*,GENERIC**);
int INPmkTerm(InstanceHandle inst, GENERIC*,char**,INPtables*,GENERIC**);
int INPtypelook(InstanceHandle,char*);
void INP2B(GENERIC*,INPtables*,card*);
void INP2C(GENERIC*,INPtables*,card*);
void INP2D(GENERIC*,INPtables*,card*);
void INP2E(GENERIC*,INPtables*,card*);
void INP2F(GENERIC*,INPtables*,card*);
void INP2G(GENERIC*,INPtables*,card*);
void INP2H(GENERIC*,INPtables*,card*);
void INP2I(GENERIC*,INPtables*,card*);
void INP2J(GENERIC*,INPtables*,card*);
void INP2K(GENERIC*,INPtables*,card*);
void INP2L(GENERIC*,INPtables*,card*);
void INP2M(GENERIC*,INPtables*,card*);
void INP2O(GENERIC*,INPtables*,card*);
void INP2Q(GENERIC*,INPtables*,card*,GENERIC*);
void INP2R(GENERIC*,INPtables*,card*);
void INP2S(GENERIC*,INPtables*,card*);
void INP2T(GENERIC*,INPtables*,card*);
void INP2U(GENERIC*,INPtables*,card*);
void INP2V(GENERIC*,INPtables*,card*);
void INP2W(GENERIC*,INPtables*,card*);
void INP2Z(GENERIC*,INPtables*,card*);
int INP2dot(GENERIC*,INPtables*,card*,GENERIC*,GENERIC*);
INPtables *INPtabInit(InstanceHandle inst, int);
void INPkillMods(InstanceHandle inst);
void INPtabEnd(InstanceHandle inst, INPtables *);
int INPremTerm(InstanceHandle inst,char *token,INPtables *tab);
int INPgetUTok(InstanceHandle inst, char** line, char** token, int gobble);
int INPgetStr(InstanceHandle inst,char **line, char **token, int gobble);

#endif /*INP*/
