#ifndef HDR_instance_h
#define HDR_instance_h

#ifdef _DEBUG
#ifdef _MSC_VER
#pragma message( "  parsing Instance.H" )
#endif /*_MSC_VER*/
#endif /*_DEBUG*/

#include <stdio.h>
#include <string.h>

#include "confdef.h"

#ifdef __cplusplus
  #define INSTANCE_class class

  #define INSTANCE_DECLARE_CLASS_MEMBERS                     \
          friend class CSpiceSession;                     \
          friend class CSpiceCircuit;                        \
        public:                                              \
          Instance() { memset(this, 0, sizeof(*this)); }     \
          class CSpiceSession* GetSession()            \
              { return m_CNC_SpiceSimulation; }              \
          class ISpiceFrontEnd*   GetFrontEnd()              \
              { return m_CNC_SpiceFrontEnd; }                \
        private:

#else
  #define INSTANCE_class struct
  #define INSTANCE_DECLARE_CLASS_MEMBERS

#endif

  #define hInst(ckt)             ((ckt)->m_instance_handle)
  #define iGLOBAL(inst,member)   ((inst)->m_##member)
  #define cGLOBAL(ckt,member)    iGLOBAL(hInst(ckt), member)

typedef INSTANCE_class Instance
{

INSTANCE_DECLARE_CLASS_MEMBERS

    struct sIFfrontEnd*  m_CNC_frontEnd;    // NEW
    struct sIFfrontEnd*  m_SPfrontEnd;      // Replaces SPfrontEnd
    struct sIFsimulator* m_ft_sim;          // Replaces ft_sim
    struct circ*         m_ft_curckt;       // Replaces ft_curckt
    struct circ*         m_ft_circuits;     // Replaces ft_circuits
    struct subcirc*      m_ft_subcircuits;  // Replaces ft_subcircuits
    char*                m_ft_rawfile;      // Replaces ft_rawfile
    struct Mif_Info_s*   m_g_mif_info;      // Replaces g_mif_info

    char* m_errMsg;    /* descriptive message about what went wrong */
                       /* MUST be malloc()'d - front end will free() */
                       /* this should be a detailed message,and is assumed */
                       /* malloc()'d so that you will feel free to add */
                       /* lots of descriptive information with sprintf*/

    char* m_errRtn;    /* name of the routine declaring error */
                       /* should not be malloc()'d, will not be free()'d */
                       /* This should be a simple constant in your routine */
                       /* and thus can be set correctly even if we run out */
                       /* of memory */

    /******************************************************************/
    /******************************************************************/
    // NUTMEG COMMAND STACK, used for nested "while", "if", and other
    // "scoped" structures.
    /******************************************************************/
      /* We have to keep the control structures in a stack, so that when
       * we do a 'source', we can push a fresh set onto the top...
       * Actually there have to be two stacks -- one for the pointer
       * to the list of control structs, and one for the 'current command'
       * pointer...
       */

      #define CONTROLSTACKSIZE 256    /* Better be enough. */
      struct control* m_control[CONTROLSTACKSIZE];
      struct control* m_cend[CONTROLSTACKSIZE];
      int             m_stackp;
      int             m_level_indent;
    /*----------------------------------------------------------------*/
    /*----------------------------------------------------------------*/

    /******************************************************************/
    /******************************************************************/
    // Data associated with the CNC.
    /******************************************************************/
    INSTANCE_class CSpiceSession* m_CNC_SpiceSimulation; // CNC's interface to m_CNC_frontEnd
    INSTANCE_class ISpiceFrontEnd*   m_CNC_SpiceFrontEnd;   // CNC's interface to m_ft_sim
    /*----------------------------------------------------------------*/
    /*----------------------------------------------------------------*/

    /******************************************************************/
    /******************************************************************/
    // Data associated with rawfile reading/writing.
    /******************************************************************/
    FILE *m_rawfileFp;
    int   m_rawfileBinary;
    /*----------------------------------------------------------------*/
    /*----------------------------------------------------------------*/


} Instance;

typedef void GENERIC;
typedef Instance* InstanceHandle;
typedef GENERIC *IFuid;


#undef INSTANCE_class

  typedef enum ANALYSIS_TYPE {
      AT_NONE,
      AT_DC_OP,
      AT_AC,
      AT_TRAN,
      AT_NOISE,
      AT_DISTO,
      AT_PZ,
      AT_TF,
      AT_SENS,
      AT_DC_SWEEP,
      NUM_ANALYSIS_TYPES
  } ANALYSIS_TYPE;

  typedef enum NODE_TYPE {
      NT_NOTYPE,
      NT_TIME,
      NT_FREQUENCY,
      NT_VOLTAGE,
      NT_CURRENT,
      NT_ONOISE_SPECTRUM,
      NT_ONOISE_INTEGRATED,
      NT_INOISE_SPECTRUM,
      NT_INOISE_INTEGRATED,
      NT_OUTPUT_NOISE,
      NT_INPUT_NOISE,
      NT_POLE,
      NT_ZERO,
      NT_S_PARAM,
      NT_NUM_TYPES
  } NODE_TYPE;

  typedef struct AnalysisNode {
      NODE_TYPE      m_node_type;
      IFuid           m_name;
  } AnalysisNode;

  typedef enum COMPONENT_TYPES {
      CT_NONE                = 0x0000,
      CT_VOLTAGE             = 0x0001,
      CT_CURRENT             = 0x0002,
      CT_SPICE_COMPONENT     = 0x0004,
      CT_XSPICE_COMPONENT    = 0x0008,
      CT_ANALOG_COMPONENT    = 0x0010,
      CT_DIGITAL_COMPONENT   = 0x0020,
      CT_NOISE_SOURCE        = 0x0040,
      CT_ACTIVE              = 0x0080,
      CT_PASSIVE             = 0x0100,
      CT_INDEPENDENT_VOLTAGE = 0x0200,
      CT_INDEPENDENT_CURRENT = 0x0400,
      CT_ALL                 = ~CT_NONE
  } COMPONENT_TYPES;

  typedef struct AnalysisComponents {
      COMPONENT_TYPES      m_component_types ;
      char const*          m_name ;
      struct sGENinstance* m_instance ;
  } AnalysisComponents;


  typedef enum AnalysisParameterType
  {
     APT_EXECUTE_SETUP,   //* ANALYSIS_TYPE, this is the analysis to perform setup
     APT_EXECUTE,         //* ANALYSIS_TYPE, this is the analysis to perform

     //* General analysis
     APT_RSHUNT,          //* (optional) double
     APT_SAVE,            //* (optional) string

     //* AC analysis
     APT_AC_SWEEP_TYPE,   //* string (LIN | OCT | DEC)
     APT_AC_POINTS_VALUE, //* double
     APT_AC_START_FREQ,   //* double
     APT_AC_END_FREQ,     //* double

     //* Transient analysis
     APT_TRAN_TSTEP,      //* double
     APT_TRAN_TSTOP,      //* double
     APT_TRAN_TSTART,     //* (optional) double (default 0)
     APT_TRAN_TMAX,       //* (optional) double
     APT_TRAN_UIC,        //* (optional) string
  } AnalysisParameterType;


#endif
