#ifndef SMP
#define SMP

#ifdef IIT
typedef  struct MatrixFrame SMPmatrix;
#else
typedef  char SMPmatrix;
#endif

typedef  struct MatrixElement  *SMPelement;

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#include "complex.h"
#include <stdio.h>

#ifdef IIT

#ifndef MatrixFrame_defined
#define MatrixFrame_defined
typedef  struct MatrixFrame* MatrixPtr;
#endif

#include "sensgen.h"

int SMPcAddCol(InstanceHandle inst,  MatrixPtr Matrix, int Accum_Col, int Addend_Col );
int SMPcZeroCol(InstanceHandle inst, MatrixPtr Matrix, int Col);
int SMPcDProd(InstanceHandle inst, SMPmatrix *Matrix,SPcomplex *pMantissa,int *pExponent);
#endif

int SMPaddElt(InstanceHandle inst,  SMPmatrix *, int , int , double );
void SMPcClear(InstanceHandle inst,  SMPmatrix *);
int SMPcLUfac(InstanceHandle inst,  SMPmatrix *, double );
int SMPcProdDiag(InstanceHandle inst,  SMPmatrix *, SPcomplex *, int *);
int SMPcReorder(InstanceHandle inst,  SMPmatrix * , double , double , int *);
void SMPcSolve(InstanceHandle inst,  SMPmatrix *, double [], double [], double [], double []);
void SMPclear(InstanceHandle inst,  SMPmatrix *);
void SMPcolSwap(InstanceHandle inst,  SMPmatrix * , int , int );
void SMPdestroy(InstanceHandle inst,  SMPmatrix *);
int SMPfillup(InstanceHandle inst,  SMPmatrix * );
SMPelement * SMPfindElt(InstanceHandle inst,  SMPmatrix *, int , int , int );
void SMPgetError(InstanceHandle inst,  SMPmatrix *, int *, int *);
int SMPluFac(InstanceHandle inst,  SMPmatrix *, double , double );
double * SMPmakeElt(InstanceHandle inst,  SMPmatrix * , int , int );
int SMPmatSize(InstanceHandle inst,  SMPmatrix *);
int SMPnewMatrix(InstanceHandle inst,  SMPmatrix ** );
int SMPnewNode(InstanceHandle inst,  int , SMPmatrix *);
int SMPpreOrder(InstanceHandle inst,  SMPmatrix *);
void SMPprintWithRHS(InstanceHandle inst,  SMPmatrix * , double const* rhs, double const* irhs, FILE *);
void SMPprint(InstanceHandle inst,  SMPmatrix * , FILE *);
int SMPreorder(InstanceHandle inst,  SMPmatrix * , double , double , double );
void SMProwSwap(InstanceHandle inst,  SMPmatrix * , int , int );
void SMPsolve(InstanceHandle inst,  SMPmatrix *, double [], double []);

#endif /*SMP*/
